/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.test;

import brachy.modularui.ModularUI;
import brachy.modularui.ModularUIConfig;
import brachy.modularui.api.IThemeApi;
import brachy.modularui.api.drawable.IDrawable;
import brachy.modularui.api.drawable.IIcon;
import brachy.modularui.api.drawable.IKey;
import brachy.modularui.api.widget.IWidget;
import brachy.modularui.drawable.GuiDraw;
import brachy.modularui.drawable.GuiTextures;
import brachy.modularui.factory.ClientGUI;
import brachy.modularui.screen.CustomModularScreen;
import brachy.modularui.screen.ModularPanel;
import brachy.modularui.screen.ModularScreen;
import brachy.modularui.screen.OpenScreenEvent;
import brachy.modularui.screen.event.RichTooltipEvent;
import brachy.modularui.screen.viewport.GuiContext;
import brachy.modularui.screen.viewport.ModularGuiContext;
import brachy.modularui.test.TestGuis;
import brachy.modularui.theme.ReloadThemeEvent;
import brachy.modularui.theme.SelectableTheme;
import brachy.modularui.theme.ThemeBuilder;
import brachy.modularui.theme.WidgetTheme;
import brachy.modularui.utils.Color;
import brachy.modularui.widget.Widget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="modularui", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientTestEventHandler {
    public static boolean enabledRichTooltipEventTest = false;
    public static final String TEST_THEME = "mui:test_theme";
    private static final ThemeBuilder<?> testTheme = ((ThemeBuilder)((ThemeBuilder)((ThemeBuilder)new ThemeBuilder("mui:test_theme").defaultColor(Color.BLUE_ACCENT.brighter(0))).widgetTheme(IThemeApi.TOGGLE_BUTTON, ((SelectableTheme.Builder)((SelectableTheme.Builder)new SelectableTheme.Builder().color(Color.BLUE_ACCENT.brighter(0))).selectedColor(Color.WHITE.main)).selectedIconColor(Color.RED.brighter(0)))).widgetThemeHover(IThemeApi.TOGGLE_BUTTON, new SelectableTheme.Builder().selectedIconColor(Color.DEEP_PURPLE.brighter(0)))).textColor(IThemeApi.TEXT_FIELD, Color.DEEP_PURPLE.main);
    private static final IIcon tooltipLine = new IDrawable(){

        @Override
        public void draw(GuiContext context, int x, int y, int width, int height, WidgetTheme widgetTheme) {
            int high = Color.PURPLE.main;
            int low = Color.withAlpha(high, 0.05f);
            GuiDraw.drawHorizontalGradientRect(context.getGraphics(), x, y + 1, (float)width / 2.0f, 1.0f, low, high);
            GuiDraw.drawHorizontalGradientRect(context.getGraphics(), (float)x + (float)width / 2.0f, y + 1, (float)width / 2.0f, 1.0f, high, low);
        }
    }.asIcon().height(3);

    @SubscribeEvent
    public static void onItemUse(PlayerInteractEvent.RightClickItem event) {
        ItemStack itemStack;
        if (event.getEntity().m_9236_().f_46443_ && ModularUI.isDev() && (itemStack = event.getItemStack()).m_41720_() == Items.f_42415_) {
            ClientGUI.open(new TestGuis());
        }
    }

    @SubscribeEvent
    public static void onRichTooltip(RichTooltipEvent.Pre event) {
        if (enabledRichTooltipEventTest && ModularUI.isDev()) {
            event.getTooltip().add(IKey.str("Powered By: ").style(IKey.GOLD, IKey.ITALIC)).add(GuiTextures.MUI_LOGO.asIcon().size(18)).newLine().moveCursorToStart().moveCursorToNextLine().addLine(tooltipLine).replace("Minecraft", key -> IKey.str("Chicken Jockey").style(IKey.BLUE, IKey.ITALIC)).moveCursorToEnd();
        }
    }

    @SubscribeEvent
    public static void onThemeReload(ReloadThemeEvent.Pre event) {
        if (ModularUI.isDev()) {
            IThemeApi.get().registerTheme(testTheme);
        }
    }

    @SubscribeEvent
    public static void onOpenScreen(OpenScreenEvent event) {
        Screen screen;
        if (ModularUIConfig.enableTestOverlays() && (screen = event.getScreen()) instanceof AbstractContainerScreen) {
            AbstractContainerScreen gui = (AbstractContainerScreen)screen;
            event.addOverlay(ClientTestEventHandler.getContainerOverlayTest(gui));
        }
    }

    private static ModularScreen getContainerOverlayTest(final AbstractContainerScreen<?> gui) {
        return new CustomModularScreen("modularui"){

            @Override
            @NotNull
            public ModularPanel buildUI(ModularGuiContext context) {
                return (ModularPanel)((ModularPanel)ModularPanel.defaultPanel("watermark_overlay", gui.getXSize(), gui.getYSize()).pos(gui.getGuiLeft(), gui.getGuiTop())).invisible().child((IWidget)((Widget)((Widget)GuiTextures.MUI_LOGO.asIcon().asWidget().top(5)).right(5)).size(18));
            }

            @Override
            public void onResize(int width, int height) {
                ((ModularPanel)this.getMainPanel().pos(gui.getGuiLeft(), gui.getGuiTop())).size(gui.getXSize(), gui.getYSize());
                super.onResize(width, height);
            }
        };
    }
}

