/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.screen.viewport;

import brachy.modularui.api.layout.IViewport;
import brachy.modularui.api.widget.IWidget;
import brachy.modularui.screen.ModularPanel;
import brachy.modularui.screen.viewport.GuiViewportStack;
import brachy.modularui.screen.viewport.LocatedElement;
import brachy.modularui.screen.viewport.TransformationMatrix;
import it.unimi.dsi.fastutil.Hash;
import java.util.ArrayList;
import java.util.Objects;
import lombok.Generated;

public class LocatedWidget
extends LocatedElement<IWidget> {
    public static final Hash.Strategy<LocatedWidget> HASH_STRATEGY = new HashStrategy();
    private static final GuiViewportStack STACK = new GuiViewportStack();
    public static final LocatedWidget EMPTY = new LocatedWidget(null, TransformationMatrix.EMPTY, null);
    private final Object additionalHoverInfo;

    public static LocatedWidget of(IWidget widget) {
        if (widget == null) {
            return EMPTY;
        }
        IWidget parent = widget;
        ArrayList<IWidget> ancestors = new ArrayList<IWidget>();
        while (true) {
            ancestors.add(0, parent);
            if (parent instanceof ModularPanel) break;
            parent = parent.getParent();
        }
        STACK.reset();
        for (IWidget widget1 : ancestors) {
            if (widget1 instanceof IViewport) {
                IViewport viewport = (IViewport)widget1;
                STACK.pushViewport(viewport, widget1.getArea());
                widget1.transform(STACK);
                viewport.transformChildren(STACK);
                continue;
            }
            STACK.pushMatrix();
            widget1.transform(STACK);
        }
        return new LocatedWidget(widget, STACK.peek(), null);
    }

    public LocatedWidget(IWidget element, TransformationMatrix transformationMatrix, Object additionalHoverInfo) {
        super(element, transformationMatrix);
        this.additionalHoverInfo = additionalHoverInfo;
    }

    @Override
    public String toString() {
        return "LocatedWidget[" + String.valueOf(this.getElement()) + " | " + String.valueOf(this.additionalHoverInfo) + "]";
    }

    @Generated
    public Object getAdditionalHoverInfo() {
        return this.additionalHoverInfo;
    }

    public static class HashStrategy
    implements Hash.Strategy<LocatedWidget> {
        public int hashCode(LocatedWidget o) {
            return Objects.hashCode(o == null ? null : o.getElement());
        }

        public boolean equals(LocatedWidget a, LocatedWidget b) {
            if (a == b) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            return Objects.equals(a.getElement(), b.getElement());
        }
    }
}

