/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.screen.viewport;

import brachy.modularui.screen.viewport.GuiContext;
import brachy.modularui.screen.viewport.TransformationMatrix;
import it.unimi.dsi.fastutil.Hash;
import java.util.Objects;
import lombok.Generated;

public class LocatedElement<T> {
    private final T element;
    private final TransformationMatrix transformationMatrix;

    public LocatedElement(T element, TransformationMatrix transformationMatrix) {
        this.element = element;
        this.transformationMatrix = new TransformationMatrix(transformationMatrix, null);
    }

    public void applyMatrix(GuiContext context) {
        context.push(this.transformationMatrix);
    }

    public void unapplyMatrix(GuiContext context) {
        context.pop(this.transformationMatrix);
    }

    public String toString() {
        return "LocatedElement[" + String.valueOf(this.getElement()) + "]";
    }

    public LocatedElementHashStrategy<T> createHashStrategy() {
        return new LocatedElementHashStrategy();
    }

    @Generated
    public T getElement() {
        return this.element;
    }

    @Generated
    public TransformationMatrix getTransformationMatrix() {
        return this.transformationMatrix;
    }

    public static class LocatedElementHashStrategy<T>
    implements Hash.Strategy<LocatedElement<T>> {
        public int hashCode(LocatedElement<T> o) {
            return Objects.hashCode(o == null ? null : o.element);
        }

        public boolean equals(LocatedElement<T> a, LocatedElement<T> b) {
            if (a == b) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            return Objects.equals(a.element, b.element);
        }
    }
}

