/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.screen;

import brachy.modularui.api.IPanelHandler;
import brachy.modularui.api.MCHelper;
import brachy.modularui.screen.ModularPanel;
import brachy.modularui.screen.ModularScreen;
import brachy.modularui.widget.WidgetTree;
import java.util.Objects;
import lombok.Generated;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

public class SecondaryPanel
implements IPanelHandler {
    private final ModularPanel parent;
    private final IPanelBuilder provider;
    private final boolean subPanel;
    private ModularScreen screen;
    private ModularPanel panel;
    private boolean open = false;
    private boolean queueDelete = false;

    public SecondaryPanel(ModularPanel parent, IPanelBuilder provider, boolean subPanel) {
        this.parent = parent;
        this.provider = provider;
        this.subPanel = subPanel;
        parent.registerSubPanel(this);
    }

    @Override
    public void closePanel() {
        if (!this.open) {
            return;
        }
        this.panel.closeIfOpen();
    }

    @Override
    public void closeSubPanels() {
        if (this.panel != null) {
            this.panel.closeClientSubPanels();
        }
    }

    @Override
    @ApiStatus.Internal
    public void closePanelInternal() {
        this.open = false;
        if (this.queueDelete) {
            this.panel = null;
            this.queueDelete = false;
        }
    }

    @Override
    public void deleteCachedPanel() {
        if (this.open) {
            this.queueDelete = true;
        } else {
            this.panel = null;
        }
    }

    @Override
    public boolean isSubPanel() {
        return this.subPanel;
    }

    @Override
    public boolean isPanelOpen() {
        return this.open;
    }

    @Override
    public void openPanel() {
        if (this.open) {
            return;
        }
        if (this.screen != this.parent.getScreen()) {
            this.screen = this.parent.getScreen();
        }
        if (this.panel == null) {
            this.panel = this.buildPanel();
            if (this.panel == this.screen.getMainPanel()) {
                throw new IllegalArgumentException("Must not return main panel!");
            }
            if (WidgetTree.hasSyncedValues(this.panel)) {
                throw new IllegalArgumentException("Panel has widgets with synced values, but the panel is not synced!");
            }
            this.panel.setPanelHandler(this);
        }
        this.screen.getPanelManager().openPanel(this.panel, this);
        this.open = true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private ModularPanel buildPanel() {
        return Objects.requireNonNull(this.provider.build(this.screen.getMainPanel(), MCHelper.getPlayer()));
    }

    @Generated
    public ModularPanel getParent() {
        return this.parent;
    }

    public static interface IPanelBuilder {
        public ModularPanel build(ModularPanel var1, Player var2);
    }
}

