/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.screen;

import brachy.modularui.api.RecipeViewerSettings;
import brachy.modularui.api.widget.IWidget;
import brachy.modularui.integration.recipeviewer.RecipeViewerState;
import brachy.modularui.integration.recipeviewer.handlers.GhostIngredientSlot;
import brachy.modularui.screen.ModularScreen;
import brachy.modularui.utils.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.UnmodifiableView;

@OnlyIn(value=Dist.CLIENT)
public class RecipeViewerSettingsImpl
implements RecipeViewerSettings {
    private RecipeViewerState recipeViewerState = RecipeViewerState.DEFAULT;
    private final List<IWidget> exclusionWidgets = new ArrayList<IWidget>();
    private final List<Rectangle> exclusionAreas = new ArrayList<Rectangle>();
    private final List<GhostIngredientSlot<?>> ghostIngredientSlots = new ArrayList();

    @Override
    public void enable() {
        this.recipeViewerState = RecipeViewerState.ENABLED;
    }

    @Override
    public void disable() {
        this.recipeViewerState = RecipeViewerState.DISABLED;
    }

    @Override
    public void defaultState() {
        this.recipeViewerState = RecipeViewerState.DEFAULT;
    }

    @Override
    public boolean isEnabled(ModularScreen screen) {
        return this.recipeViewerState.test(screen);
    }

    @Override
    public void addExclusionArea(Rectangle area) {
        if (!this.exclusionAreas.contains(area)) {
            this.exclusionAreas.add(area);
        }
    }

    @Override
    public void removeExclusionArea(Rectangle area) {
        this.exclusionAreas.remove(area);
    }

    @Override
    public void addExclusionArea(IWidget area) {
        if (!this.exclusionWidgets.contains(area)) {
            this.exclusionWidgets.add(area);
        }
    }

    @Override
    public void removeExclusionArea(IWidget area) {
        this.exclusionWidgets.remove(area);
    }

    @Override
    public <W extends IWidget & GhostIngredientSlot<?>> void addGhostIngredientSlot(W slot) {
        if (!this.ghostIngredientSlots.contains(slot)) {
            this.ghostIngredientSlots.add(slot);
        }
    }

    @Override
    public <W extends IWidget & GhostIngredientSlot<?>> void removeGhostIngredientSlot(W slot) {
        this.ghostIngredientSlots.remove(slot);
    }

    public @UnmodifiableView List<Rectangle> getExclusionAreas() {
        return Collections.unmodifiableList(this.exclusionAreas);
    }

    public @UnmodifiableView List<IWidget> getExclusionWidgets() {
        return Collections.unmodifiableList(this.exclusionWidgets);
    }

    public @UnmodifiableView List<GhostIngredientSlot<?>> getGhostIngredientSlots() {
        return Collections.unmodifiableList(this.ghostIngredientSlots);
    }

    @ApiStatus.Internal
    public List<Rectangle> getAllExclusionAreas() {
        this.exclusionWidgets.removeIf(widget -> !widget.isValid());
        ArrayList<Rectangle> areas = new ArrayList<Rectangle>(this.exclusionAreas);
        Iterator<IWidget> iterator = this.exclusionWidgets.iterator();
        while (iterator.hasNext()) {
            IWidget widget2 = iterator.next();
            if (!widget2.isValid()) {
                iterator.remove();
                continue;
            }
            if (!widget2.isEnabled()) continue;
            areas.add(widget2.getArea());
        }
        return areas;
    }
}

