/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.screen;

import brachy.modularui.GuiErrorHandler;
import brachy.modularui.ModularUI;
import brachy.modularui.ModularUIConfig;
import brachy.modularui.api.IMuiScreen;
import brachy.modularui.api.ITheme;
import brachy.modularui.api.MCHelper;
import brachy.modularui.api.widget.IVanillaSlot;
import brachy.modularui.api.widget.IWidget;
import brachy.modularui.api.widget.Interactable;
import brachy.modularui.core.mixins.client.AbstractContainerScreenAccessor;
import brachy.modularui.core.mixins.client.ScreenAccessor;
import brachy.modularui.drawable.GuiDraw;
import brachy.modularui.integration.recipeviewer.handlers.RecipeViewerHandler;
import brachy.modularui.network.ModularNetwork;
import brachy.modularui.overlay.OverlayStack;
import brachy.modularui.screen.IClickableContainerScreen;
import brachy.modularui.screen.ModularScreen;
import brachy.modularui.screen.viewport.GuiContext;
import brachy.modularui.screen.viewport.LocatedWidget;
import brachy.modularui.screen.viewport.ModularGuiContext;
import brachy.modularui.utils.Color;
import brachy.modularui.utils.FpsCounter;
import brachy.modularui.utils.Stencil;
import brachy.modularui.widget.sizer.Area;
import brachy.modularui.widgets.RichTextWidget;
import brachy.modularui.widgets.slot.ItemSlot;
import brachy.modularui.widgets.slot.ModularSlot;
import brachy.modularui.widgets.slot.SlotGroup;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ContainerScreenEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

@Mod.EventBusSubscriber(modid="modularui", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
@ApiStatus.Internal
public class ClientScreenHandler {
    private static final GuiContext defaultContext = new GuiContext();
    private static final FpsCounter fpsCounter = new FpsCounter();
    private static ModularScreen currentScreen = null;
    private static long ticks = 0L;
    private static IMuiScreen lastMui;
    private static final ObjectArrayList<IMuiScreen> muiStack;
    private static boolean debugToggleActive;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onOpenScreen(ScreenEvent.Opening event) {
        ClientScreenHandler.onGuiChanged(event.getCurrentScreen(), event.getNewScreen());
    }

    @SubscribeEvent
    public static void onInitScreenPost(ScreenEvent.Init.Post event) {
        defaultContext.updateScreenArea(event.getScreen().f_96543_, event.getScreen().f_96544_);
        if (ClientScreenHandler.validateGui(event.getScreen())) {
            currentScreen.onResize(event.getScreen().f_96543_, event.getScreen().f_96544_);
        }
        OverlayStack.foreach((ModularScreen ms) -> ms.onResize(event.getScreen().f_96543_, event.getScreen().f_96544_), false);
    }

    @SubscribeEvent
    public static void onScreenKeyPressedHigh(ScreenEvent.KeyPressed.Pre event) {
        defaultContext.updateLatestKey(event.getKeyCode(), event.getScanCode(), event.getModifiers());
        if (ClientScreenHandler.keyPressedEvent(event, InputPhase.EARLY)) {
            ClientScreenHandler.keyPressedEvent(event, InputPhase.LATE);
        }
    }

    private static boolean keyPressedEvent(ScreenEvent.KeyPressed.Pre event, InputPhase phase) {
        if (ClientScreenHandler.validateGui(event.getScreen())) {
            currentScreen.getContext().updateLatestKey(event.getKeyCode(), event.getScanCode(), event.getModifiers());
        }
        if (ClientScreenHandler.handleKeyboardInput(currentScreen, event.getScreen(), true, phase, event.getKeyCode(), event.getScanCode(), event.getModifiers())) {
            event.setCanceled(true);
            return false;
        }
        return true;
    }

    @SubscribeEvent
    public static void onScreenKeyReleasedHigh(ScreenEvent.KeyReleased.Pre event) {
        defaultContext.updateLatestKey(event.getKeyCode(), event.getScanCode(), event.getModifiers());
        ClientScreenHandler.keyReleasedEvent(event, InputPhase.EARLY);
    }

    private static boolean keyReleasedEvent(ScreenEvent.KeyReleased.Pre event, InputPhase phase) {
        if (ClientScreenHandler.validateGui(event.getScreen())) {
            currentScreen.getContext().updateLatestKey(event.getKeyCode(), event.getScanCode(), event.getModifiers());
        }
        if (ClientScreenHandler.handleKeyboardInput(currentScreen, event.getScreen(), false, phase, event.getKeyCode(), event.getScanCode(), event.getModifiers())) {
            event.setCanceled(true);
            return false;
        }
        return true;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onScreenCharTyped(ScreenEvent.CharacterTyped.Pre event) {
        char codePoint = event.getCodePoint();
        int modifiers = event.getModifiers();
        defaultContext.updateLatestTypedChar(codePoint, modifiers);
        if (ClientScreenHandler.validateGui(event.getScreen())) {
            currentScreen.getContext().updateLatestTypedChar(codePoint, modifiers);
        }
        if (ClientScreenHandler.doAction(currentScreen, ms -> ms.m_5534_(codePoint, modifiers))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onScreenMousePressed(ScreenEvent.MouseButtonPressed.Pre event) {
        int button = event.getButton();
        double mouseX = event.getMouseX();
        double mouseY = event.getMouseY();
        defaultContext.updateMouseButton(button);
        if (ClientScreenHandler.validateGui(event.getScreen())) {
            currentScreen.getContext().updateMouseButton(button);
        }
        if (button == -1) {
            return;
        }
        if (currentScreen != null && currentScreen.handleDraggableInput(mouseX, mouseY, button, true) || ClientScreenHandler.doAction(currentScreen, ms -> ms.onMousePressed(mouseX, mouseY, button))) {
            RecipeViewerHandler.getCurrent().setSearchFocused(false);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onScreenMouseReleased(ScreenEvent.MouseButtonReleased.Pre event) {
        int button = event.getButton();
        double mouseX = event.getMouseX();
        double mouseY = event.getMouseY();
        defaultContext.updateMouseButton(button);
        if (ClientScreenHandler.validateGui(event.getScreen())) {
            currentScreen.getContext().updateMouseButton(button);
        }
        if (currentScreen != null && currentScreen.handleDraggableInput(mouseX, mouseY, button, false) || ClientScreenHandler.doAction(currentScreen, ms -> ms.m_6348_(mouseX, mouseY, button))) {
            RecipeViewerHandler.getCurrent().setSearchFocused(false);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onScreenMouseScrolled(ScreenEvent.MouseScrolled.Pre event) {
        double w = event.getScrollDelta();
        if (w == 0.0) {
            return;
        }
        defaultContext.updateMouseWheel(w);
        if (ClientScreenHandler.validateGui(event.getScreen())) {
            currentScreen.getContext().updateMouseWheel(w);
        }
        if (ClientScreenHandler.doAction(currentScreen, ms -> ms.m_6050_(event.getMouseX(), event.getMouseY(), w))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onScreenMouseDragged(ScreenEvent.MouseDragged.Pre event) {
        if (ClientScreenHandler.doAction(currentScreen, ms -> ms.m_7979_(event.getMouseX(), event.getMouseY(), event.getMouseButton(), event.getDragX(), event.getDragY()))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onScreenRenderLow(ScreenEvent.Render.Pre event) {
        int mx = event.getMouseX();
        int my = event.getMouseY();
        float pt = event.getPartialTick();
        GuiGraphics gc = event.getGuiGraphics();
        defaultContext.setGraphics(gc);
        defaultContext.updateState(mx, my, pt);
        defaultContext.reset();
        if (ClientScreenHandler.validateGui(event.getScreen())) {
            currentScreen.getContext().setGraphics(gc);
            currentScreen.getContext().updateState(mx, my, pt);
            ClientScreenHandler.drawScreen(gc, currentScreen, currentScreen.getScreenWrapper().wrappedScreen(), mx, my, pt);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onScreenRenderNormal(ScreenEvent.Render.Post event) {
        OverlayStack.draw(event.getGuiGraphics(), event.getMouseX(), event.getMouseY(), event.getPartialTick());
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            OverlayStack.onTick();
            defaultContext.tick();
            if (ClientScreenHandler.validateGui()) {
                currentScreen.onUpdate();
            }
            ++ticks;
        }
    }

    @SubscribeEvent
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            GL11.glEnable((int)2960);
        }
        Stencil.reset();
    }

    public static void onFrameUpdate() {
        OverlayStack.foreach(ModularScreen::onFrameUpdate, true);
        if (currentScreen != null) {
            currentScreen.onFrameUpdate();
        }
    }

    private static void onGuiChanged(Screen oldScreen, Screen newScreen) {
        if (oldScreen == newScreen) {
            return;
        }
        defaultContext.reset();
        fpsCounter.reset();
        GuiErrorHandler.INSTANCE.clear();
        IMuiScreen lastLastMui = lastMui;
        if (lastMui != null) {
            ClientScreenHandler.invalidateCurrentScreen();
        }
        if (newScreen instanceof IMuiScreen) {
            Screen lastParent;
            IMuiScreen muiScreen;
            lastMui = muiScreen = (IMuiScreen)newScreen;
            currentScreen = muiScreen.screen();
            muiStack.remove((Object)muiScreen);
            muiStack.add((Object)muiScreen);
            Screen screen = lastParent = lastLastMui != null ? lastLastMui.screen().getContext().getParent() : null;
            if (lastParent != muiScreen) {
                currentScreen.getContext().setParent(oldScreen);
            } else {
                muiStack.remove((Object)lastLastMui);
                lastLastMui.screen().getPanelManager().dispose();
            }
        } else if (newScreen == null) {
            ClientScreenHandler.invalidateMuiStack();
            ModularNetwork.CLIENT.closeAll();
        }
        OverlayStack.onOpenScreen(newScreen);
    }

    private static void invalidateCurrentScreen() {
        if (lastMui != null) {
            lastMui.screen().getPanelManager().closeScreen();
            lastMui = null;
        }
        currentScreen = null;
    }

    private static void invalidateMuiStack() {
        muiStack.forEach(muiScreen -> muiScreen.screen().getPanelManager().dispose());
        muiStack.clear();
    }

    private static boolean doAction(@Nullable ModularScreen muiScreen, Predicate<ModularScreen> action) {
        return OverlayStack.interact(action, true) || muiScreen != null && action.test(muiScreen);
    }

    private static void foreach(@Nullable ModularScreen muiScreen, Consumer<ModularScreen> action) {
        OverlayStack.foreach(action, true);
        if (muiScreen != null) {
            action.accept(muiScreen);
        }
    }

    private static boolean handleKeyboardInput(@Nullable ModularScreen muiScreen, Screen mcScreen, boolean isPress, InputPhase inputPhase, int keyCode, int scanCode, int modifiers) {
        if (isPress) {
            return inputPhase.isEarly() ? ClientScreenHandler.doAction(muiScreen, ms -> ms.m_7933_(keyCode, scanCode, modifiers)) : ClientScreenHandler.keyTyped(mcScreen, keyCode, scanCode, modifiers);
        }
        return inputPhase.isEarly() && ClientScreenHandler.doAction(muiScreen, ms -> ms.m_7920_(keyCode, scanCode, modifiers));
    }

    private static boolean keyTyped(Screen screen, int keyCode, int scanCode, int modifiers) {
        if (currentScreen == null) {
            return false;
        }
        if (keyCode == 67 && Interactable.isControl(modifiers) && Interactable.isShift(modifiers) && Interactable.isAlt(modifiers)) {
            if (!debugToggleActive) {
                ModularUIConfig.DEBUG_UI.set((Object)(!ModularUIConfig.Dev.debugUI() ? 1 : 0));
                debugToggleActive = true;
            }
            return true;
        }
        debugToggleActive = false;
        if (keyCode == 256 && screen.m_6913_()) {
            ClientScreenHandler.onClose();
            return true;
        }
        boolean isInventoryKey = Minecraft.m_91087_().f_91066_.f_92092_.isActiveAndMatches(InputConstants.m_84827_((int)keyCode, (int)scanCode));
        if (keyCode == 1 || isInventoryKey) {
            ClientScreenHandler.onClose();
            return true;
        }
        return false;
    }

    private static void onClose() {
        if (currentScreen.getContext().hasDraggable()) {
            currentScreen.getContext().dropDraggable(true);
        } else {
            currentScreen.getPanelManager().closeTopPanel();
        }
    }

    public static void dragSlot(double mouseX, double mouseY, int button, double dragX, double dragY) {
        ModularGuiContext ctx = currentScreen.getContext();
        ClientScreenHandler.getMCScreen().m_7979_((double)ctx.getMouseX(), (double)ctx.getMouseY(), button, dragX, dragY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clickSlot(ModularScreen ms, Slot slot) {
        Screen screen = ms.getScreenWrapper().wrappedScreen();
        if (screen instanceof ScreenAccessor) {
            ScreenAccessor acc = (ScreenAccessor)screen;
            if (screen instanceof IClickableContainerScreen) {
                IClickableContainerScreen clickableScreen = (IClickableContainerScreen)screen;
                if (ClientScreenHandler.validateGui(screen)) {
                    ModularGuiContext ctx = ms.getContext();
                    List buttonList = screen.m_6702_();
                    try {
                        acc.setChildren(Collections.emptyList());
                        clickableScreen.gtceu$setClickedSlot(slot);
                        screen.m_6375_((double)ctx.getMouseX(), (double)ctx.getMouseY(), ctx.getMouseButton());
                    }
                    finally {
                        clickableScreen.gtceu$setClickedSlot(null);
                        acc.setChildren(buttonList);
                    }
                }
            }
        }
    }

    public static void releaseSlot() {
        if (ClientScreenHandler.hasScreen() && ClientScreenHandler.getMCScreen() != null) {
            ModularGuiContext ctx = currentScreen.getContext();
            ClientScreenHandler.getMCScreen().m_6348_((double)ctx.getMouseX(), (double)ctx.getMouseY(), ctx.getMouseButton());
        }
    }

    public static boolean shouldDrawWorldBackground() {
        return Minecraft.m_91087_().f_91073_ == null;
    }

    public static void drawDarkBackground(Screen screen, GuiGraphics guiGraphics) {
        if (ClientScreenHandler.hasScreen()) {
            float alpha = currentScreen.getMainPanel().getAlpha();
            int color = 0x101010;
            int startAlpha = 192;
            int endAlpha = 208;
            guiGraphics.m_280024_(0, 0, screen.f_96543_, screen.f_96544_, Color.withAlpha(color, (int)((float)startAlpha * alpha)), Color.withAlpha(color, (int)((float)endAlpha * alpha)));
            MinecraftForge.EVENT_BUS.post((Event)new ScreenEvent.BackgroundRendered(screen, guiGraphics));
        }
    }

    public static void drawScreen(GuiGraphics graphics, ModularScreen muiScreen, Screen mcScreen, int mouseX, int mouseY, float partialTicks) {
        if (mcScreen instanceof AbstractContainerScreen) {
            AbstractContainerScreen container = (AbstractContainerScreen)mcScreen;
            ClientScreenHandler.drawContainer(graphics, muiScreen, container, mouseX, mouseY, partialTicks);
        } else {
            ClientScreenHandler.drawScreenInternal(graphics, muiScreen, mcScreen, mouseX, mouseY, partialTicks);
        }
    }

    public static void drawScreenInternal(GuiGraphics graphics, ModularScreen muiScreen, Screen mcScreen, int mouseX, int mouseY, float partialTicks) {
        Stencil.reset();
        muiScreen.getContext().getStencil().push(muiScreen.getScreenArea());
        muiScreen.m_88315_(graphics, mouseX, mouseY, partialTicks);
        RenderSystem.disableDepthTest();
        ClientScreenHandler.drawVanillaElements(graphics, mcScreen, mouseX, mouseY, partialTicks);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Lighting.m_84930_();
        muiScreen.drawForeground(graphics, partialTicks);
        RenderSystem.enableDepthTest();
        Lighting.m_84931_();
        muiScreen.getContext().getStencil().pop();
    }

    public static void drawContainer(GuiGraphics graphics, ModularScreen muiScreen, AbstractContainerScreen<?> mcScreen, int mouseX, int mouseY, float partialTicks) {
        ItemStack draggingItem;
        IVanillaSlot vanillaSlot;
        AbstractContainerScreenAccessor acc = (AbstractContainerScreenAccessor)mcScreen;
        Stencil.reset();
        muiScreen.getContext().getStencil().push(muiScreen.getScreenArea());
        mcScreen.m_280273_(graphics);
        int x = mcScreen.getGuiLeft();
        int y = mcScreen.getGuiTop();
        acc.invokeRenderBg(graphics, partialTicks, mouseX, mouseY);
        muiScreen.m_88315_(graphics, mouseX, mouseY, partialTicks);
        RenderSystem.disableDepthTest();
        ClientScreenHandler.drawVanillaElements(graphics, mcScreen, mouseX, mouseY, partialTicks);
        acc.setHoveredSlot(null);
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        Lighting.m_84930_();
        acc.setHoveredSlot(null);
        IWidget hovered = muiScreen.getContext().getTopHovered();
        if (hovered instanceof IVanillaSlot && (vanillaSlot = (IVanillaSlot)((Object)hovered)).handleAsVanillaSlot()) {
            acc.setHoveredSlot(vanillaSlot.getVanillaSlot());
        }
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)x, (float)y, 0.0f);
        MinecraftForge.EVENT_BUS.post((Event)new ContainerScreenEvent.Render.Foreground(mcScreen, graphics, mouseX, mouseY));
        AbstractContainerMenu menu = mcScreen.m_6262_();
        ItemStack itemStack = draggingItem = acc.getDraggingItem().m_41619_() ? menu.m_142621_() : acc.getDraggingItem();
        if (!draggingItem.m_41619_()) {
            int xOffset = 8;
            int yOffset = acc.getDraggingItem().m_41619_() ? 8 : 16;
            String text = null;
            if (!acc.getDraggingItem().m_41619_() && acc.getIsSplittingStack()) {
                draggingItem = draggingItem.m_255036_(Mth.m_14167_((float)((float)draggingItem.m_41613_() / 2.0f)));
            } else if (acc.getIsQuickCrafting() && acc.getQuickCraftSlots().size() > 1 && (draggingItem = draggingItem.m_255036_(acc.getQuickCraftingRemainder())).m_41619_()) {
                text = String.valueOf(ChatFormatting.YELLOW) + "0";
            }
            ClientScreenHandler.drawFloatingItemStack(mcScreen, graphics, draggingItem, mouseX - x - xOffset, mouseY - y - yOffset, text);
        }
        graphics.m_280168_().m_85849_();
        if (!acc.getSnapbackItem().m_41619_()) {
            float delta = (float)(Util.m_137550_() - acc.getSnapbackTime()) / 100.0f;
            if (delta >= 1.0f) {
                delta = 1.0f;
                acc.setSnapbackItem(ItemStack.f_41583_);
            }
            int snapBackOffsetX = acc.getSnapbackEnd().f_40220_ - acc.getSnapbackStartX();
            int snapBackOffsetY = acc.getSnapbackEnd().f_40221_ - acc.getSnapbackStartY();
            int snapBackX = acc.getSnapbackStartX() + (int)((float)snapBackOffsetX * delta);
            int snapBackY = acc.getSnapbackStartY() + (int)((float)snapBackOffsetY * delta);
            ClientScreenHandler.drawFloatingItemStack(mcScreen, graphics, acc.getSnapbackItem(), snapBackX, snapBackY, null);
        }
        muiScreen.drawForeground(graphics, partialTicks);
        RenderSystem.enableDepthTest();
        Lighting.m_84931_();
        muiScreen.getContext().getStencil().pop();
    }

    private static void drawFloatingItemStack(AbstractContainerScreen<?> mcScreen, GuiGraphics graphics, ItemStack stack, int x, int y, String altText) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 232.0f);
        Font font = IClientItemExtensions.of((ItemStack)stack).getFont(stack, IClientItemExtensions.FontContext.ITEM_COUNT);
        if (font == null) {
            font = ((ScreenAccessor)mcScreen).getFont();
        }
        graphics.m_280480_(stack, x, y);
        graphics.m_280302_(font, stack, x, y - (((AbstractContainerScreenAccessor)mcScreen).getDraggingItem().m_41619_() ? 0 : 8), altText);
        graphics.m_280168_().m_85849_();
    }

    @ApiStatus.Internal
    public static void drawVanillaElements(GuiGraphics graphics, Screen mcScreen, int mouseX, int mouseY, float partialTicks) {
        for (Renderable renderable : mcScreen.f_169369_) {
            renderable.m_88315_(graphics, mouseX, mouseY, partialTicks);
        }
    }

    public static void drawDebugScreen(GuiGraphics graphics, @Nullable ModularScreen muiScreen, @Nullable ModularScreen fallback) {
        fpsCounter.onDraw();
        if (!ModularUIConfig.Dev.debugUI()) {
            return;
        }
        if (muiScreen == null) {
            if (ClientScreenHandler.validateGui()) {
                muiScreen = currentScreen;
            } else {
                if (fallback == null) {
                    return;
                }
                muiScreen = fallback;
            }
        }
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        ModularGuiContext context = muiScreen.getContext();
        Matrix4f pose = graphics.m_280168_().m_85850_().m_252922_();
        int mouseX = context.getAbsMouseX();
        int mouseY = context.getAbsMouseY();
        int screenH = muiScreen.getScreenArea().height;
        int outlineColor = ModularUIConfig.Dev.outlineColor();
        int textColor = ModularUIConfig.Dev.textColor();
        float scale = ModularUIConfig.Dev.scale();
        int shift = (int)(11.0f * scale + 0.5f);
        int lineY = screenH - shift - 2;
        if (ModularUI.Mods.isRecipeViewerLoaded() && muiScreen.getContext().hasSettings() && muiScreen.getContext().getRecipeViewerSettings().isEnabled(muiScreen)) {
            lineY -= 12;
        }
        GuiDraw.drawText(graphics, "Mouse Pos: " + mouseX + ", " + mouseY, 5.0f, (float)lineY, scale, outlineColor, false);
        GuiDraw.drawText(graphics, "FPS: " + fpsCounter.getFps(), 5.0f, (float)(lineY -= shift), scale, outlineColor, false);
        LocatedWidget locatedHovered = muiScreen.getPanelManager().getTopWidgetLocated(true);
        boolean showHovered = ModularUIConfig.Dev.showHovered();
        boolean showParent = ModularUIConfig.Dev.showParent();
        ITheme theme = locatedHovered != null && (showHovered || showParent) ? ((IWidget)locatedHovered.getElement()).getPanel().getTheme() : context.getTheme();
        GuiDraw.drawText(graphics, "Theme ID: " + theme.getId(), 5.0f, (float)(lineY -= shift), scale, outlineColor, false);
        if (locatedHovered != null && (showHovered || showParent)) {
            ClientScreenHandler.drawSegmentLine(graphics, lineY -= 4, scale, outlineColor);
            lineY -= 10;
            IWidget hovered = (IWidget)locatedHovered.getElement();
            locatedHovered.applyMatrix(context);
            graphics.m_280168_().m_85836_();
            context.applyTo(graphics.m_280168_());
            Area area = hovered.getArea();
            IWidget parent = hovered.getParent();
            if (showHovered && ModularUIConfig.Dev.showOutline()) {
                GuiDraw.drawBorderOutsideXYWH(graphics, 0.0f, 0.0f, area.width, area.height, scale, outlineColor);
            }
            if (hovered.hasParent() && showParent && ModularUIConfig.Dev.showParentOutline()) {
                GuiDraw.drawBorderOutsideXYWH(graphics, -area.rx, -area.ry, parent.getArea().width, parent.getArea().height, scale, Color.withAlpha(outlineColor, 0.3f));
            }
            graphics.m_280168_().m_85849_();
            locatedHovered.unapplyMatrix(context);
            if (showHovered) {
                if (ModularUIConfig.Dev.showWidgetTheme()) {
                    GuiDraw.drawText(graphics, "Widget Theme: " + hovered.getWidgetTheme(hovered.getPanel().getTheme()).key().getFullName(), 5.0f, (float)lineY, scale, textColor, false);
                    lineY -= shift;
                }
                if (ModularUIConfig.Dev.showSize()) {
                    GuiDraw.drawText(graphics, "Size: " + area.width + ", " + area.height, 5.0f, (float)lineY, scale, textColor, false);
                    lineY -= shift;
                }
                if (ModularUIConfig.Dev.showPos()) {
                    GuiDraw.drawText(graphics, "Pos: " + area.x + ", " + area.y + "  Rel: " + area.rx + ", " + area.ry, 5.0f, (float)lineY, scale, textColor, false);
                    lineY -= shift;
                }
                GuiDraw.drawText(graphics, "Widget: " + String.valueOf(hovered), 5.0f, (float)lineY, scale, textColor, false);
            }
            if (hovered.hasParent() && showParent) {
                if (showHovered) {
                    ClientScreenHandler.drawSegmentLine(graphics, lineY -= 4, scale, textColor);
                    lineY -= 10;
                }
                if (ModularUIConfig.Dev.showParentWidgetTheme()) {
                    GuiDraw.drawText(graphics, "Widget Theme: " + parent.getWidgetTheme(parent.getPanel().getTheme()).key().getFullName(), 5.0f, (float)lineY, scale, textColor, false);
                    lineY -= shift;
                }
                area = parent.getArea();
                if (ModularUIConfig.Dev.showParentSize()) {
                    GuiDraw.drawText(graphics, "Parent size: " + area.width + ", " + area.height, 5.0f, (float)lineY, scale, textColor, false);
                    lineY -= shift;
                }
                if (ModularUIConfig.Dev.showParentPos()) {
                    GuiDraw.drawText(graphics, "Parent pos: " + area.x + ", " + area.y + "  Rel: " + area.rx + ", " + area.ry, 5.0f, (float)lineY, scale, textColor, false);
                    lineY -= shift;
                }
                GuiDraw.drawText(graphics, "Parent: " + String.valueOf(parent), 5.0f, (float)lineY, scale, textColor, false);
            }
            if (ModularUIConfig.Dev.showExtra()) {
                if (hovered instanceof ItemSlot) {
                    ItemSlot slotWidget = (ItemSlot)hovered;
                    ClientScreenHandler.drawSegmentLine(graphics, lineY -= 4, scale, textColor);
                    ModularSlot slot = slotWidget.getSlot();
                    GuiDraw.drawText(graphics, "Slot Index: " + slot.getSlotIndex(), 5.0f, (float)(lineY -= 10), scale, textColor, false);
                    GuiDraw.drawText(graphics, "Slot Number: " + ((Slot)slot).f_40219_, 5.0f, (float)(lineY -= shift), scale, textColor, false);
                    lineY -= shift;
                    if (slotWidget.isSynced()) {
                        SlotGroup slotGroup = slot.getSlotGroup();
                        boolean allowShiftTransfer = slotGroup != null && slotGroup.isAllowShiftTransfer();
                        GuiDraw.drawText(graphics, "Shift-Click Priority: " + String.valueOf(allowShiftTransfer ? Integer.valueOf(slotGroup.getShiftClickPriority()) : "DISABLED"), 5.0f, (float)lineY, scale, textColor, false);
                    }
                } else if (hovered instanceof RichTextWidget) {
                    RichTextWidget richTextWidget = (RichTextWidget)hovered;
                    ClientScreenHandler.drawSegmentLine(graphics, lineY -= 4, scale, outlineColor);
                    locatedHovered.applyMatrix(context);
                    Object hoveredElement = richTextWidget.getHoveredElement();
                    locatedHovered.unapplyMatrix(context);
                    GuiDraw.drawText(graphics, "Hovered: " + String.valueOf(hoveredElement), 5.0f, (float)(lineY -= 10), scale, textColor, false);
                }
            }
        }
        GuiDraw.drawRect(graphics, mouseX, mouseY, 1.0f, 1.0f, ModularUIConfig.Dev.cursorColor());
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private static void drawSegmentLine(GuiGraphics graphics, int y, float scale, int color) {
        GuiDraw.drawRect(graphics, 5.0f, y, 140.0f * scale, 1.0f * scale, color);
    }

    public static boolean hasScreen() {
        return currentScreen != null;
    }

    @Nullable
    public static Screen getMCScreen() {
        return MCHelper.getCurrentScreen();
    }

    @Nullable
    public static ModularScreen getMuiScreen() {
        return currentScreen;
    }

    public static @UnmodifiableView List<IMuiScreen> getMuiStack() {
        return Collections.unmodifiableList(muiStack);
    }

    private static boolean validateGui() {
        return ClientScreenHandler.validateGui(MCHelper.getCurrentScreen());
    }

    private static boolean validateGui(Screen screen) {
        if (currentScreen == null || !(screen instanceof IMuiScreen)) {
            return false;
        }
        IMuiScreen muiScreen = (IMuiScreen)screen;
        if (screen != MCHelper.getCurrentScreen() || muiScreen.screen() != currentScreen) {
            defaultContext.reset();
            ClientScreenHandler.invalidateCurrentScreen();
            if (MCHelper.getCurrentScreen() == null) {
                ClientScreenHandler.invalidateMuiStack();
            }
            return false;
        }
        return true;
    }

    public static GuiContext getBestContext() {
        if (ClientScreenHandler.validateGui()) {
            return currentScreen.getContext();
        }
        return defaultContext;
    }

    @Generated
    public static GuiContext getDefaultContext() {
        return defaultContext;
    }

    @Generated
    public static long getTicks() {
        return ticks;
    }

    static {
        muiStack = new ObjectArrayList(8);
        debugToggleActive = false;
    }

    private static enum InputPhase {
        EARLY,
        LATE;


        public boolean isEarly() {
            return this == EARLY;
        }

        public boolean isLate() {
            return this == LATE;
        }
    }
}

