/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.schema;

import brachy.modularui.schema.PosListSchema;
import brachy.modularui.utils.BlockPosUtil;
import java.util.function.BiPredicate;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BoxSchema
extends PosListSchema {
    private final Level level;
    private final BlockPos min;
    private final BlockPos max;
    private final Vector3f center;

    public static BoxSchema of(Level level, BlockPos center, int r) {
        return new BoxSchema(level, center.m_7918_(-r, -r, -r), center.m_7918_(r, r, r), (pos, state) -> true);
    }

    public static BoxSchema of(Level level, BlockPos center, int r, BiPredicate<BlockPos, BlockState> renderFilter) {
        return new BoxSchema(level, center.m_7918_(-r, -r, -r), center.m_7918_(r, r, r), renderFilter);
    }

    public BoxSchema(Level level, BlockPos min, BlockPos max, BiPredicate<BlockPos, BlockState> renderFilter) {
        super(level, BlockPosUtil.getAllInside(min, max, false), renderFilter);
        this.level = level;
        this.min = BlockPosUtil.getMin(min, max);
        this.max = BlockPosUtil.getMax(min, max);
        this.center = BlockPosUtil.getCenterF(min, max);
    }

    @Override
    public Vector3fc getFocus() {
        return this.center;
    }

    @Override
    public BlockPos getOrigin() {
        return this.min;
    }

    @Override
    @Generated
    public Level getLevel() {
        return this.level;
    }

    @Generated
    public BlockPos getMin() {
        return this.min;
    }

    @Generated
    public BlockPos getMax() {
        return this.max;
    }
}

