/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.overlay;

import brachy.modularui.ModularUIConfig;
import brachy.modularui.api.IMuiScreen;
import brachy.modularui.api.widget.IWidget;
import brachy.modularui.overlay.DebugOverlay;
import brachy.modularui.overlay.OverlayHandler;
import brachy.modularui.overlay.OverlayManager;
import brachy.modularui.screen.ClientScreenHandler;
import brachy.modularui.screen.ModularScreen;
import brachy.modularui.screen.OpenScreenEvent;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class OverlayStack {
    private static final List<ModularScreen> overlay = new ArrayList<ModularScreen>();

    public static void foreach(Consumer<ModularScreen> function, boolean topToBottom) {
        if (topToBottom) {
            for (int i = overlay.size() - 1; i >= 0; --i) {
                function.accept(overlay.get(i));
            }
        } else {
            for (ModularScreen screen : overlay) {
                function.accept(screen);
            }
        }
    }

    public static boolean interact(Predicate<ModularScreen> function, boolean topToBottom) {
        if (topToBottom) {
            for (int i = overlay.size() - 1; i >= 0; --i) {
                if (!function.test(overlay.get(i))) continue;
                return true;
            }
        } else {
            for (ModularScreen screen : overlay) {
                if (!function.test(screen)) continue;
                return true;
            }
        }
        return false;
    }

    public static void draw(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        ModularScreen hovered = null;
        ModularScreen fallback = null;
        for (ModularScreen screen : overlay) {
            screen.getContext().setGraphics(graphics);
            screen.getContext().updateState(mouseX, mouseY, partialTicks);
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            screen.m_88315_(graphics, mouseX, mouseY, partialTicks);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            screen.drawForeground(graphics, partialTicks);
            if (screen.getContext().isHovered()) {
                hovered = screen;
            }
            fallback = screen;
        }
        ClientScreenHandler.drawDebugScreen(graphics, hovered, fallback);
        RenderSystem.enableDepthTest();
        Lighting.m_84931_();
    }

    public static void open(ModularScreen screen) {
        int i = overlay.indexOf(screen);
        if (i >= 0 && i < overlay.size() - 1) {
            overlay.remove(i);
        }
        overlay.add(screen);
        screen.onOpen();
    }

    public static void close(ModularScreen screen) {
        if (overlay.remove(screen)) {
            screen.getPanelManager().closeAll();
            screen.getPanelManager().dispose();
        }
    }

    static void closeAll() {
        for (int i = overlay.size() - 1; i >= 0; --i) {
            ModularScreen screen = overlay.remove(i);
            screen.getPanelManager().closeAll();
            screen.getPanelManager().dispose();
        }
    }

    public static void onTick() {
        OverlayStack.foreach(ModularScreen::onUpdate, true);
    }

    @Nullable
    public static IWidget getHoveredElement() {
        for (int i = overlay.size() - 1; i >= 0; --i) {
            ModularScreen screen = overlay.get(i);
            IWidget hovered = screen.getContext().getTopHovered();
            if (hovered == null) continue;
            return hovered;
        }
        return null;
    }

    public static boolean isHoveringOverlay() {
        return OverlayStack.getHoveredElement() != null;
    }

    public static void onOpenScreen(Screen newScreen) {
        OverlayStack.closeAll();
        if (newScreen != null) {
            for (OverlayHandler overlayHandler : OverlayManager.overlays) {
                if (!overlayHandler.isValidFor(newScreen)) continue;
                ModularScreen overlay2 = Objects.requireNonNull(overlayHandler.createOverlay(newScreen), "Overlays must not be null!");
                overlay2.constructOverlay(newScreen);
                OverlayStack.open(overlay2);
            }
            OpenScreenEvent event = new OpenScreenEvent(newScreen);
            MinecraftForge.EVENT_BUS.post((Event)event);
            for (ModularScreen overlay : event.getOverlays()) {
                overlay.constructOverlay(newScreen);
                OverlayStack.open(overlay);
            }
            if (ModularUIConfig.Dev.debugUI() && newScreen instanceof IMuiScreen) {
                ModularScreen overlay;
                IMuiScreen iMuiScreen = (IMuiScreen)newScreen;
                overlay = new DebugOverlay(iMuiScreen);
                overlay.constructOverlay(newScreen);
                OverlayStack.open(overlay);
            }
        }
    }
}

