/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.overlay;

import brachy.modularui.ModularUIConfig;
import brachy.modularui.api.IMuiScreen;
import brachy.modularui.api.drawable.IIcon;
import brachy.modularui.api.drawable.IKey;
import brachy.modularui.api.widget.IWidget;
import brachy.modularui.drawable.GuiTextures;
import brachy.modularui.drawable.NamedDrawableRow;
import brachy.modularui.drawable.Rectangle;
import brachy.modularui.screen.CustomModularScreen;
import brachy.modularui.screen.ModularPanel;
import brachy.modularui.screen.viewport.ModularGuiContext;
import brachy.modularui.utils.Color;
import brachy.modularui.utils.TreeUtil;
import brachy.modularui.value.BoolValue;
import brachy.modularui.widget.WidgetTree;
import brachy.modularui.widgets.ButtonWidget;
import brachy.modularui.widgets.ListWidget;
import brachy.modularui.widgets.ToggleButton;
import brachy.modularui.widgets.menu.ContextMenuButton;
import brachy.modularui.widgets.menu.Menu;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;

public class DebugOverlay
extends CustomModularScreen {
    private static final IIcon CHECKMARK = GuiTextures.CHECKMARK.asIcon().size(8);
    private final IMuiScreen parent;

    public DebugOverlay(IMuiScreen screen) {
        super("modularui");
        this.parent = screen;
    }

    @Override
    @NotNull
    public ModularPanel buildUI(ModularGuiContext context) {
        return (ModularPanel)new ModularPanel("debug").fullScreenInvisible().child(((ContextMenuButton)((ContextMenuButton)((ContextMenuButton)((ContextMenuButton)((ContextMenuButton)((ContextMenuButton)((ContextMenuButton)((ContextMenuButton)new ContextMenuButton("menu_debug_options").horizontalCenter()).bottom(0)).height(12)).width(160)).background(new Rectangle().color(Color.withAlpha(ModularUIConfig.Dev.outlineColor(), 0.4f)).cornerRadius(4))).disableHoverBackground()).overlay(IKey.str("Debug Options"))).openUp()).menuList(l1 -> ((ListWidget)((ListWidget)((ListWidget)((ListWidget)((ListWidget)l1.name("menu_list")).maxSize(100).widthRel(1.0f)).child(((ButtonWidget)((ButtonWidget)((ButtonWidget)((ButtonWidget)((ButtonWidget)new ButtonWidget().name("print_widget_tree_button")).height(12)).widthRel(1.0f)).invisible()).overlay(IKey.str("Print widget trees"))).onMousePressed((x, y, b) -> this.logWidgetTrees(b)))).child(((ButtonWidget)((ButtonWidget)((ButtonWidget)((ButtonWidget)((ButtonWidget)new ButtonWidget().name("print_resizer_tree_button")).height(12)).widthRel(1.0f)).invisible()).overlay(IKey.str("Print resizer tree"))).onMousePressed((x, y, b) -> {
            TreeUtil.print(this.parent.screen().getResizeNode());
            return true;
        }))).child(((ContextMenuButton)((ContextMenuButton)((ContextMenuButton)((ContextMenuButton)new ContextMenuButton("menu_hover_info").height(10)).widthRel(1.0f)).overlay(IKey.str("Widget hover info"))).openRightUp()).menu((Menu)((Menu)((Menu)((Menu)new Menu().width(100)).coverChildrenHeight()).padding(2)).child((IWidget)((ListWidget)((ListWidget)((ListWidget)((ListWidget)((ListWidget)((ListWidget)new ListWidget().maxSize(100).widthRel(1.0f)).child(DebugOverlay.toggleOption(0, "Any", "showHovered"))).child(DebugOverlay.toggleOption(1, "Pos", "showPos"))).child(DebugOverlay.toggleOption(2, "Size", "showSize"))).child(DebugOverlay.toggleOption(3, "Widget Theme", "showWidgetTheme"))).child(DebugOverlay.toggleOption(4, "Extra info", "showExtra"))).child(DebugOverlay.toggleOption(5, "Outline", "showOutline")))))).child(((ContextMenuButton)((ContextMenuButton)((ContextMenuButton)((ContextMenuButton)((ContextMenuButton)new ContextMenuButton("menu_parent_hover_info").name("menu_button_parent_hover_info")).height(10)).widthRel(1.0f)).overlay(IKey.str("Parent widget hover info"))).openRightUp()).menu((Menu)((Menu)((Menu)((Menu)new Menu().width(100)).coverChildrenHeight()).padding(2)).child((IWidget)((ListWidget)((ListWidget)((ListWidget)((ListWidget)((ListWidget)new ListWidget().maxSize(100).widthRel(1.0f)).child(DebugOverlay.toggleOption(10, "Any", "showParent"))).child(DebugOverlay.toggleOption(11, "Pos", "showParentPos"))).child(DebugOverlay.toggleOption(12, "Size", "showParentSize"))).child(DebugOverlay.toggleOption(13, "Widget Theme", "showParentWidgetTheme"))).child(DebugOverlay.toggleOption(14, "Outline", "showParentOutline")))))));
    }

    public static IWidget toggleOption(int i, String name, String field) {
        ForgeConfigSpec.ConfigValue configValue;
        Object config = ModularUIConfig.CONFIG.getValues().get(List.of("dev", field));
        if (!(config instanceof ForgeConfigSpec.ConfigValue) || !((configValue = (ForgeConfigSpec.ConfigValue)config).get() instanceof Boolean)) {
            throw new IllegalArgumentException("Config field 'dev.%s' is not a boolean value!".formatted(field));
        }
        ForgeConfigSpec.ConfigValue configField = (ForgeConfigSpec.ConfigValue)config;
        BoolValue.Dynamic val = new BoolValue.Dynamic(() -> ((ForgeConfigSpec.ConfigValue)configField).get(), arg_0 -> ((ForgeConfigSpec.ConfigValue)configField).set(arg_0));
        return ((ToggleButton)((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().name("hover_info_toggle" + i)).invisible()).widthRel(1.0f)).height(12)).value(val).overlay(true, new NamedDrawableRow().name(IKey.str(name)).drawable(CHECKMARK)).overlay(false, new NamedDrawableRow().name(IKey.str(name)));
    }

    private boolean logWidgetTrees(int b) {
        for (ModularPanel panel : this.parent.screen().getPanelManager().getOpenPanels()) {
            WidgetTree.print(panel);
        }
        return true;
    }
}

