/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.network;

import brachy.modularui.ModularUI;
import brachy.modularui.network.NetworkHandler;
import brachy.modularui.network.packets.CloseAllGuiPacket;
import brachy.modularui.network.packets.CloseGuiPacket;
import brachy.modularui.network.packets.ReopenGuiPacket;
import brachy.modularui.network.packets.SyncHandlerPacket;
import brachy.modularui.screen.ModularContainerMenu;
import brachy.modularui.value.sync.ModularSyncManager;
import brachy.modularui.value.sync.SyncHandler;
import it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import lombok.Generated;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.ApiStatus;

public abstract class ModularNetworkSide {
    private final boolean client;
    private final Int2ReferenceOpenHashMap<ModularSyncManager> activeScreens = new Int2ReferenceOpenHashMap();
    private final Reference2IntOpenHashMap<ModularSyncManager> inverseActiveScreens = new Reference2IntOpenHashMap();

    ModularNetworkSide(boolean client) {
        this.client = client;
    }

    abstract void sendPacket(NetworkHandler.INetPacket var1, Player var2);

    void activateInternal(int networkId, ModularSyncManager manager) {
        if (this.activeScreens.containsKey(networkId)) {
            throw new IllegalStateException("Network ID " + networkId + " is already active.");
        }
        this.activeScreens.put(networkId, (Object)manager);
        this.inverseActiveScreens.put((Object)manager, networkId);
    }

    public void closeAll(Player player) {
        this.closeAll(player, true);
    }

    @ApiStatus.Internal
    public void closeAll(Player player, boolean sync) {
        ModularContainerMenu mc;
        if (this.activeScreens.isEmpty()) {
            return;
        }
        int currentContainer = -1;
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof ModularContainerMenu && !(mc = (ModularContainerMenu)abstractContainerMenu).isClientOnly()) {
            currentContainer = this.inverseActiveScreens.getInt((Object)mc.getSyncManager());
        }
        ObjectIterator it = this.activeScreens.int2ReferenceEntrySet().fastIterator();
        while (it.hasNext()) {
            Int2ReferenceMap.Entry entry = (Int2ReferenceMap.Entry)it.next();
            int nid = entry.getIntKey();
            ModularSyncManager msm = (ModularSyncManager)entry.getValue();
            if (nid == currentContainer) {
                this.closeContainer(player);
            }
            if (!msm.isClosed()) {
                msm.onClose();
            }
            msm.dispose();
        }
        this.activeScreens.clear();
        this.inverseActiveScreens.clear();
        if (sync) {
            this.sendPacket(new CloseAllGuiPacket(), player);
        }
    }

    @ApiStatus.Internal
    public void receivePacket(SyncHandlerPacket packet) {
        ModularSyncManager msm = (ModularSyncManager)this.activeScreens.get(packet.networkId);
        if (msm == null) {
            return;
        }
        try {
            int id = packet.action ? 0 : packet.packet.m_130242_();
            msm.receiveWidgetUpdate(packet.panel, packet.key, packet.action, id, packet.packet);
        }
        catch (IndexOutOfBoundsException e) {
            ModularUI.LOGGER.error("Failed to read packet for sync handler {} in panel {}", (Object)packet.key, (Object)packet.panel);
            ModularUI.LOGGER.catching((Throwable)e);
        }
    }

    @ApiStatus.Internal
    public void sendSyncHandlerPacket(String panel, SyncHandler syncHandler, FriendlyByteBuf buffer, Player player) {
        ModularSyncManager msm = syncHandler.getSyncManager().getModularSyncManager();
        if (!this.inverseActiveScreens.containsKey((Object)msm)) {
            return;
        }
        int id = this.inverseActiveScreens.getInt((Object)msm);
        this.sendPacket(new SyncHandlerPacket(id, panel, syncHandler.getKey(), false, buffer), player);
    }

    @ApiStatus.Internal
    public void sendActionPacket(ModularSyncManager msm, String panel, String key, FriendlyByteBuf buffer, Player player) {
        if (!this.inverseActiveScreens.containsKey((Object)msm)) {
            return;
        }
        int id = this.inverseActiveScreens.getInt((Object)msm);
        this.sendPacket(new SyncHandlerPacket(id, panel, key, true, buffer), player);
    }

    @ApiStatus.Internal
    public void closeContainer(int networkId, boolean dispose, Player player, boolean sync) {
        this.closeContainer(player);
        this.deactivate(networkId, dispose);
        if (sync) {
            this.sendPacket(new CloseGuiPacket(networkId, dispose), player);
        }
    }

    abstract void closeContainer(Player var1);

    void deactivate(int networkId, boolean dispose) {
        ModularSyncManager msm = (ModularSyncManager)this.activeScreens.get(networkId);
        if (msm == null) {
            return;
        }
        if (!msm.isClosed()) {
            msm.onClose();
        }
        if (dispose) {
            this.activeScreens.remove(networkId);
            this.inverseActiveScreens.removeInt((Object)msm);
            msm.dispose();
        }
    }

    @ApiStatus.Internal
    public void reopen(Player player, ModularSyncManager msm, boolean sync) {
        if (player.f_36096_ != msm.getMenu()) {
            this.closeContainer(player);
            player.f_36096_ = msm.getMenu();
            msm.onOpen();
            MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open(player, (AbstractContainerMenu)msm.getMenu()));
        }
        if (sync) {
            this.sendPacket(new ReopenGuiPacket(this.inverseActiveScreens.getInt((Object)msm)), player);
        }
    }

    @ApiStatus.Internal
    public void reopen(Player player, int networkId, boolean sync) {
        this.reopen(player, (ModularSyncManager)this.activeScreens.get(networkId), sync);
    }

    @Generated
    public boolean isClient() {
        return this.client;
    }
}

