/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.network;

import brachy.modularui.api.IMuiScreen;
import brachy.modularui.network.ModularNetworkSide;
import brachy.modularui.network.NetworkHandler;
import brachy.modularui.utils.NetworkUtils;
import brachy.modularui.value.sync.ModularSyncManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public abstract class ModularNetwork {
    public static final Client CLIENT = new Client();
    public static final Server SERVER = new Server();

    public static ModularNetworkSide get(boolean client) {
        return client ? CLIENT : SERVER;
    }

    public static ModularNetworkSide get(Side side) {
        return side.isClient() ? CLIENT : SERVER;
    }

    public static ModularNetworkSide get(Player player) {
        return ModularNetwork.get(NetworkUtils.isClient(player));
    }

    public static final class Client
    extends ModularNetworkSide {
        private Client() {
            super(true);
        }

        public void activate(int nid, ModularSyncManager msm) {
            this.activateInternal(nid, msm);
        }

        @Override
        void sendPacket(NetworkHandler.INetPacket packet, Player player) {
            NetworkHandler.sendToServer(packet);
        }

        @Override
        void closeContainer(Player player) {
            player.m_150109_().m_36012_(ItemStack.f_41583_);
            player.f_36096_ = player.f_36095_;
        }

        @SideOnly(value=Side.CLIENT)
        public void closeContainer(int networkId, boolean dispose, Player player) {
            this.closeContainer(networkId, dispose, player, true);
        }

        @SideOnly(value=Side.CLIENT)
        public void closeAll() {
            this.closeAll((Player)Minecraft.m_91087_().f_91074_);
        }

        @SideOnly(value=Side.CLIENT)
        public void reopenSyncerOf(Screen guiScreen) {
            IMuiScreen ms;
            if (guiScreen instanceof IMuiScreen && !(ms = (IMuiScreen)guiScreen).screen().isClientOnly()) {
                ModularSyncManager msm = ms.screen().getSyncManager();
                this.reopen((Player)Minecraft.m_91087_().f_91074_, msm, true);
            }
        }
    }

    public static final class Server
    extends ModularNetworkSide {
        private int nextId = -1;

        private Server() {
            super(false);
        }

        public int activate(ModularSyncManager msm) {
            if (++this.nextId > 100000) {
                this.nextId = 0;
            }
            this.activateInternal(this.nextId, msm);
            return this.nextId;
        }

        @Override
        protected void sendPacket(NetworkHandler.INetPacket packet, Player player) {
            NetworkHandler.sendToPlayer((ServerPlayer)player, packet);
        }

        @Override
        void closeContainer(Player player) {
            player.m_6915_();
        }

        public void closeContainer(int networkId, boolean dispose, ServerPlayer player) {
            this.closeContainer(networkId, dispose, (Player)player, true);
        }
    }
}

