/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.integration.rei.handler;

import brachy.modularui.api.IMuiScreen;
import brachy.modularui.api.widget.IWidget;
import brachy.modularui.integration.recipeviewer.handlers.IngredientProvider;
import brachy.modularui.integration.recipeviewer.handlers.RecipeViewerHandler;
import brachy.modularui.integration.rei.REIStackConverter;
import brachy.modularui.integration.rei.handler.MUIDraggableStackVisitor;
import brachy.modularui.integration.rei.handler.MUIOverlayDecider;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.Collection;
import java.util.Map;
import lombok.Generated;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackProvider;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitor;
import me.shedaniel.rei.api.client.gui.drag.DraggedAcceptorResult;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.client.gui.widgets.TextField;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZonesProvider;
import me.shedaniel.rei.api.client.registry.screen.OverlayDecider;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import net.minecraft.client.gui.screens.Screen;
import org.jetbrains.annotations.Nullable;

public class REIScreenHandler<T extends Screen>
extends RecipeViewerHandler
implements DraggableStackProvider<T>,
ExclusionZonesProvider<T> {
    private static final Map<Class<?>, REIScreenHandler<?>> CACHE = new Reference2ReferenceOpenHashMap();
    protected final Class<T> clazz;
    private final DraggableStackVisitor<T> draggableVisitor;
    private final OverlayDecider overlayDecider;
    protected static DraggableStack currentIngredient = null;

    public static <T extends Screen> REIScreenHandler<T> of(Class<T> clazz) {
        return CACHE.computeIfAbsent(clazz, clz -> new REIScreenHandler(clz));
    }

    private REIScreenHandler(Class<T> clazz) {
        this.clazz = clazz;
        this.draggableVisitor = new MUIDraggableStackVisitor<T>(this.clazz);
        this.overlayDecider = new MUIOverlayDecider(this.clazz);
    }

    public void register(ScreenRegistry registry) {
        registry.registerDraggableStackProvider((DraggableStackProvider)this);
        registry.registerDraggableStackVisitor(this.getDraggableVisitor());
        registry.registerDecider(this.getOverlayDecider());
    }

    public static <T extends Screen> void register(Class<T> clazz, ScreenRegistry registry) {
        REIScreenHandler.of(clazz).register(registry);
    }

    @Nullable
    public DraggableStack getHoveredStack(DraggingContext<T> context, double mouseX, double mouseY) {
        IWidget hovered = ((IMuiScreen)context.getScreen()).screen().getContext().getTopHovered();
        if (hovered instanceof IngredientProvider) {
            IngredientProvider provider = (IngredientProvider)hovered;
            Object override = provider.ingredientOverride();
            if (override != null) {
                currentIngredient = (DraggableStack)override;
                return currentIngredient;
            }
            REIStackConverter.Converter converter = REIStackConverter.getForNullable(provider.ingredientClass());
            if (converter == null) {
                return null;
            }
            final EntryIngredient converted = converter.convertTo(provider);
            return new DraggableStack(){

                public EntryStack<?> getStack() {
                    if (converted.isEmpty()) {
                        return EntryStack.empty();
                    }
                    return (EntryStack)converted.get(0);
                }

                public void drag() {
                    currentIngredient = this;
                }

                public void release(DraggedAcceptorResult result) {
                    currentIngredient = null;
                }
            };
        }
        return null;
    }

    public <R extends Screen> boolean isHandingScreen(R screen) {
        return this.clazz.isAssignableFrom(screen.getClass());
    }

    public DraggingContext<T> getContext() {
        return super.getContext();
    }

    public double getPriority() {
        return 10.0;
    }

    public Collection<Rectangle> provide(T screen) {
        return ((IMuiScreen)screen).screen().getContext().getRecipeViewerSettings().getAllExclusionAreas().stream().map(REIScreenHandler::asREIRect).toList();
    }

    protected static Rectangle asREIRect(brachy.modularui.utils.Rectangle rect) {
        return new Rectangle(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    @Override
    public void setSearchFocused(boolean focused) {
        TextField searchField = REIRuntime.getInstance().getSearchTextField();
        if (searchField != null) {
            searchField.setFocused(focused);
        }
    }

    @Override
    @Nullable
    public Object getCurrentlyDragged() {
        if (currentIngredient == null) {
            return null;
        }
        return currentIngredient.get().getValue();
    }

    @Generated
    public DraggableStackVisitor<T> getDraggableVisitor() {
        return this.draggableVisitor;
    }

    @Generated
    public OverlayDecider getOverlayDecider() {
        return this.overlayDecider;
    }
}

