/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.integration.recipeviewer.handlers.item;

import brachy.modularui.integration.recipeviewer.entry.item.ItemEntryList;
import brachy.modularui.integration.recipeviewer.entry.item.ItemStackList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CycleItemEntryHandler
implements IItemHandlerModifiable {
    private final List<ItemEntryList> entries;
    private List<List<ItemStack>> unwrapped = null;

    public CycleItemEntryHandler(List<ItemEntryList> entries) {
        this.entries = new ArrayList<ItemEntryList>(entries);
    }

    public List<List<ItemStack>> getUnwrapped() {
        if (this.unwrapped == null) {
            this.unwrapped = this.entries.stream().map(CycleItemEntryHandler::getStacksNullable).collect(Collectors.toCollection(ArrayList::new));
        }
        return this.unwrapped;
    }

    @Nullable
    private static List<ItemStack> getStacksNullable(@Nullable ItemEntryList list) {
        if (list == null) {
            return null;
        }
        return list.getStacks();
    }

    public ItemEntryList getEntry(int index) {
        return this.entries.get(index);
    }

    public int getSlots() {
        return this.entries.size();
    }

    public ItemStack getStackInSlot(int slot) {
        List<ItemStack> stackList = this.getUnwrapped().get(slot);
        return stackList == null || stackList.isEmpty() ? ItemStack.f_41583_ : stackList.get(Math.abs((int)(System.currentTimeMillis() / 1000L) % stackList.size()));
    }

    public void setStackInSlot(int index, ItemStack stack) {
        if (index >= 0 && index < this.entries.size()) {
            this.entries.set(index, ItemStackList.of(stack));
            this.unwrapped = null;
        }
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        return stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.f_41583_;
    }

    public int getSlotLimit(int slot) {
        return Integer.MAX_VALUE;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return true;
    }

    @Generated
    public List<ItemEntryList> getEntries() {
        return this.entries;
    }
}

