/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.integration.jei.handler;

import brachy.modularui.api.IMuiScreen;
import brachy.modularui.api.widget.IWidget;
import brachy.modularui.core.mixins.jei.IngredientListOverlayAccessor;
import brachy.modularui.integration.jei.GhostIngredientTarget;
import brachy.modularui.integration.jei.ModularUIJeiPlugin;
import brachy.modularui.integration.jei.ModularUIJeiProperties;
import brachy.modularui.integration.recipeviewer.handlers.GhostIngredientSlot;
import brachy.modularui.integration.recipeviewer.handlers.IngredientProvider;
import brachy.modularui.integration.recipeviewer.handlers.RecipeViewerHandler;
import brachy.modularui.utils.Rectangle;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.gui.handlers.IGuiProperties;
import mezz.jei.api.gui.handlers.IScreenHandler;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.runtime.IClickableIngredient;
import mezz.jei.api.runtime.IIngredientListOverlay;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.Nullable;

public class JeiScreenHandler<T extends Screen>
extends RecipeViewerHandler
implements IGhostIngredientHandler<T>,
IScreenHandler<T> {
    private static final Map<Class<?>, JeiScreenHandler<?>> CACHE = new Reference2ReferenceOpenHashMap();
    protected final Class<T> clazz;
    private static Object currentIngredient = null;

    public static <T extends Screen> JeiScreenHandler<T> of(Class<T> clazz) {
        return CACHE.computeIfAbsent(clazz, clz -> new JeiScreenHandler(clz));
    }

    private JeiScreenHandler(Class<T> clazz) {
        this.clazz = clazz;
    }

    public static <T extends Screen, M extends AbstractContainerMenu, T2 extends AbstractContainerScreen<M>> void register(Class<T> clazz, IGuiHandlerRegistration registration) {
        if (AbstractContainerScreen.class.isAssignableFrom(clazz)) {
            ContainerScreen.ofContainer(clazz).register(registration);
        } else {
            JeiScreenHandler.of(clazz).register(registration);
        }
    }

    public void register(IGuiHandlerRegistration registration) {
        registration.addGhostIngredientHandler(this.clazz, (IGhostIngredientHandler)this);
        registration.addGuiScreenHandler(this.clazz, (IScreenHandler)this);
    }

    public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(T screen, ITypedIngredient<I> ingredient, boolean doStart) {
        currentIngredient = ingredient;
        List<GhostIngredientSlot<?>> ghostSlots = ((IMuiScreen)screen).screen().getContext().getRecipeViewerSettings().getGhostIngredientSlots();
        ArrayList<IGhostIngredientHandler.Target<I>> ghostHandlerTargets = new ArrayList<IGhostIngredientHandler.Target<I>>();
        for (GhostIngredientSlot<?> slot : ghostSlots) {
            if (!slot.isEnabled() || slot.castGhostIngredientIfValid(ingredient.getIngredient()) == null) continue;
            GhostIngredientSlot<?> slotWithType = slot;
            ghostHandlerTargets.add(new GhostIngredientTarget(slotWithType));
        }
        return ghostHandlerTargets;
    }

    public boolean shouldHighlightTargets() {
        return false;
    }

    @Nullable
    public IGuiProperties apply(T guiScreen) {
        return ((IMuiScreen)guiScreen).screen().getContext().getRecipeViewerSettings().isEnabled(((IMuiScreen)guiScreen).screen()) ? new ModularUIJeiProperties((IMuiScreen)guiScreen) : null;
    }

    public void onComplete() {
        currentIngredient = null;
    }

    @Override
    public void setSearchFocused(boolean focused) {
        IIngredientListOverlay iIngredientListOverlay = ModularUIJeiPlugin.getRuntime().getIngredientListOverlay();
        if (iIngredientListOverlay instanceof IngredientListOverlayAccessor) {
            IngredientListOverlayAccessor accessor = (IngredientListOverlayAccessor)iIngredientListOverlay;
            accessor.getSearchField().m_93692_(focused);
        }
    }

    @Override
    @Nullable
    public Object getCurrentlyDragged() {
        if (currentIngredient == null) {
            return null;
        }
        return currentIngredient;
    }

    public static class ContainerScreen<T extends AbstractContainerMenu, T1 extends AbstractContainerScreen<T>>
    extends JeiScreenHandler<T1>
    implements IGuiContainerHandler<T1> {
        public static <M extends AbstractContainerMenu, T extends AbstractContainerScreen<M>> ContainerScreen<M, T> ofContainer(Class<T> clazz) {
            return (ContainerScreen)CACHE.computeIfAbsent(clazz, clz -> new ContainerScreen(clz));
        }

        private ContainerScreen(Class<T1> clazz) {
            super(clazz);
        }

        @Override
        public void register(IGuiHandlerRegistration registry) {
            super.register(registry);
            registry.addGuiContainerHandler(this.clazz, (IGuiContainerHandler)this);
        }

        public List<Rect2i> getGuiExtraAreas(T1 screen) {
            return ((IMuiScreen)screen).screen().getContext().getRecipeViewerSettings().getAllExclusionAreas().stream().map(Rectangle::asRect2i).toList();
        }

        public Optional<IClickableIngredient<?>> getClickableIngredientUnderMouse(T1 screen, double mouseX, double mouseY) {
            IWidget hovered = ((IMuiScreen)screen).screen().getContext().getTopHovered();
            if (hovered instanceof IngredientProvider) {
                IngredientProvider provider = (IngredientProvider)hovered;
                Object override = provider.ingredientOverride();
                if (override instanceof IClickableIngredient) {
                    IClickableIngredient clickableIngredient = (IClickableIngredient)override;
                    currentIngredient = clickableIngredient.getIngredient();
                    return Optional.of(clickableIngredient);
                }
                if (provider.getIngredients().isEmpty()) {
                    return Optional.empty();
                }
                Optional<IClickableIngredient<?>> ingredient = this.createClickableIngredient(this.mapFirstIngredient(provider), hovered.getArea());
                currentIngredient = ingredient.map(IClickableIngredient::getIngredient).orElse(null);
                return ingredient;
            }
            return Optional.empty();
        }

        private <I> I mapFirstIngredient(IngredientProvider<I> provider) {
            return (I)provider.renderMappingFunction().apply(provider.getIngredients().getStacks().get(0));
        }

        private <I> Optional<IClickableIngredient<I>> createClickableIngredient(I ingredient, Rectangle area) {
            return ModularUIJeiPlugin.getRuntime().getIngredientManager().createClickableIngredient(ingredient, area.asRect2i(), false);
        }
    }
}

