/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.factory.inventory;

import brachy.modularui.api.MCHelper;
import brachy.modularui.factory.UIFactories;
import brachy.modularui.factory.inventory.Container;
import brachy.modularui.factory.inventory.CuriosHandler;
import brachy.modularui.factory.inventory.InventoryType;
import brachy.modularui.factory.inventory.InventoryVisitor;
import brachy.modularui.test.TestItem;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class InventoryTypes {
    static final Map<String, InventoryType<?>> inventoryTypes = new Object2ObjectOpenHashMap();
    public static final Container PLAYER = new Container("player"){

        @Override
        public net.minecraft.world.Container getInventory(Player player) {
            return player.m_150109_();
        }
    };
    public static final CuriosHandler CURIOS = CuriosHandler.INSTANCE;

    @ApiStatus.Internal
    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(InventoryTypes::onKeyInput);
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        if (event.getAction() == 1 && event.getKey() == 322) {
            InventoryTypes.visitAll(MCHelper.getPlayer(), (type, context, index, stackInSlot) -> {
                if (!stackInSlot.m_41619_() && stackInSlot.m_41720_() instanceof TestItem) {
                    UIFactories.playerInventory().openClient(type, context, index);
                    return true;
                }
                return false;
            });
        }
    }

    public static Collection<InventoryType<?>> getAll() {
        return InventoryTypes.getAllRegistered();
    }

    @Nullable
    public static SlotFindResult<?> findFirstStackable(Player player, ItemStack stack, boolean ignoreEmpty) {
        for (InventoryType<?> type : InventoryTypes.getAll()) {
            int i;
            if (type instanceof CuriosHandler || (i = type.findFirstStackable(player, stack, ignoreEmpty)) < 0) continue;
            return new SlotFindResult<Object>(type, null, i);
        }
        return null;
    }

    public static void visitAllStackable(Player player, ItemStack stack, InventoryVisitor<?> visitor) {
        for (InventoryType<?> type : InventoryTypes.getAll()) {
            if (!type.visitAllStackable(player, stack, visitor)) continue;
            return;
        }
    }

    public static void visitAll(Player player, InventoryVisitor<?> visitor) {
        for (InventoryType<?> type : InventoryTypes.getAll()) {
            if (!type.visitAll(player, visitor)) continue;
            return;
        }
    }

    public static Collection<InventoryType<?>> getAllRegistered() {
        return Collections.unmodifiableCollection(inventoryTypes.values());
    }

    public record SlotFindResult<T>(InventoryType<T> type, T context, int slot) {
    }
}

