/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.factory.inventory;

import brachy.modularui.factory.inventory.InventoryTypes;
import brachy.modularui.factory.inventory.InventoryVisitor;
import brachy.modularui.utils.NetworkUtils;
import lombok.Generated;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class InventoryType<T> {
    private final String id;

    public InventoryType(String id) {
        this.id = id;
        if (this.isActive()) {
            InventoryTypes.inventoryTypes.put(id, this);
        }
    }

    public boolean isActive() {
        return true;
    }

    public abstract ItemStack getStackInSlot(Player var1, T var2, int var3);

    public abstract void setStackInSlot(Player var1, T var2, int var3, ItemStack var4);

    public int findFirstStackable(Player player, ItemStack stack, boolean ignoreEmpty) {
        int[] holder = new int[]{-1};
        this.visitAllStackable(player, stack, (type, context, index, stackInSlot) -> {
            if (stackInSlot.m_41619_() && ignoreEmpty) {
                return false;
            }
            holder[0] = index;
            return true;
        });
        return holder[0];
    }

    public boolean visitAllStackable(Player player, ItemStack stack, InventoryVisitor<T> visitor) {
        this.visitAll(player, (type, context, index, stackInSlot) -> {
            if (stackInSlot.m_41619_() && stack.m_41619_() || ItemHandlerHelper.canItemStacksStack((ItemStack)stackInSlot, (ItemStack)stack)) {
                return visitor.visit(type, context, index, stack);
            }
            return false;
        });
        return false;
    }

    public T castContext(Object o) {
        return (T)o;
    }

    public abstract boolean visitAll(Player var1, InventoryVisitor<T> var2);

    public abstract void writeContext(FriendlyByteBuf var1, T var2);

    public abstract T readContext(FriendlyByteBuf var1);

    public void write(FriendlyByteBuf buf) {
        NetworkUtils.writeStringSafe(buf, this.id);
    }

    public static InventoryType<?> read(FriendlyByteBuf buf) {
        return InventoryType.getFromId(NetworkUtils.readStringSafe(buf));
    }

    public static InventoryType<?> getFromId(String id) {
        return InventoryTypes.inventoryTypes.get(id);
    }

    @Generated
    public String getId() {
        return this.id;
    }
}

