/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.factory;

import brachy.modularui.api.IUIHolder;
import brachy.modularui.api.MCHelper;
import brachy.modularui.factory.AbstractUIFactory;
import brachy.modularui.factory.GuiData;
import brachy.modularui.factory.GuiManager;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class SimpleUIFactory
extends AbstractUIFactory<GuiData> {
    private final Supplier<IUIHolder<GuiData>> guiHolderSupplier;
    private IUIHolder<GuiData> guiHolder;

    public SimpleUIFactory(ResourceLocation name, IUIHolder<GuiData> guiHolder) {
        this(name, () -> guiHolder);
    }

    public SimpleUIFactory(ResourceLocation name, Supplier<IUIHolder<GuiData>> guiHolderSupplier) {
        super(name);
        this.guiHolderSupplier = guiHolderSupplier;
        GuiManager.registerFactory(this);
    }

    public void init() {
    }

    public void open(ServerPlayer player) {
        GuiManager.open(this, new GuiData((Player)player), player);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void openClient() {
        GuiManager.openFromClient(this, new GuiData(MCHelper.getPlayer()));
    }

    @Override
    public void writeGuiData(GuiData guiData, FriendlyByteBuf buffer) {
    }

    @Override
    @NotNull
    public GuiData readGuiData(Player player, FriendlyByteBuf buffer) {
        return new GuiData(player);
    }

    @Override
    @NotNull
    public IUIHolder<GuiData> getGuiHolder(GuiData data) {
        if (this.guiHolder == null) {
            this.guiHolder = this.guiHolderSupplier.get();
            Objects.requireNonNull(this.guiHolder, "IUIHolder must not be null");
        }
        return this.guiHolder;
    }
}

