/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.factory;

import brachy.modularui.ModularUI;
import brachy.modularui.api.IUIHolder;
import brachy.modularui.api.MCHelper;
import brachy.modularui.factory.AbstractUIFactory;
import brachy.modularui.factory.GuiManager;
import brachy.modularui.factory.PlayerInventoryGuiData;
import brachy.modularui.factory.inventory.InventoryType;
import brachy.modularui.factory.inventory.InventoryTypes;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class PlayerInventoryUIFactory
extends AbstractUIFactory<PlayerInventoryGuiData<?>> {
    public static final PlayerInventoryUIFactory INSTANCE = new PlayerInventoryUIFactory();

    public void openFromPlayerInventory(Player player, int index) {
        GuiManager.open(this, PlayerInventoryGuiData.of(player, InventoryTypes.PLAYER, null, index), PlayerInventoryUIFactory.verifyServerSide(player));
    }

    public void openFromHand(Player player, InteractionHand hand) {
        this.openFromPlayerInventory(player, hand == InteractionHand.OFF_HAND ? 40 : player.m_150109_().f_35977_);
    }

    public void openFromCurios(Player player, String type, int index) {
        if (!ModularUI.Mods.CURIOS.isLoaded()) {
            throw new IllegalArgumentException("Can't open UI for curio item when curios is not loaded!");
        }
        GuiManager.open(this, PlayerInventoryGuiData.of(player, InventoryTypes.CURIOS, type, index), PlayerInventoryUIFactory.verifyServerSide(player));
    }

    public <T> void open(Player player, InventoryType<T> type, T context, int index) {
        GuiManager.open(this, PlayerInventoryGuiData.of(player, type, context, index), PlayerInventoryUIFactory.verifyServerSide(player));
    }

    @SideOnly(value=Side.CLIENT)
    public void openFromPlayerInventoryClient(int index) {
        GuiManager.openFromClient(this, PlayerInventoryGuiData.of(MCHelper.getPlayer(), InventoryTypes.PLAYER, null, index));
    }

    @SideOnly(value=Side.CLIENT)
    public void openFromHandClient(InteractionHand hand) {
        this.openFromPlayerInventoryClient(hand == InteractionHand.OFF_HAND ? 40 : MCHelper.getPlayer().m_150109_().f_35977_);
    }

    @SideOnly(value=Side.CLIENT)
    public void openFromCuriosClient(String type, int index) {
        if (!ModularUI.Mods.CURIOS.isLoaded()) {
            throw new IllegalArgumentException("Can't open UI for curios item when curios is not loaded!");
        }
        GuiManager.openFromClient(this, PlayerInventoryGuiData.of(MCHelper.getPlayer(), InventoryTypes.CURIOS, type, index));
    }

    @SideOnly(value=Side.CLIENT)
    public <T> void openClient(InventoryType<T> type, T context, int index) {
        GuiManager.openFromClient(this, PlayerInventoryGuiData.of(MCHelper.getPlayer(), type, context, index));
    }

    private PlayerInventoryUIFactory() {
        super(ModularUI.id("player_inventory"));
    }

    @Override
    @NotNull
    public IUIHolder<PlayerInventoryGuiData<?>> getGuiHolder(PlayerInventoryGuiData<?> data) {
        return Objects.requireNonNull(this.castUIHolder(data.getUsedItemStack().m_41720_()), "Item was not a gui holder!");
    }

    @Override
    public void writeGuiData(PlayerInventoryGuiData<?> guiData, FriendlyByteBuf buffer) {
        guiData.getInventoryType().write(buffer);
        PlayerInventoryUIFactory.writeContext(buffer, guiData.getInventoryType(), guiData.getContext());
        buffer.m_130130_(guiData.getSlotIndex());
    }

    private static <T> void writeContext(FriendlyByteBuf buffer, InventoryType<T> type, Object context) {
        type.writeContext(buffer, type.castContext(context));
    }

    @Override
    @NotNull
    public PlayerInventoryGuiData<?> readGuiData(Player player, FriendlyByteBuf buffer) {
        return PlayerInventoryUIFactory.readContext(player, buffer, InventoryType.read(buffer));
    }

    private static <T> PlayerInventoryGuiData<?> readContext(Player player, FriendlyByteBuf buffer, InventoryType<T> inventoryType) {
        return PlayerInventoryGuiData.of(player, inventoryType, inventoryType.readContext(buffer), buffer.m_130242_());
    }
}

