/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.factory;

import brachy.modularui.ModularUI;
import brachy.modularui.api.IUIHolder;
import brachy.modularui.api.MCHelper;
import brachy.modularui.factory.AbstractUIFactory;
import brachy.modularui.factory.GuiManager;
import brachy.modularui.factory.PosGuiData;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class BlockEntityUIFactory
extends AbstractUIFactory<PosGuiData> {
    public static final BlockEntityUIFactory INSTANCE = new BlockEntityUIFactory();

    private BlockEntityUIFactory() {
        super(ModularUI.id("block_entity"));
    }

    public <T extends BlockEntity> void open(Player player, T blockEntity) {
        Objects.requireNonNull(player);
        BlockEntityUIFactory.verifyBlockEntity(MCHelper.getPlayer(), blockEntity);
        BlockPos pos = blockEntity.m_58899_();
        PosGuiData data = new PosGuiData(player, pos);
        GuiManager.open(this, data, (ServerPlayer)player);
    }

    public void open(Player player, BlockPos pos) {
        Objects.requireNonNull(player);
        Objects.requireNonNull(pos);
        PosGuiData data = new PosGuiData(player, pos);
        GuiManager.open(this, data, (ServerPlayer)player);
    }

    @OnlyIn(value=Dist.CLIENT)
    public <T extends BlockEntity> void openClient(T blockEntity) {
        BlockEntityUIFactory.verifyBlockEntity(MCHelper.getPlayer(), blockEntity);
        BlockPos pos = blockEntity.m_58899_();
        GuiManager.openFromClient(this, new PosGuiData(MCHelper.getPlayer(), pos));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void openClient(BlockPos pos) {
        Objects.requireNonNull(pos);
        GuiManager.openFromClient(this, new PosGuiData(MCHelper.getPlayer(), pos));
    }

    @Override
    @NotNull
    public IUIHolder<PosGuiData> getGuiHolder(PosGuiData data) {
        return Objects.requireNonNull(this.castUIHolder(data.getBlockEntity()), "Found BlockEntity is not a gui holder!");
    }

    @Override
    public boolean canInteractWith(Player player, PosGuiData guiData) {
        return player == guiData.getPlayer() && guiData.getBlockEntity() != null && guiData.getSquaredDistance((Entity)player) <= 64.0;
    }

    @Override
    public void writeGuiData(PosGuiData guiData, FriendlyByteBuf buffer) {
        buffer.m_130064_(guiData.getBlockPos());
    }

    @Override
    @NotNull
    public PosGuiData readGuiData(Player player, FriendlyByteBuf buffer) {
        return new PosGuiData(player, buffer.m_130135_());
    }

    public static void verifyBlockEntity(Player player, BlockEntity blockEntity) {
        Objects.requireNonNull(blockEntity);
        if (blockEntity.m_58901_()) {
            throw new IllegalArgumentException("Can't open invalid BlockEntity GUI!");
        }
        if (player.m_9236_() != blockEntity.m_58904_()) {
            throw new IllegalArgumentException("BlockEntity must be in same dimension as the player!");
        }
    }
}

