/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.factory;

import brachy.modularui.api.IUIHolder;
import brachy.modularui.api.UIFactory;
import brachy.modularui.factory.GuiData;
import brachy.modularui.screen.ModularPanel;
import brachy.modularui.screen.ModularScreen;
import brachy.modularui.screen.UISettings;
import brachy.modularui.value.sync.PanelSyncManager;
import java.util.Objects;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractUIFactory<T extends GuiData>
implements UIFactory<T> {
    private final ResourceLocation name;

    protected static ServerPlayer verifyServerSide(Player player) {
        if (player == null) {
            throw new NullPointerException("Can't open UI for null player!");
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            return serverPlayer;
        }
        throw new IllegalArgumentException("Expected server player to open UI on server!");
    }

    protected static LocalPlayer verifyClientSide(Player player) {
        if (player == null) {
            throw new NullPointerException("Can't open UI for null player!");
        }
        if (player instanceof LocalPlayer) {
            LocalPlayer localPlayer = (LocalPlayer)player;
            return localPlayer;
        }
        throw new IllegalArgumentException("Expected client player to open UI on client side!");
    }

    protected AbstractUIFactory(ResourceLocation name) {
        this.name = Objects.requireNonNull(name);
    }

    @Override
    @NotNull
    public final ResourceLocation getFactoryName() {
        return this.name;
    }

    @NotNull
    public abstract IUIHolder<T> getGuiHolder(T var1);

    @Override
    public ModularPanel createPanel(T guiData, PanelSyncManager syncManager, UISettings settings) {
        IUIHolder<T> guiHolder = Objects.requireNonNull(this.getGuiHolder(guiData), "Gui holder must not be null!");
        return guiHolder.buildUI(guiData, syncManager, settings);
    }

    @Override
    public ModularScreen createScreen(T guiData, ModularPanel mainPanel) {
        IUIHolder<T> guiHolder = Objects.requireNonNull(this.getGuiHolder(guiData), "Gui holder must not be null!");
        return guiHolder.createScreen(guiData, mainPanel);
    }

    protected IUIHolder<T> castUIHolder(Object o) {
        if (!(o instanceof IUIHolder)) {
            return null;
        }
        try {
            return (IUIHolder)o;
        }
        catch (ClassCastException e) {
            return null;
        }
    }
}

