/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.drawable.text;

import brachy.modularui.api.drawable.ITextLine;
import brachy.modularui.core.mixins.client.StringSplitterAccessor;
import brachy.modularui.drawable.text.FontRenderHelper;
import brachy.modularui.drawable.text.RichTextCompiler;
import brachy.modularui.screen.viewport.GuiContext;
import brachy.modularui.utils.Alignment;
import brachy.modularui.widget.sizer.Area;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TextRenderer {
    public static final TextRenderer SHARED = new TextRenderer();
    protected float maxWidth = -1.0f;
    protected float maxHeight = -1.0f;
    protected int x = 0;
    protected int y = 0;
    protected Alignment alignment = Alignment.TopLeft;
    protected float scale = 1.0f;
    protected boolean shadow = false;
    protected int color = 0;
    protected boolean simulate;
    protected float lastWidth = 0.0f;
    protected float lastHeight = 0.0f;
    protected float lastX = 0.0f;
    protected float lastY = 0.0f;
    protected boolean hardWrapOnBorder = true;
    protected boolean scrollOnOverflow = false;

    public void setAlignment(Alignment alignment, float maxWidth) {
        this.setAlignment(alignment, maxWidth, -1.0f);
    }

    public void setAlignment(Alignment alignment, float maxWidth, float maxHeight) {
        this.alignment = alignment;
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
    }

    public void setPos(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void draw(GuiGraphics graphics, String text) {
        this.draw(graphics, (Component)Component.m_237113_((String)text));
    }

    public void draw(GuiGraphics graphics, Component text) {
        if (!(!(this.maxWidth <= 0.0f) && this.hardWrapOnBorder || text.getString().contains("\n'"))) {
            this.drawSimple(graphics, text);
        } else {
            this.draw(graphics, Collections.singletonList(text));
        }
    }

    public void draw(GuiGraphics graphics, List<Component> lines) {
        this.drawMeasuredLines(graphics, this.measureLines(lines));
    }

    protected void drawMeasuredLines(GuiGraphics graphics, List<Line> measuredLines) {
        float maxW = 0.0f;
        int y0 = this.getStartYOfLines(measuredLines.size());
        for (Line measuredLine : measuredLines) {
            int x0 = this.getStartX(measuredLine.width);
            maxW = Math.max(maxW, measuredLine.width);
            this.draw(graphics, measuredLine.text, x0, y0);
            y0 += (int)this.getFontHeight();
        }
        this.lastWidth = maxW;
        this.lastHeight = (float)measuredLines.size() * this.getFontHeight();
        this.lastWidth = Math.max(0.0f, this.lastWidth - this.scale);
        this.lastHeight = Math.max(0.0f, this.lastHeight - this.scale);
    }

    public void drawSimple(GuiGraphics graphics, Component text) {
        this.drawSimple(graphics, text.m_7532_());
    }

    public void drawSimple(GuiGraphics graphics, FormattedCharSequence text) {
        if (TextRenderer.getFont() == null) {
            return;
        }
        float w = (float)TextRenderer.getFont().m_92724_(text) * this.scale;
        int y = this.getStartYOfLines(1);
        int x = this.getStartX(w);
        this.draw(graphics, text, x, y);
        this.lastWidth = w;
        this.lastHeight = this.getFontHeight();
        this.lastWidth = Math.max(0.0f, this.lastWidth - this.scale);
        this.lastHeight = Math.max(0.0f, this.lastHeight - this.scale);
    }

    public List<Line> measureStringLines(List<String> lines) {
        return this.measureLines(FontRenderHelper.asComponents(lines));
    }

    public List<Line> measureLines(List<Component> lines) {
        ArrayList<Line> measuredLines = new ArrayList<Line>();
        for (Component line : lines) {
            if (this.hardWrapOnBorder) {
                for (FormattedCharSequence subLine : this.wrapLine(line)) {
                    measuredLines.add(this.line(subLine));
                }
                continue;
            }
            measuredLines.add(this.line(line.m_7532_()));
        }
        return measuredLines;
    }

    public List<ITextLine> compile(List<Object> rawText) {
        return RichTextCompiler.INSTANCE.compileLines(TextRenderer.getFont(), rawText, (int)this.maxWidth, this.scale);
    }

    public List<ITextLine> compileAndDraw(GuiContext context, List<Object> raw) {
        List<ITextLine> lines = this.compile(raw);
        this.drawCompiled(context, lines);
        return lines;
    }

    public void drawCompiled(GuiContext context, List<ITextLine> lines) {
        int height = 0;
        int width = 0;
        for (ITextLine line : lines) {
            height += line.getHeight(context.getFont());
            width = Math.max(width, line.getWidth());
        }
        if (!this.simulate) {
            context.graphicsPose().m_85836_();
            context.graphicsPose().m_252880_((float)this.x, (float)this.y, 10.0f);
            context.graphicsPose().m_85841_(this.scale, this.scale, 1.0f);
            context.graphicsPose().m_252880_((float)(-this.x), (float)(-this.y), 0.0f);
        }
        int y0 = this.getStartY(height, height);
        this.lastY = y0;
        for (ITextLine line : lines) {
            int x0 = this.getStartX(width, line.getWidth());
            if (!this.simulate) {
                line.draw(context, context.getFont(), x0, y0, this.color, this.shadow, width, height);
            }
            y0 += line.getHeight(context.getFont());
        }
        if (!this.simulate) {
            context.graphicsPose().m_85849_();
        }
        this.lastWidth = this.maxWidth > 0.0f ? Math.min((float)width * this.scale, this.maxWidth) : (float)width * this.scale;
        this.lastHeight = (float)height * this.scale;
        this.lastWidth = Math.max(0.0f, this.lastWidth - this.scale);
        this.lastHeight = Math.max(0.0f, this.lastHeight - this.scale);
    }

    public void drawCut(GuiGraphics graphics, String text) {
        if (text.contains("\n")) {
            throw new IllegalArgumentException("Scrolling text can't wrap!");
        }
        this.drawCut(graphics, this.line(Component.m_237113_((String)text).m_7532_()));
    }

    public void drawCut(GuiGraphics graphics, Line line) {
        if (line.width > this.maxWidth) {
            FormattedCharSequence cutText = FormattedCharSequence.m_13696_((FormattedCharSequence)FontRenderHelper.splitAtMax(line.text(), this.maxWidth - 6.0f), (FormattedCharSequence)FormattedCharSequence.m_13714_((String)"...", (Style)Style.f_131099_));
            this.drawMeasuredLines(graphics, Collections.singletonList(this.line(cutText)));
        } else {
            this.drawMeasuredLines(graphics, Collections.singletonList(line));
        }
    }

    public void drawScrolling(GuiGraphics graphics, Line line, float progress, Area area, GuiContext context) {
        if (line.width() <= this.maxWidth) {
            this.drawMeasuredLines(graphics, Collections.singletonList(line));
            return;
        }
        float scroll = (line.getWidth() - this.maxWidth) * progress;
        context.getStencil().push(this.x, -500, (int)this.maxWidth, 1000);
        context.graphicsPose().m_85836_();
        context.graphicsPose().m_252880_(-scroll, 0.0f, 0.0f);
        this.drawMeasuredLines(graphics, Collections.singletonList(line));
        context.graphicsPose().m_85849_();
        context.getStencil().pop();
    }

    public List<FormattedCharSequence> wrapLine(Component line) {
        if (this.maxWidth > 0.0f) {
            int wrapWidth = Math.max(10, (int)(this.maxWidth / this.scale));
            return TextRenderer.getFont().m_92923_((FormattedText)line, wrapWidth);
        }
        return Collections.singletonList(line.m_7532_());
    }

    public boolean wouldFit(List<String> text, boolean shouldCheckWidth) {
        if (this.maxHeight > 0.0f && this.maxHeight < (float)text.size() * this.getFontHeight() - this.scale) {
            return false;
        }
        if (this.maxWidth > 0.0f && shouldCheckWidth) {
            for (String line : text) {
                if (!(this.maxWidth < (float)TextRenderer.getFont().m_92895_(line))) continue;
                return false;
            }
        }
        return true;
    }

    public int getMaxWidth(List<Component> lines) {
        if (lines.isEmpty()) {
            return 0;
        }
        List<Line> measuredLines = this.measureLines(lines);
        float w = 0.0f;
        for (Line measuredLine : measuredLines) {
            w = Math.max(w, measuredLine.width());
        }
        return (int)Math.ceil(w);
    }

    protected int getStartYOfLines(int lines) {
        return this.getStartY((float)lines * this.getFontHeight() - this.scale);
    }

    protected int getStartY(float height) {
        return this.getStartY(this.maxHeight, height);
    }

    protected int getStartY(float maxHeight, float height) {
        if (this.alignment.y > 0.0f && maxHeight > 0.0f && height != maxHeight) {
            return this.y + Math.round(maxHeight * this.alignment.y) - Math.round(height * this.alignment.y);
        }
        return this.y;
    }

    protected int getStartX(float lineWidth) {
        return this.getStartX(this.maxWidth, lineWidth);
    }

    protected int getStartX(float maxWidth, float lineWidth) {
        if (this.alignment.x > 0.0f && maxWidth > 0.0f) {
            return Math.max(this.x, this.x + Math.round(maxWidth * this.alignment.x) - Math.round(lineWidth * this.alignment.x));
        }
        return this.x;
    }

    protected void draw(GuiGraphics graphics, FormattedCharSequence text, float x, float y) {
        if (this.simulate || graphics == null) {
            return;
        }
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85841_(this.scale, this.scale, 0.0f);
        graphics.m_280649_(TextRenderer.getFont(), text, (int)(x / this.scale), (int)(y / this.scale), this.color, this.shadow);
        graphics.m_280168_().m_85849_();
    }

    public float getFontHeight() {
        Objects.requireNonNull(TextRenderer.getFont());
        return 9.0f * this.scale;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Font getFont() {
        return Minecraft.m_91087_().f_91062_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static StringSplitter.WidthProvider getWidthProvider() {
        return ((StringSplitterAccessor)TextRenderer.getFont().m_92865_()).getWidthProvider();
    }

    public Line line(FormattedCharSequence text) {
        return new Line(text, (float)TextRenderer.getFont().m_92724_(text) * this.scale);
    }

    @Generated
    public int getX() {
        return this.x;
    }

    @Generated
    public int getY() {
        return this.y;
    }

    @Generated
    public Alignment getAlignment() {
        return this.alignment;
    }

    @Generated
    public float getScale() {
        return this.scale;
    }

    @Generated
    public void setScale(float scale) {
        this.scale = scale;
    }

    @Generated
    public boolean isShadow() {
        return this.shadow;
    }

    @Generated
    public void setShadow(boolean shadow) {
        this.shadow = shadow;
    }

    @Generated
    public int getColor() {
        return this.color;
    }

    @Generated
    public void setColor(int color) {
        this.color = color;
    }

    @Generated
    public void setSimulate(boolean simulate) {
        this.simulate = simulate;
    }

    @Generated
    public float getLastWidth() {
        return this.lastWidth;
    }

    @Generated
    public float getLastHeight() {
        return this.lastHeight;
    }

    @Generated
    public void setHardWrapOnBorder(boolean hardWrapOnBorder) {
        this.hardWrapOnBorder = hardWrapOnBorder;
    }

    public record Line(FormattedCharSequence text, float width) {
        public int upperWidth() {
            return (int)(this.width + 1.0f);
        }

        public int lowerWidth() {
            return (int)this.width;
        }

        @Generated
        public FormattedCharSequence getText() {
            return this.text;
        }

        @Generated
        public float getWidth() {
            return this.width;
        }
    }

    public record FormattedChar(int codePoint, Style style) {
        public FormattedCharSequence asSequence() {
            return FormattedCharSequence.m_13693_((int)this.codePoint, (Style)this.style);
        }
    }
}

