/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.drawable.text;

import brachy.modularui.api.drawable.IIcon;
import brachy.modularui.drawable.text.TextRenderer;
import brachy.modularui.screen.viewport.GuiContext;
import brachy.modularui.theme.WidgetTheme;
import brachy.modularui.utils.Alignment;
import brachy.modularui.widget.sizer.Box;
import lombok.Generated;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class TextIcon
implements IIcon {
    private final Component text;
    private final int width;
    private final int height;
    private final float scale;
    private final Alignment alignment;
    private static final Box margin = new Box();

    public TextIcon(Component text, int width, int height, float scale, Alignment alignment) {
        this.text = text;
        this.width = width;
        this.height = height;
        this.scale = scale;
        this.alignment = alignment;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(GuiContext context, int x, int y, int width, int height, WidgetTheme widgetTheme) {
        TextRenderer.SHARED.setPos(x, y);
        TextRenderer.SHARED.setAlignment(this.alignment, width);
        TextRenderer.SHARED.setScale(this.scale);
        TextRenderer.SHARED.drawSimple(context.getGraphics(), this.text);
    }

    @Override
    @Nullable
    public IIcon getWrappedDrawable() {
        return null;
    }

    @Override
    public Box getMargin() {
        return margin;
    }

    @Generated
    public Component getText() {
        return this.text;
    }

    @Override
    @Generated
    public int getWidth() {
        return this.width;
    }

    @Override
    @Generated
    public int getHeight() {
        return this.height;
    }
}

