/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.drawable.text;

import brachy.modularui.ModularUI;
import brachy.modularui.api.drawable.IDrawable;
import brachy.modularui.api.drawable.IIcon;
import brachy.modularui.api.drawable.IKey;
import brachy.modularui.api.drawable.ITextLine;
import brachy.modularui.drawable.DelegateIcon;
import brachy.modularui.drawable.Icon;
import brachy.modularui.drawable.text.ComposedLine;
import brachy.modularui.drawable.text.FontRenderHelper;
import brachy.modularui.drawable.text.FormattingState;
import brachy.modularui.drawable.text.TextLine;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public class RichTextCompiler {
    public static final RichTextCompiler INSTANCE = new RichTextCompiler();
    private Font fr;
    private int maxWidth;
    private List<ITextLine> lines;
    private List<Object> currentLine;
    private int x;
    private int h;
    private final FormattingState formatting = new FormattingState();

    public List<ITextLine> compileLines(Font fr, List<Object> raw, int maxWidth, float scale) {
        this.reset(fr, (int)((float)maxWidth / scale));
        this.compile(raw);
        return this.lines;
    }

    public void reset(Font fr, int maxWidth) {
        this.fr = fr != null ? fr : Minecraft.m_91087_().f_91062_;
        this.maxWidth = maxWidth > 0 ? maxWidth : Integer.MAX_VALUE;
        this.lines = new ArrayList<ITextLine>();
        this.currentLine = new ArrayList<Object>();
        this.x = 0;
        this.h = 0;
        this.formatting.reset();
    }

    private void compile(List<Object> raw) {
        for (Object o : raw) {
            IIcon icon;
            if (o instanceof ITextLine) {
                ITextLine line = (ITextLine)o;
                this.newLine();
                this.lines.add(line);
                continue;
            }
            MutableComponent text = null;
            if (o instanceof IKey) {
                IKey key = (IKey)o;
                if (key == IKey.EMPTY) continue;
                if (key == IKey.SPACE) {
                    MutableComponent mc = key.get();
                    this.addLineElement(mc);
                    this.x += this.fr.m_92852_((FormattedText)mc);
                    continue;
                }
                if (key == IKey.LINE_FEED) {
                    this.newLine();
                    this.formatting.reset();
                    continue;
                }
                text = key.getFormatted();
            }
            if (o instanceof MutableComponent) {
                MutableComponent component = (MutableComponent)o;
                text = component.m_6881_();
            } else if (!(o instanceof IDrawable)) {
                text = Component.m_237113_((String)o.toString());
            }
            if (text != null) {
                if (text.m_7383_() != Style.f_131099_) {
                    this.addLineElement(text);
                    continue;
                }
                this.compileString(text.getString());
                continue;
            }
            if (!(o instanceof IIcon)) {
                o = ((IDrawable)o).asIcon();
            }
            IIcon delegate = icon = (IIcon)o;
            if (icon instanceof DelegateIcon) {
                DelegateIcon di = (DelegateIcon)icon;
                delegate = di.findRootDelegate();
            }
            if (delegate instanceof Icon) {
                Icon icon1 = (Icon)delegate;
                Objects.requireNonNull(this.fr);
                int defaultSize = 9;
                if (icon1.getHeight() <= 0) {
                    icon1.height(defaultSize);
                }
            }
            if (icon.getWidth() > this.maxWidth) {
                ModularUI.LOGGER.warn("Icon is wider than max width");
            }
            this.checkNewLine(icon.getWidth());
            this.addLineElement(icon);
            this.h = Math.max(this.h, icon.getHeight());
            this.x += icon.getWidth();
        }
        this.newLine();
    }

    private void compileString(String text) {
        int l = text.indexOf(10);
        int k = 0;
        do {
            if (l < 0) {
                l = text.length();
            }
            String subText = text.substring(k, l);
            k = l + 1;
            while (!subText.isEmpty()) {
                char c;
                int i = this.fr.m_92865_().m_92360_(subText, this.maxWidth - this.x, Style.f_131099_);
                if (i == 0) {
                    if (this.x > 0) {
                        i = this.fr.m_92865_().m_92360_(subText, this.maxWidth, Style.f_131099_);
                    }
                    if (i == 0) {
                        throw new IllegalStateException("No space for string '" + subText + "'");
                    }
                    this.newLine();
                } else if (i < subText.length() && (c = subText.charAt(i)) != ' ' && this.x > 0) {
                    int j = this.fr.m_92865_().m_92360_(subText, this.maxWidth, Style.f_131099_);
                    if (j < subText.length()) {
                        c = subText.charAt(j);
                        if (j > i && c == ' ') {
                            this.newLine();
                        }
                    } else {
                        this.newLine();
                    }
                }
                String current = subText.length() <= i ? subText : RichTextCompiler.trimRight(subText.substring(0, i));
                int width = this.fr.m_92895_(current);
                this.addLineElement(current);
                Objects.requireNonNull(this.fr);
                this.h = Math.max(this.h, 9);
                this.x += width;
                if (subText.length() <= i) break;
                this.newLine();
                char c2 = subText.charAt(i);
                if (c2 == ' ') {
                    ++i;
                }
                subText = subText.substring(i);
            }
            if (l >= text.length() || text.charAt(l) != '\n') continue;
            this.newLine();
        } while ((l = text.indexOf(10, k)) >= 0 || k < text.length());
    }

    private void newLine() {
        Object object;
        int i = this.currentLine.size() - 1;
        if (!this.currentLine.isEmpty() && (object = this.currentLine.get(i)) instanceof String) {
            String s = (String)object;
            if (s.equals(" ")) {
                this.currentLine.remove(i);
            } else {
                this.currentLine.set(i, RichTextCompiler.trimRight(s));
            }
        }
        if (!this.currentLine.isEmpty()) {
            Object object2;
            if (this.currentLine.size() == 1 && (object2 = this.currentLine.get(0)) instanceof Component) {
                Component c = (Component)object2;
                this.lines.add(new TextLine(c, this.x));
                this.currentLine.clear();
            } else if (this.currentLine.size() == 1 && (object2 = this.currentLine.get(0)) instanceof String) {
                String s = (String)object2;
                this.lines.add(new TextLine((Component)Component.m_237113_((String)s), this.x));
                this.currentLine.clear();
            } else {
                this.lines.add(new ComposedLine(this.currentLine, this.x, this.h));
                this.currentLine = new ArrayList<Object>();
            }
        }
        this.x = 0;
        this.h = 0;
    }

    private void addLineElement(Object o) {
        if (o instanceof Component) {
            Object object;
            Component c2 = (Component)o;
            int s = this.currentLine.size();
            if (s > 0 && (object = this.currentLine.get(s - 1)) instanceof String) {
                String s1 = (String)object;
                this.currentLine.set(s - 1, s1 + String.valueOf(c2));
                return;
            }
            if (this.currentLine.size() == 1 && (object = this.currentLine.get(0)) instanceof Component) {
                Component c1 = (Component)object;
                this.currentLine.set(0, c1.m_6881_().m_7220_(c2));
                return;
            }
            o = c2.m_6881_().m_130938_(this.formatting::getFormatting);
        } else if (o instanceof String) {
            int l;
            Object c1;
            String s2 = (String)o;
            if (this.currentLine.size() == 1 && (c1 = this.currentLine.get(0)) instanceof String) {
                String s1 = (String)c1;
                this.currentLine.set(0, s1 + s2);
                return;
            }
            if (this.currentLine.size() == 1 && (c1 = this.currentLine.get(0)) instanceof Component) {
                Component c12 = (Component)c1;
                this.currentLine.set(0, c12.m_6881_().m_130946_(s2));
                return;
            }
            if (this.currentLine.isEmpty() && (l = FontRenderHelper.getFormatLength(s2, 0)) + 1 < s2.length()) {
                o = RichTextCompiler.trimAt(s2, l);
            }
            Style style = this.formatting.getFormatting(Style.f_131099_);
            StringBuilder styleBuilder = new StringBuilder();
            if (style.m_131135_() != null) {
                int colorRGB = style.m_131135_().m_131265_();
                for (ChatFormatting legacyColor : ChatFormatting.values()) {
                    if (!legacyColor.m_126664_() || colorRGB != legacyColor.m_126665_()) continue;
                    styleBuilder.append(legacyColor);
                    break;
                }
            }
            if (style.m_131154_()) {
                styleBuilder.append(ChatFormatting.BOLD);
            }
            if (style.m_131161_()) {
                styleBuilder.append(ChatFormatting.ITALIC);
            }
            if (style.m_131171_()) {
                styleBuilder.append(ChatFormatting.UNDERLINE);
            }
            if (style.m_131168_()) {
                styleBuilder.append(ChatFormatting.STRIKETHROUGH);
            }
            if (style.m_131176_()) {
                styleBuilder.append(ChatFormatting.OBFUSCATED);
            }
            o = styleBuilder.toString() + String.valueOf(o);
            this.formatting.parseFrom(s2);
        }
        if (o instanceof Component) {
            Component c = (Component)o;
            this.x += this.fr.m_92895_(c.getString());
            Objects.requireNonNull(this.fr);
            this.h = Math.max(this.h, 9);
        }
        this.currentLine.add(o);
    }

    private void checkNewLine(int width) {
        if (this.x > 0 && this.x + width > this.maxWidth) {
            this.newLine();
        }
    }

    public static String trimRight(String s) {
        int i;
        for (i = s.length() - 1; i >= 0 && Character.isWhitespace(s.charAt(i)); --i) {
        }
        if (i < s.length() - 1) {
            s = s.substring(0, i + 1);
        }
        return s;
    }

    public static String trimAt(String s, int start) {
        int l = 0;
        int n = s.length();
        for (int i = Math.max(0, start); i < n && Character.isWhitespace(s.charAt(i)); ++i) {
            ++l;
        }
        if (l == 0) {
            return s;
        }
        if (start <= 0) {
            return s.substring(l);
        }
        return s.substring(0, start) + s.substring(start + l);
    }
}

