/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.drawable.text;

import brachy.modularui.api.MCHelper;
import brachy.modularui.api.drawable.IKey;
import brachy.modularui.drawable.text.FormattingState;
import brachy.modularui.drawable.text.TextRenderer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

public class FontRenderHelper {
    private static final int min = 48;
    private static final int max = 114;
    private static final ChatFormatting[] formattingMap = new ChatFormatting[67];

    @Nullable
    public static ChatFormatting getForCharacter(char c) {
        if (c < '0' || c > 'r') {
            return null;
        }
        return formattingMap[c - 48];
    }

    public static void addAfter(ChatFormatting[] state, ChatFormatting formatting, boolean removeAllOnReset) {
        if (formatting == ChatFormatting.RESET) {
            if (removeAllOnReset) {
                Arrays.fill(state, null);
            }
            state[0] = formatting;
            return;
        }
        if (removeAllOnReset) {
            state[6] = null;
        }
        if (formatting.m_126661_()) {
            state[formatting.ordinal() - 15] = formatting;
            return;
        }
        state[0] = formatting;
    }

    public static MutableComponent format(@Nullable FormattingState state, @Nullable FormattingState parentState, Component text) {
        if (state == null) {
            if (parentState == null) {
                return text.m_6881_();
            }
            return parentState.prependText(ChatFormatting.RESET, null).m_7220_(text);
        }
        return state.prependText(ChatFormatting.RESET, parentState).m_7220_(text);
    }

    public static MutableComponent formatArgs(Object[] args, @Nullable FormattingState parentState, String text, boolean translate) {
        if (args == null || args.length == 0) {
            return translate ? Component.m_237115_((String)text) : Component.m_237113_((String)text);
        }
        args = Arrays.copyOf(args, args.length);
        for (int i = 0; i < args.length; ++i) {
            Object object = args[i];
            if (!(object instanceof IKey)) continue;
            IKey key = (IKey)object;
            args[i] = FormattingState.appendFormat(key.getFormatted(parentState).m_130940_(ChatFormatting.RESET), parentState);
        }
        return translate ? Component.m_237110_((String)text, (Object[])args) : Component.m_237113_((String)String.format(text, args));
    }

    public static int getDefaultTextHeight() {
        int n;
        Font fr = MCHelper.getFont();
        if (fr != null) {
            Objects.requireNonNull(fr);
            n = 9;
        } else {
            n = 9;
        }
        return n;
    }

    public static int getFormatLength(String s, int start) {
        int l = 0;
        for (int i = Math.max(0, start); i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\u00a7') {
                if (i + 1 >= s.length()) {
                    return l;
                }
                if (FontRenderHelper.getForCharacter(c) == null) {
                    return l;
                }
                l += 2;
                ++i;
                continue;
            }
            return l;
        }
        return l;
    }

    public static FormattedCharSequence splitAtMax(FormattedCharSequence input, float maxWidth) {
        MutableFloat cur = new MutableFloat();
        ArrayList<TextRenderer.FormattedChar> output = new ArrayList<TextRenderer.FormattedChar>();
        input.m_13731_((pos, style, codePoint) -> {
            if (cur.addAndGet(TextRenderer.getWidthProvider().m_92515_(codePoint, style)) > maxWidth) {
                return false;
            }
            output.add(new TextRenderer.FormattedChar(codePoint, style));
            return true;
        });
        return FontRenderHelper.fromChars(output);
    }

    public static boolean isEmpty(FormattedCharSequence input) {
        if (input == FormattedCharSequence.f_13691_) {
            return true;
        }
        MutableBoolean value = new MutableBoolean(true);
        input.m_13731_((pos, style, codePoint) -> {
            value.setFalse();
            return false;
        });
        return value.isTrue();
    }

    public static Component getComponentFromCharSequence(FormattedCharSequence input) {
        ArrayList<MutableComponent> parts = new ArrayList<MutableComponent>();
        StringBuilder value = new StringBuilder();
        MutableObject lastStyle = new MutableObject((Object)Style.f_131099_);
        input.m_13731_((pos, style, codePoint) -> {
            if (!style.equals(lastStyle.getValue())) {
                lastStyle.setValue((Object)style);
                parts.add(Component.m_237113_((String)value.toString()).m_6270_(style));
                value.setLength(0);
            } else {
                value.append(codePoint);
            }
            return true;
        });
        if (!value.isEmpty()) {
            parts.add(Component.m_237113_((String)value.toString()).m_6270_((Style)lastStyle.getValue()));
        }
        parts.removeIf(FontRenderHelper::isEmpty);
        if (parts.isEmpty()) {
            return Component.m_237119_();
        }
        if (parts.size() == 1) {
            return (Component)parts.get(0);
        }
        MutableComponent composite = (MutableComponent)parts.remove(0);
        for (Component component : parts) {
            composite.m_7220_(component);
        }
        return composite;
    }

    public static boolean isEmpty(FormattedText text) {
        if (text == FormattedText.f_130760_) {
            return true;
        }
        return text.m_5651_(content -> Optional.of(false)).orElse(true);
    }

    public static FormattedCharSequence fromChars(List<TextRenderer.FormattedChar> chars) {
        int size = chars.size();
        return switch (size) {
            case 0 -> FormattedCharSequence.f_13691_;
            case 1 -> chars.get(0).asSequence();
            default -> sink -> {
                for (int i = 0; i < size; ++i) {
                    TextRenderer.FormattedChar ch = (TextRenderer.FormattedChar)chars.get(i);
                    if (sink.m_6411_(i, ch.style(), ch.codePoint())) continue;
                    return false;
                }
                return true;
            };
        };
    }

    public static FormattedCharSequence substring(FormattedCharSequence str, int start) {
        return sink -> {
            MutableInt globalPos = new MutableInt();
            return str.m_13731_((pos, style, codePoint) -> {
                if (globalPos.addAndGet(1) >= start) {
                    return sink.m_6411_(pos, style, codePoint);
                }
                return true;
            });
        };
    }

    public static FormattedCharSequence substring(FormattedCharSequence str, int start, int end) {
        return sink -> {
            MutableInt globalPos = new MutableInt();
            return str.m_13731_((pos, style, codePoint) -> {
                int current = globalPos.addAndGet(1);
                if (current >= end) {
                    return false;
                }
                if (current >= start) {
                    return sink.m_6411_(pos, style, codePoint);
                }
                return true;
            });
        };
    }

    public static int length(FormattedCharSequence str) {
        MutableInt length = new MutableInt();
        str.m_13731_((positionInCurrentSequence, style, codePoint) -> {
            length.increment();
            return true;
        });
        return length.intValue();
    }

    public static List<Component> asComponents(List<String> lines) {
        return lines.stream().map(Component::m_237113_).toList();
    }

    static {
        for (ChatFormatting formatting : ChatFormatting.values()) {
            char c = formatting.m_178510_();
            FontRenderHelper.formattingMap[c - 48] = formatting;
            if (!Character.isLetter(c)) continue;
            FontRenderHelper.formattingMap[Character.toUpperCase((char)c) - 48] = formatting;
        }
    }
}

