/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.drawable.text;

import brachy.modularui.api.drawable.IKey;
import brachy.modularui.drawable.text.FontRenderHelper;
import brachy.modularui.drawable.text.FormattingState;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.Nullable;

public abstract class BaseKey
implements IKey {
    @Nullable
    private FormattingState formatting;

    @Override
    public MutableComponent getFormatted(@Nullable FormattingState parentFormatting) {
        return FontRenderHelper.format(this.formatting, parentFormatting, (Component)this.get());
    }

    @Override
    public BaseKey style(@Nullable ChatFormatting formatting) {
        if (this.formatting == null) {
            this.formatting = new FormattingState();
        }
        if (formatting == null) {
            this.formatting.forceDefaultColor();
        } else {
            this.formatting.add(formatting, false);
        }
        return this;
    }

    @Override
    public IKey removeStyle() {
        if (this.formatting != null) {
            this.formatting.reset();
        }
        return this;
    }

    public String toString() {
        return this.getFormatted().getString();
    }

    public int hashCode() {
        throw new NotImplementedException("Implement hashCode() in subclasses");
    }

    @Override
    @Nullable
    @Generated
    public FormattingState getFormatting() {
        return this.formatting;
    }
}

