/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.drawable.text;

import brachy.modularui.api.drawable.IKey;
import brachy.modularui.drawable.text.StyledText;
import brachy.modularui.screen.viewport.GuiContext;
import brachy.modularui.theme.WidgetTheme;
import brachy.modularui.utils.Alignment;
import java.util.function.IntSupplier;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnimatedText
extends StyledText {
    private MutableComponent full;
    private String fullString;
    private String currentString = "";
    private int currentIndex;
    private int speed = 40;
    private long timeLastDraw;
    private boolean forward = true;
    private boolean isAnimating = false;

    public AnimatedText(IKey key) {
        super(key);
    }

    @Override
    public MutableComponent get() {
        return Component.m_237113_((String)this.currentString);
    }

    public void reset() {
        this.full = null;
    }

    private void advance() {
        if (!this.isAnimating || this.forward && this.currentIndex >= this.fullString.length() || !this.forward && this.currentIndex < 0) {
            return;
        }
        long time = Util.m_137550_();
        int amount = (int)((time - this.timeLastDraw) / (long)this.speed);
        if (amount == 0) {
            return;
        }
        if (this.forward) {
            int max = Math.min(this.fullString.length() - 1, this.currentIndex + amount);
            for (int i = this.currentIndex = Math.max(this.currentIndex, 0); i < max; ++i) {
                char c = this.fullString.charAt(i);
                if (c == ' ') {
                    max = Math.min(this.fullString.length() - 1, max + 1);
                }
                this.currentString = this.currentString + c;
            }
            this.currentIndex = max;
        } else {
            int min = Math.max(0, this.currentIndex - amount);
            for (int i = this.currentIndex = Math.min(this.currentIndex, this.currentString.length() - 1); i >= min; --i) {
                char c = this.fullString.charAt(i);
                if (c == ' ') {
                    min = Math.max(0, min - 1);
                }
                this.currentString = this.currentString.substring(0, i);
            }
            this.currentIndex = min;
        }
        this.timeLastDraw += (long)amount * (long)this.speed;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(GuiContext context, int x, int y, int width, int height, WidgetTheme widgetTheme) {
        if (this.full == null || !this.full.equals((Object)super.get())) {
            if (this.isAnimating) {
                this.full = super.get();
                this.fullString = this.full.getString();
                this.currentString = this.forward ? "" : this.fullString;
                this.currentIndex = this.forward ? 0 : this.fullString.length() - 1;
                this.timeLastDraw = Util.m_137550_();
            } else {
                this.currentString = this.forward ? "" : this.fullString;
            }
        }
        this.advance();
        if (this.currentString.isEmpty()) {
            return;
        }
        super.draw(context, x, y, width, height, widgetTheme);
    }

    public AnimatedText startAnimation() {
        this.isAnimating = true;
        return this;
    }

    public AnimatedText stopAnimation() {
        this.isAnimating = false;
        return this;
    }

    @Override
    @NotNull
    public AnimatedText style(ChatFormatting formatting) {
        return (AnimatedText)super.style(formatting);
    }

    @Override
    @NotNull
    public AnimatedText alignment(Alignment alignment) {
        return (AnimatedText)super.alignment(alignment);
    }

    @Override
    @NotNull
    public AnimatedText color(int color) {
        return this.color(() -> color);
    }

    @Override
    @NotNull
    public AnimatedText color(@Nullable IntSupplier color) {
        return (AnimatedText)super.color(color);
    }

    @Override
    @NotNull
    public AnimatedText scale(float scale) {
        return (AnimatedText)super.scale(scale);
    }

    @Override
    @NotNull
    public AnimatedText shadow(@Nullable Boolean shadow) {
        return (AnimatedText)super.shadow(shadow);
    }

    @NotNull
    @Generated
    public AnimatedText speed(int speed) {
        this.speed = speed;
        return this;
    }

    @NotNull
    @Generated
    public AnimatedText forward(boolean forward) {
        this.forward = forward;
        return this;
    }
}

