/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.drawable.graph;

import brachy.modularui.GTRenderTypes;
import brachy.modularui.api.GuiAxis;
import brachy.modularui.drawable.GuiDraw;
import brachy.modularui.drawable.graph.GraphView;
import brachy.modularui.utils.Color;
import brachy.modularui.utils.DAM;
import brachy.modularui.utils.Interpolations;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexConsumer;
import lombok.Generated;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;

public class Plot {
    public static final int[] DEFAULT_PLOT_COLORS = new int[]{Color.BLUE_ACCENT.main, Color.ORANGE_ACCENT.darker(0), Color.GREEN.main, Color.RED.main, Color.DEEP_PURPLE_ACCENT.main, Color.BROWN.main, Color.TEAL.main, Color.LIME.main};
    double[] xs = DAM.EMPTY;
    double[] ys = DAM.EMPTY;
    float thickness = 1.0f;
    boolean defaultColor = true;
    int color;
    private float[] vertexBuffer;
    private boolean dirty = true;

    public void redraw() {
        this.dirty = true;
    }

    private void redraw(GraphView view) {
        float dHalf = this.thickness * 0.5f;
        int n = this.xs.length * 4;
        this.vertexBuffer = new float[n];
        int vertexIndex = 0;
        float x0 = view.g2sX(this.xs[0]);
        float y0 = view.g2sY(this.ys[0]);
        float x1 = view.g2sX(this.xs[1]);
        float y1 = view.g2sY(this.ys[1]);
        float lx = x0;
        float ly = y0;
        float dx = x1 - x0;
        float dy = y1 - y0;
        float len = Mth.m_14116_((float)(dx * dx + dy * dy));
        if (len == 0.0f) {
            throw new IllegalArgumentException("Graph can't handle the same point back to back!");
        }
        float px = -(dy /= len);
        float py = dx /= len;
        float lpox = px * dHalf;
        float lpoy = py * dHalf;
        vertexIndex = this.storePoints(vertexIndex, view, lx, ly, lpox, lpoy);
        for (int i = 1; i < this.xs.length - 1; ++i) {
            float oy;
            float ox;
            x0 = view.g2sX(this.xs[i]);
            y0 = view.g2sY(this.ys[i]);
            x1 = view.g2sX(this.xs[i + 1]);
            dx = x1 - x0;
            len = Mth.m_14116_((float)(dx * dx + (dy = (y1 = view.g2sY(this.ys[i + 1])) - y0) * dy));
            if (len == 0.0f) continue;
            px = -(dy /= len);
            py = dx /= len;
            float pox = px * dHalf;
            float poy = py * dHalf;
            if (pox == lpox && poy == lpoy) {
                ox = pox;
                oy = poy;
            } else {
                ox = Interpolations.lerp(lpox, pox, 0.5f);
                oy = Interpolations.lerp(lpoy, poy, 0.5f);
                len = Mth.m_14116_((float)(ox * ox + oy * oy));
                float cosAngle = ((ox /= len) * lpox + (oy /= len) * lpoy) / (1.0f * dHalf);
                float hypotenuse = this.thickness / cosAngle;
                ox *= hypotenuse * 0.5f;
                oy *= hypotenuse * 0.5f;
            }
            vertexIndex = this.storePoints(vertexIndex, view, x0, y0, ox, oy);
            lx = x0;
            ly = y0;
            lpox = pox;
            lpoy = poy;
        }
        int last = this.xs.length - 1;
        x0 = lx;
        y0 = ly;
        x1 = view.g2sX(this.xs[last]);
        dx = x1 - x0;
        len = Mth.m_14116_((float)(dx * dx + (dy = (y1 = view.g2sY(this.ys[last])) - y0) * dy));
        if (len == 0.0f) {
            throw new IllegalArgumentException("Graph can't handle the same point back to back!");
        }
        px = -(dy /= len);
        py = dx /= len;
        lpox = px * dHalf;
        lpoy = py * dHalf;
        this.storePoints(vertexIndex, view, x1, y1, lpox, lpoy);
    }

    private int storePoints(int index, GraphView view, float sx, float sy, float ox, float oy) {
        this.vertexBuffer[index++] = sx - ox;
        this.vertexBuffer[index++] = sy - oy;
        this.vertexBuffer[index++] = sx + ox;
        this.vertexBuffer[index++] = sy + oy;
        return index;
    }

    public void draw(GuiGraphics graphics, GraphView view) {
        if (this.xs.length == 0) {
            return;
        }
        if (this.xs.length == 1) {
            GuiDraw.drawRect(graphics, view.g2sX(this.xs[0]) - this.thickness / 2.0f, view.g2sY(this.ys[0]) - this.thickness / 2.0f, this.thickness, this.thickness, this.color);
            return;
        }
        if (this.dirty) {
            this.redraw(view);
            this.dirty = false;
        }
        int r = Color.getRed(this.color);
        int g = Color.getGreen(this.color);
        int b = Color.getBlue(this.color);
        int a = Color.getAlpha(this.color);
        RenderSystem.setShader(GameRenderer::m_172811_);
        Matrix4f pose = graphics.m_280168_().m_85850_().m_252922_();
        VertexConsumer buffer = graphics.m_280091_().m_6299_(GTRenderTypes.guiTriangleStrip());
        for (int i = 0; i < this.vertexBuffer.length; i += 2) {
            buffer.m_252986_(pose, this.vertexBuffer[i], this.vertexBuffer[i + 1], 0.0f).m_6122_(r, g, b, a).m_5752_();
        }
    }

    public double[] getX() {
        return this.xs;
    }

    public double[] getY() {
        return this.ys;
    }

    public double[] getData(GuiAxis axis) {
        return axis.isHorizontal() ? this.xs : this.ys;
    }

    public Plot data(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("X and Y must have the same length!");
        }
        this.xs = x;
        this.ys = y;
        this.redraw();
        return this;
    }

    public Plot thickness(float thickness) {
        this.thickness = thickness;
        this.redraw();
        return this;
    }

    public Plot color(int color) {
        this.color = color;
        this.defaultColor = color == 0;
        return this;
    }

    @Generated
    public float getThickness() {
        return this.thickness;
    }

    @Generated
    public int getColor() {
        return this.color;
    }
}

