/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.drawable.graph;

import lombok.Generated;

public class GraphView {
    float aspectRatio = 0.0f;
    float sx0;
    float sy0;
    float sx1;
    float sy1;
    double gx0;
    double gy0;
    double gx1;
    double gy1;
    float zeroX;
    float zeroY;

    void postResize() {
        if (this.aspectRatio > 0.0f) {
            float w = this.sx1 - this.sx0;
            float h = this.sy1 - this.sy0;
            float properW = this.aspectRatio * h;
            if (w > properW) {
                float d = w - properW;
                this.sx0 += d / 2.0f;
                this.sx1 -= d / 2.0f;
            } else if (properW > w) {
                float properH = w / this.aspectRatio;
                float d = h - properH;
                this.sy0 += d / 2.0f;
                this.sy1 -= d / 2.0f;
            }
        }
        this.zeroX = this.g2sX(0.0);
        this.zeroY = this.g2sY(0.0);
    }

    boolean setScreen(float x0, float y0, float x1, float y1) {
        if (x0 != this.sx0 || y0 != this.sy0 || x1 != this.sx1 || y1 != this.sy1) {
            this.sx0 = x0;
            this.sy0 = y0;
            this.sx1 = x1;
            this.sy1 = y1;
            return true;
        }
        return false;
    }

    void setGraph(double x0, double y0, double x1, double y1) {
        this.gx0 = x0;
        this.gy0 = y0;
        this.gx1 = x1;
        this.gy1 = y1;
        this.zeroX = this.g2sX(0.0);
        this.zeroY = this.g2sY(0.0);
    }

    public float g2sX(double v) {
        return (float)this.transform(v, this.gx0, this.gx1, this.sx0, this.sx1);
    }

    public float g2sY(double v) {
        return (float)this.transform(v, this.gy1, this.gy0, this.sy0, this.sy1);
    }

    public double g2sScaleX() {
        return this.scale(this.gx0, this.gx1, this.sx0, this.sx1);
    }

    public double g2sScaleY() {
        return this.scale(this.gy1, this.gy0, this.sy0, this.sy1);
    }

    public double s2gX(float v) {
        return this.transform(v, this.sx0, this.sx1, this.gx0, this.gx1);
    }

    public double s2gY(float v) {
        return this.transform(v, this.sy0, this.sy1, this.gy1, this.gy0);
    }

    private double transform(double v, double fromMin, double fromMax, double toMin, double toMax) {
        v = (v - fromMin) / (fromMax - fromMin);
        return toMin + (toMax - toMin) * v;
    }

    private double scale(double fromMin, double fromMax, double toMin, double toMax) {
        return (toMax - toMin) / (fromMax - fromMin);
    }

    public double getGraphX0() {
        return this.gx0;
    }

    public double getGraphX1() {
        return this.gx1;
    }

    public double getGraphY0() {
        return this.gy0;
    }

    public double getGraphY1() {
        return this.gy1;
    }

    public float getScreenX0() {
        return this.sx0;
    }

    public float getScreenX1() {
        return this.sx1;
    }

    public float getScreenY0() {
        return this.sy0;
    }

    public float getScreenY1() {
        return this.sy1;
    }

    public float getScreenWidth() {
        return this.sx1 - this.sx0;
    }

    public float getScreenHeight() {
        return this.sy1 - this.sy0;
    }

    public double getGraphWidth() {
        return this.gx1 - this.gx0;
    }

    public double getGraphHeight() {
        return this.gy1 - this.gy0;
    }

    @Generated
    public void setAspectRatio(float aspectRatio) {
        this.aspectRatio = aspectRatio;
    }

    @Generated
    public float getAspectRatio() {
        return this.aspectRatio;
    }
}

