/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.drawable.graph;

import brachy.modularui.api.GuiAxis;
import brachy.modularui.api.drawable.IDrawable;
import brachy.modularui.drawable.GuiDraw;
import brachy.modularui.drawable.graph.AutoMajorTickFinder;
import brachy.modularui.drawable.graph.AutoMinorTickFinder;
import brachy.modularui.drawable.graph.GraphAxis;
import brachy.modularui.drawable.graph.GraphView;
import brachy.modularui.drawable.graph.MajorTickFinder;
import brachy.modularui.drawable.graph.MinorTickFinder;
import brachy.modularui.drawable.graph.Plot;
import brachy.modularui.screen.viewport.GuiContext;
import brachy.modularui.theme.WidgetTheme;
import brachy.modularui.utils.Color;
import brachy.modularui.utils.Stencil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import org.joml.Matrix4f;

public class GraphDrawable
implements IDrawable {
    private final GraphView view = new GraphView();
    private int backgroundColor;
    private float majorTickThickness;
    private float majorTickLength;
    private float minorTickThickness;
    private float minorTickLength;
    private float gridLineWidth;
    private int gridLineColor;
    private float minorGridLineWidth;
    private int minorGridLineColor;
    private final GraphAxis x;
    private final GraphAxis y;
    private final List<Plot> plots;
    private boolean dirty;

    public GraphDrawable() {
        this.backgroundColor = Color.WHITE.main;
        this.majorTickThickness = 1.0f;
        this.majorTickLength = 3.0f;
        this.minorTickThickness = 0.5f;
        this.minorTickLength = 1.5f;
        this.gridLineWidth = 0.5f;
        this.gridLineColor = Color.withAlpha(Color.BLACK.main, 0.4f);
        this.minorGridLineWidth = 0.0f;
        this.minorGridLineColor = Color.withAlpha(Color.BLACK.main, 0.15f);
        this.x = new GraphAxis(GuiAxis.X);
        this.y = new GraphAxis(GuiAxis.Y);
        this.plots = new ArrayList<Plot>();
        this.dirty = true;
    }

    public void redraw() {
        this.dirty = true;
        for (Plot plot : this.plots) {
            plot.redraw();
        }
    }

    @Override
    public void draw(GuiContext context, int x, int y, int width, int height, WidgetTheme widgetTheme) {
        if (this.view.setScreen(x, y, x + width, y + height) | this.compute()) {
            this.x.applyPadding(this.view);
            this.y.applyPadding(this.view);
            this.view.setGraph(this.x.min, this.y.min, this.x.max, this.y.max);
            this.view.postResize();
        }
        GuiGraphics graphics = context.getGraphics();
        if (this.backgroundColor != 0) {
            GuiDraw.drawRect(graphics, this.view.sx0, this.view.sy0, this.view.getScreenWidth(), this.view.getScreenHeight(), this.backgroundColor);
        }
        RenderSystem.setShader(GameRenderer::m_172811_);
        VertexConsumer buffer = graphics.m_280091_().m_6299_(RenderType.m_286086_());
        this.drawGrid(graphics, buffer);
        Stencil stencil = context.getStencil();
        stencil.push((int)this.view.sx0, (int)this.view.sy0, (int)(this.view.getScreenWidth() + 1.0f), (int)(this.view.getScreenHeight() + 1.0f));
        for (Plot plot : this.plots) {
            plot.draw(graphics, this.view);
        }
        stencil.pop();
        buffer = graphics.m_280091_().m_6299_(RenderType.m_286086_());
        this.drawTicks(graphics, buffer);
        this.x.drawLabels(this.view, this.y, graphics);
        this.y.drawLabels(this.view, this.x, graphics);
    }

    public void drawGrid(GuiGraphics graphics, VertexConsumer buffer) {
        int a;
        int b;
        int g;
        int r;
        if (this.minorGridLineWidth > 0.0f) {
            r = Color.getRed(this.minorGridLineColor);
            g = Color.getGreen(this.minorGridLineColor);
            b = Color.getBlue(this.minorGridLineColor);
            a = Color.getAlpha(this.minorGridLineColor);
            this.x.drawGridLines(graphics.m_280168_().m_85850_().m_252922_(), buffer, this.view, this.y, false, this.minorGridLineWidth, r, g, b, a);
        }
        if (this.gridLineWidth > 0.0f) {
            r = Color.getRed(this.gridLineColor);
            g = Color.getGreen(this.gridLineColor);
            b = Color.getBlue(this.gridLineColor);
            a = Color.getAlpha(this.gridLineColor);
            Matrix4f pose = graphics.m_280168_().m_85850_().m_252922_();
            this.x.drawGridLines(pose, buffer, this.view, this.y, true, this.gridLineWidth, r, g, b, a);
            this.y.drawGridLines(pose, buffer, this.view, this.x, true, this.gridLineWidth, r, g, b, a);
        }
    }

    public void drawTicks(GuiGraphics graphics, VertexConsumer buffer) {
        Matrix4f pose = graphics.m_280168_().m_85850_().m_252922_();
        this.x.drawTicks(pose, buffer, this.view, this.y, false, this.minorTickThickness, this.minorTickLength, 0, 0, 0, 255);
        this.y.drawTicks(pose, buffer, this.view, this.x, false, this.minorTickThickness, this.minorTickLength, 0, 0, 0, 255);
        this.x.drawTicks(pose, buffer, this.view, this.y, true, this.majorTickThickness, this.majorTickLength, 0, 0, 0, 255);
        this.y.drawTicks(pose, buffer, this.view, this.x, true, this.majorTickThickness, this.majorTickLength, 0, 0, 0, 255);
    }

    private boolean compute() {
        if (!this.dirty) {
            return false;
        }
        this.dirty = false;
        this.x.compute(this.plots);
        this.y.compute(this.plots);
        int colorIndex = 0;
        for (Plot plot : this.plots) {
            if (!plot.defaultColor) continue;
            plot.color = Plot.DEFAULT_PLOT_COLORS[colorIndex];
            if (++colorIndex != Plot.DEFAULT_PLOT_COLORS.length) continue;
            colorIndex = 0;
        }
        return true;
    }

    public GraphDrawable autoXLim() {
        this.x.autoLimits = true;
        this.redraw();
        return this;
    }

    public GraphDrawable autoYLim() {
        this.y.autoLimits = true;
        this.redraw();
        return this;
    }

    public GraphDrawable xLim(float min, float max) {
        this.x.min = min;
        this.x.max = max;
        this.x.autoLimits = false;
        this.redraw();
        return this;
    }

    public GraphDrawable yLim(float min, float max) {
        this.y.min = min;
        this.y.max = max;
        this.y.autoLimits = false;
        this.redraw();
        return this;
    }

    public GraphDrawable majorTickStyle(float thickness, float length) {
        this.majorTickThickness = thickness;
        this.majorTickLength = length;
        return this;
    }

    public GraphDrawable minorTickStyle(float thickness, float length) {
        this.minorTickThickness = thickness;
        this.minorTickLength = length;
        return this;
    }

    public GraphDrawable xTickFinder(MajorTickFinder majorTickFinder, MinorTickFinder minorTickFinder) {
        this.x.majorTickFinder = majorTickFinder;
        this.x.minorTickFinder = minorTickFinder;
        this.redraw();
        return this;
    }

    public GraphDrawable yTickFinder(MajorTickFinder majorTickFinder, MinorTickFinder minorTickFinder) {
        this.y.majorTickFinder = majorTickFinder;
        this.y.minorTickFinder = minorTickFinder;
        this.redraw();
        return this;
    }

    public GraphDrawable xTickFinder(float majorMultiples, int minorTicksBetweenMajors) {
        return this.xTickFinder(new AutoMajorTickFinder(majorMultiples), new AutoMinorTickFinder(minorTicksBetweenMajors));
    }

    public GraphDrawable yTickFinder(float majorMultiples, int minorTicksBetweenMajors) {
        return this.yTickFinder(new AutoMajorTickFinder(majorMultiples), new AutoMinorTickFinder(minorTicksBetweenMajors));
    }

    public GraphDrawable backgroundColor(int color) {
        if (color != 0 && Color.getAlpha(color) == 0) {
            color = Color.withAlpha(color, 255);
        }
        this.backgroundColor = color;
        return this;
    }

    public GraphDrawable plot(double[] x, double[] y) {
        return this.plot(new Plot().data(x, y));
    }

    public GraphDrawable plot(double[] x, double[] y, int color) {
        return this.plot(new Plot().data(x, y).color(color));
    }

    public GraphDrawable plot(double[] x, double[] y, float thickness) {
        return this.plot(new Plot().data(x, y).thickness(thickness));
    }

    public GraphDrawable plot(double[] x, double[] y, float thickness, int color) {
        return this.plot(new Plot().data(x, y).thickness(thickness).color(color));
    }

    public GraphDrawable plot(Plot plot) {
        this.plots.add(plot);
        plot.redraw();
        return this;
    }

    public GraphDrawable majorGridStyle(float thickness, int color) {
        this.gridLineWidth = thickness;
        this.gridLineColor = color;
        return this;
    }

    public GraphDrawable minorGridStyle(float thickness, int color) {
        this.minorGridLineWidth = thickness;
        this.minorGridLineColor = color;
        return this;
    }

    public GraphDrawable disableMajorGrid() {
        return this.majorGridLineThickness(0.0f);
    }

    public GraphDrawable disableMinorGrid() {
        return this.minorGridLineThickness(0.0f);
    }

    public GraphDrawable enableMajorGrid() {
        return this.majorGridLineThickness(0.5f);
    }

    public GraphDrawable enableMinorGrid() {
        return this.majorGridLineThickness(0.25f);
    }

    public GraphDrawable majorGridLineThickness(float thickness) {
        this.gridLineWidth = thickness;
        return this;
    }

    public GraphDrawable minorGridLineThickness(float thickness) {
        this.minorGridLineWidth = thickness;
        return this;
    }

    public GraphDrawable majorGridLineColor(int color) {
        this.gridLineColor = color;
        return this;
    }

    public GraphDrawable minorGridLineColor(int color) {
        this.minorGridLineColor = color;
        return this;
    }

    public GraphDrawable graphAspectRatio(float aspectRatio) {
        this.view.setAspectRatio(aspectRatio);
        return this;
    }

    @Generated
    public GraphAxis getX() {
        return this.x;
    }

    @Generated
    public GraphAxis getY() {
        return this.y;
    }
}

