/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.drawable.graph;

import brachy.modularui.api.GuiAxis;
import brachy.modularui.drawable.GuiDraw;
import brachy.modularui.drawable.graph.AutoMajorTickFinder;
import brachy.modularui.drawable.graph.AutoMinorTickFinder;
import brachy.modularui.drawable.graph.GraphView;
import brachy.modularui.drawable.graph.MajorTickFinder;
import brachy.modularui.drawable.graph.MinorTickFinder;
import brachy.modularui.drawable.graph.Plot;
import brachy.modularui.drawable.text.TextRenderer;
import brachy.modularui.utils.Alignment;
import brachy.modularui.utils.DAM;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.text.DecimalFormat;
import java.util.List;
import lombok.Generated;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix4f;

@ApiStatus.Experimental
public class GraphAxis {
    private static final TextRenderer textRenderer = new TextRenderer();
    private static final float TICK_LABEL_SCALE = 0.4f;
    private static final float AXIS_LABEL_SCALE = 1.0f;
    private static final float TICK_LABEL_OFFSET = 2.0f;
    private static final float AXIS_LABEL_OFFSET = 3.0f;
    public final GuiAxis axis;
    public double[] majorTicks = new double[8];
    public double[] minorTicks = new double[16];
    public TextRenderer.Line[] tickLabels = new TextRenderer.Line[8];
    private float maxLabelWidth = 0.0f;
    public MajorTickFinder majorTickFinder = new AutoMajorTickFinder(true);
    public MinorTickFinder minorTickFinder = new AutoMinorTickFinder(2);
    public String label;
    public double min;
    public double max;
    public boolean autoLimits = true;
    public float[] data;

    public GraphAxis(GuiAxis axis) {
        this.axis = axis;
    }

    void compute(List<Plot> plots) {
        AutoMajorTickFinder tickFinder;
        MajorTickFinder majorTickFinder;
        if (this.autoLimits) {
            if (plots.isEmpty()) {
                this.min = 0.0;
                this.max = 0.0;
            } else if (plots.size() == 1) {
                this.min = DAM.min(plots.get(0).getData(this.axis));
                this.max = DAM.max(plots.get(0).getData(this.axis));
            } else {
                double min = Double.MAX_VALUE;
                double max = Double.MIN_VALUE;
                for (Plot plot : plots) {
                    double m = DAM.min(plot.getData(this.axis));
                    if (m < min) {
                        min = m;
                    }
                    if (!((m = DAM.max(plot.getData(this.axis))) > max)) continue;
                    max = m;
                }
                this.min = min;
                this.max = max;
            }
            if (this.axis.isVertical()) {
                double padding = (this.max - this.min) * (double)0.05f;
                this.max += padding;
                this.min -= padding;
            }
        }
        if ((majorTickFinder = this.majorTickFinder) instanceof AutoMajorTickFinder && (tickFinder = (AutoMajorTickFinder)majorTickFinder).isAutoAdjust()) {
            tickFinder.calculateAutoTickMultiple(this.min, this.max);
        }
        this.majorTicks = this.majorTickFinder.find(this.min, this.max, this.majorTicks);
        this.minorTicks = this.minorTickFinder.find(this.min, this.max, this.majorTicks, this.minorTicks);
        if (this.tickLabels.length < this.majorTicks.length) {
            this.tickLabels = new TextRenderer.Line[this.majorTicks.length];
        }
        textRenderer.setScale(0.4f);
        this.maxLabelWidth = 0.0f;
        double maxDiff = DAM.max(DAM.diff(this.majorTicks));
        int significantPlaces = (int)Math.abs(Math.log10(maxDiff)) + 2;
        DecimalFormat format = new DecimalFormat();
        format.setMaximumFractionDigits(significantPlaces);
        for (int i = 0; i < this.tickLabels.length && !Double.isNaN(this.majorTicks[i]); ++i) {
            this.tickLabels[i] = textRenderer.line(Component.m_237113_((String)format.format(this.majorTicks[i])).m_7532_());
            if (!(this.tickLabels[i].getWidth() > this.maxLabelWidth)) continue;
            this.maxLabelWidth = this.tickLabels[i].getWidth();
        }
    }

    void applyPadding(GraphView graphView) {
        textRenderer.setScale(0.4f);
        if (this.axis.isHorizontal()) {
            graphView.sy1 -= textRenderer.getFontHeight() + 2.0f;
            if (this.label != null) {
                textRenderer.setScale(1.0f);
                graphView.sy1 -= textRenderer.getFontHeight() + 3.0f;
            }
        } else {
            float off = this.maxLabelWidth + 2.0f;
            if (this.label != null) {
                textRenderer.setScale(1.0f);
                off += textRenderer.getFontHeight() + 3.0f;
            }
            graphView.sx0 += off;
        }
    }

    void drawGridLines(Matrix4f pose, VertexConsumer buffer, GraphView view, GraphAxis other, boolean major, float d, int r, int g, int b, int a) {
        double[] pos = major ? this.majorTicks : this.minorTicks;
        float dHalf = d / 2.0f;
        if (this.axis.isHorizontal()) {
            float otherMin = view.g2sY(other.max);
            float otherMax = view.g2sY(other.min);
            this.drawLinesOnHorizontal(pose, buffer, view, pos, dHalf, otherMin, otherMax, r, g, b, a);
        } else {
            float otherMin = view.g2sX(other.min);
            float otherMax = view.g2sX(other.max);
            this.drawLinesOnVertical(pose, buffer, view, pos, dHalf, otherMin, otherMax, r, g, b, a);
        }
    }

    void drawTicks(Matrix4f pose, VertexConsumer buffer, GraphView view, GraphAxis other, boolean major, float thickness, float length, int r, int g, int b, int a) {
        double[] pos = major ? this.majorTicks : this.minorTicks;
        float dHalf = thickness / 2.0f;
        if (this.axis.isHorizontal()) {
            float otherMin = view.g2sY(other.min);
            this.drawLinesOnHorizontal(pose, buffer, view, pos, dHalf, otherMin - length, otherMin, r, g, b, a);
        } else {
            float otherMin = view.g2sX(other.min);
            this.drawLinesOnVertical(pose, buffer, view, pos, dHalf, otherMin, otherMin + length, r, g, b, a);
        }
    }

    private void drawLinesOnHorizontal(Matrix4f pose, VertexConsumer buffer, GraphView view, double[] pos, float dHalf, float crossLow, float crossHigh, int r, int g, int b, int a) {
        for (double p : pos) {
            if (Double.isNaN(p)) break;
            if (p < this.min || p > this.max) continue;
            float fp = view.g2sX(p);
            float x0 = fp - dHalf;
            float x1 = fp + dHalf;
            GuiDraw.drawRectRaw(buffer, pose, x0, crossLow, x1, crossHigh, r, g, b, a);
        }
    }

    private void drawLinesOnVertical(Matrix4f pose, VertexConsumer buffer, GraphView view, double[] pos, float dHalf, float crossLow, float crossHigh, int r, int g, int b, int a) {
        for (double p : pos) {
            if (Double.isNaN(p)) break;
            if (p < this.min || p > this.max) continue;
            float fp = view.g2sY(p);
            float y0 = fp - dHalf;
            float y1 = fp + dHalf;
            GuiDraw.drawRectRaw(buffer, pose, crossLow, y0, crossHigh, y1, r, g, b, a);
        }
    }

    void drawLabels(GraphView view, GraphAxis other, GuiGraphics graphics) {
        textRenderer.setHardWrapOnBorder(false);
        if (this.axis.isHorizontal()) {
            double pos;
            textRenderer.setScale(0.4f);
            textRenderer.setAlignment(Alignment.TopCenter, 100.0f);
            float y = view.g2sY(other.min) + 2.0f;
            for (int i = 0; i < this.majorTicks.length && !Double.isNaN(pos = this.majorTicks[i]); ++i) {
                if (pos < this.min || pos > this.max) continue;
                textRenderer.setPos((int)(view.g2sX(pos) - 50.0f), (int)y);
                textRenderer.drawSimple(graphics, this.tickLabels[i].getText());
            }
        } else {
            double pos;
            textRenderer.setScale(0.4f);
            textRenderer.setAlignment(Alignment.CenterRight, this.maxLabelWidth, 20.0f);
            float x = view.g2sX(other.min) - 2.0f - this.maxLabelWidth;
            for (int i = 0; i < this.majorTicks.length && !Double.isNaN(pos = this.majorTicks[i]); ++i) {
                if (pos < this.min || pos > this.max) continue;
                textRenderer.setPos((int)x, (int)(view.g2sY(pos) - 10.0f));
                textRenderer.drawSimple(graphics, this.tickLabels[i].getText());
            }
        }
    }

    @Generated
    public GuiAxis getAxis() {
        return this.axis;
    }

    @Generated
    public MajorTickFinder getMajorTickFinder() {
        return this.majorTickFinder;
    }

    @Generated
    public MinorTickFinder getMinorTickFinder() {
        return this.minorTickFinder;
    }

    @Generated
    public String getLabel() {
        return this.label;
    }

    @Generated
    public double getMin() {
        return this.min;
    }

    @Generated
    public double getMax() {
        return this.max;
    }
}

