/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.drawable.graph;

import brachy.modularui.drawable.graph.MinorTickFinder;

public class AutoMinorTickFinder
implements MinorTickFinder {
    private final int amountBetweenMajors;

    public AutoMinorTickFinder(int amountBetweenMajors) {
        this.amountBetweenMajors = amountBetweenMajors;
    }

    @Override
    public double[] find(double min, double max, double[] majorTicks, double[] ticks) {
        int s = majorTicks.length * this.amountBetweenMajors;
        if (ticks.length < s) {
            ticks = new double[s];
        }
        int k = 0;
        block0: for (int i = 0; i < majorTicks.length - 1 && !Double.isNaN(majorTicks[i + 1]); ++i) {
            double next = majorTicks[i];
            double d = (majorTicks[i + 1] - next) / (double)(this.amountBetweenMajors + 1);
            for (int j = 0; j < this.amountBetweenMajors; ++j) {
                if ((next += d) >= min) {
                    ticks[k++] = next;
                }
                if (!(next > max)) continue;
                ticks[k] = Double.NaN;
                continue block0;
            }
        }
        if (k < ticks.length) {
            ticks[k] = Double.NaN;
        }
        return ticks;
    }
}

