/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.drawable.graph;

import brachy.modularui.drawable.graph.MajorTickFinder;
import lombok.Generated;

public class AutoMajorTickFinder
implements MajorTickFinder {
    private final boolean autoAdjust;
    private double multiple = 10.0;

    public AutoMajorTickFinder(boolean autoAdjust) {
        this.autoAdjust = autoAdjust;
    }

    public AutoMajorTickFinder(double multiple) {
        this.autoAdjust = false;
        this.multiple = multiple;
    }

    @Override
    public double[] find(double min, double max, double[] ticks) {
        int s = (int)Math.ceil((max - min) / this.multiple) + 2;
        if (s > ticks.length) {
            ticks = new double[s];
        }
        double next = Math.floor(min / this.multiple) * this.multiple;
        for (int i = 0; i < s; ++i) {
            ticks[i] = next;
            if (next > max) {
                s = i + 1;
                break;
            }
            next += this.multiple;
        }
        if (ticks.length > s) {
            ticks[s] = Double.NaN;
        }
        return ticks;
    }

    void calculateAutoTickMultiple(double min, double max) {
        double step = (max - min) / 5.0;
        if (step < 1.0) {
            int significantPlaces = (int)Math.abs(Math.log10(step)) + 2;
            double ten = Math.pow(10.0, significantPlaces);
            step = (double)((int)(step * ten + (double)0.2f)) / ten;
        } else if (step == 1.0) {
            step = 0.2f;
        } else {
            int significantPlaces = (int)Math.log10(step) - 1;
            double ten = Math.pow(10.0, significantPlaces);
            step = (double)((int)(step / ten + (double)0.2f)) * ten;
        }
        this.setMultiple(step);
    }

    @Generated
    public boolean isAutoAdjust() {
        return this.autoAdjust;
    }

    @Generated
    public void setMultiple(double multiple) {
        this.multiple = multiple;
    }
}

