/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.drawable;

import brachy.modularui.api.GuiAxis;
import brachy.modularui.drawable.UITexture;
import java.util.Objects;
import lombok.Generated;

public class TabTexture {
    private final UITexture startActive;
    private final UITexture active;
    private final UITexture endActive;
    private final UITexture startInactive;
    private final UITexture inactive;
    private final UITexture endInactive;
    private final int width;
    private final int height;
    private final int textureInset;
    private final GuiAxis axis;
    private final boolean positive;

    public static TabTexture of(UITexture texture, GuiAxis axis, boolean positive, int width, int height, int textureInset) {
        UITexture ea;
        UITexture ma;
        UITexture sa;
        UITexture ei;
        UITexture mi;
        UITexture si;
        Objects.requireNonNull(texture);
        if (axis.isVertical() && !positive) {
            si = texture.getSubArea(0.0f, 0.0f, 0.33333334f, 0.5f);
            mi = texture.getSubArea(0.33333334f, 0.0f, 0.6666667f, 0.5f);
            ei = texture.getSubArea(0.6666667f, 0.0f, 1.0f, 0.5f);
            sa = texture.getSubArea(0.0f, 0.5f, 0.33333334f, 1.0f);
            ma = texture.getSubArea(0.33333334f, 0.5f, 0.6666667f, 1.0f);
            ea = texture.getSubArea(0.6666667f, 0.5f, 1.0f, 1.0f);
        } else if (axis.isVertical()) {
            sa = texture.getSubArea(0.0f, 0.0f, 0.33333334f, 0.5f);
            ma = texture.getSubArea(0.33333334f, 0.0f, 0.6666667f, 0.5f);
            ea = texture.getSubArea(0.6666667f, 0.0f, 1.0f, 0.5f);
            si = texture.getSubArea(0.0f, 0.5f, 0.33333334f, 1.0f);
            mi = texture.getSubArea(0.33333334f, 0.5f, 0.6666667f, 1.0f);
            ei = texture.getSubArea(0.6666667f, 0.5f, 1.0f, 1.0f);
        } else if (axis.isHorizontal() && !positive) {
            si = texture.getSubArea(0.0f, 0.0f, 0.5f, 0.33333334f);
            mi = texture.getSubArea(0.0f, 0.33333334f, 0.5f, 0.6666667f);
            ei = texture.getSubArea(0.0f, 0.6666667f, 0.5f, 1.0f);
            sa = texture.getSubArea(0.5f, 0.0f, 1.0f, 0.33333334f);
            ma = texture.getSubArea(0.5f, 0.33333334f, 1.0f, 0.6666667f);
            ea = texture.getSubArea(0.5f, 0.6666667f, 1.0f, 1.0f);
        } else if (axis.isHorizontal()) {
            sa = texture.getSubArea(0.0f, 0.0f, 0.5f, 0.33333334f);
            ma = texture.getSubArea(0.0f, 0.33333334f, 0.5f, 0.6666667f);
            ea = texture.getSubArea(0.0f, 0.6666667f, 0.5f, 1.0f);
            si = texture.getSubArea(0.5f, 0.0f, 1.0f, 0.33333334f);
            mi = texture.getSubArea(0.5f, 0.33333334f, 1.0f, 0.6666667f);
            ei = texture.getSubArea(0.5f, 0.6666667f, 1.0f, 1.0f);
        } else {
            throw new IllegalArgumentException();
        }
        return new TabTexture(sa, ma, ea, si, mi, ei, width, height, textureInset, axis, positive);
    }

    public TabTexture(UITexture startActive, UITexture active, UITexture endActive, UITexture startInactive, UITexture inactive, UITexture endInactive, int width, int height, int textureInset, GuiAxis axis, boolean positive) {
        this.startActive = startActive;
        this.active = active;
        this.endActive = endActive;
        this.startInactive = startInactive;
        this.inactive = inactive;
        this.endInactive = endInactive;
        this.width = width;
        this.height = height;
        this.textureInset = textureInset;
        this.axis = axis;
        this.positive = positive;
    }

    public UITexture getStart(boolean active) {
        return active ? this.startActive : this.startInactive;
    }

    public UITexture getMiddle(boolean active) {
        return active ? this.active : this.inactive;
    }

    public UITexture getEnd(boolean active) {
        return active ? this.endActive : this.endInactive;
    }

    public UITexture get(int location, boolean active) {
        if (location == 0) {
            return this.getMiddle(active);
        }
        if (location < 0) {
            return this.getStart(active);
        }
        return this.getEnd(active);
    }

    @Generated
    public int getWidth() {
        return this.width;
    }

    @Generated
    public int getHeight() {
        return this.height;
    }

    @Generated
    public int getTextureInset() {
        return this.textureInset;
    }

    @Generated
    public GuiAxis getAxis() {
        return this.axis;
    }

    @Generated
    public boolean isPositive() {
        return this.positive;
    }
}

