/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.drawable;

import brachy.modularui.api.IJsonSerializable;
import brachy.modularui.api.drawable.IDrawable;
import brachy.modularui.drawable.GuiDraw;
import brachy.modularui.screen.viewport.GuiContext;
import brachy.modularui.theme.WidgetTheme;
import brachy.modularui.utils.Color;
import brachy.modularui.utils.serialization.json.JsonHelper;
import com.google.gson.JsonObject;

public record Scrollbar(boolean striped) implements IDrawable,
IJsonSerializable
{
    public static final Scrollbar DEFAULT = new Scrollbar(false);
    public static final Scrollbar VANILLA = new Scrollbar(true);

    public static Scrollbar ofJson(JsonObject json) {
        if (JsonHelper.getBoolean(json, false, "striped", "vanilla")) {
            return VANILLA;
        }
        return DEFAULT;
    }

    @Override
    public void draw(GuiContext context, int x, int y, int width, int height, WidgetTheme widgetTheme) {
        block5: {
            GuiDraw.drawRect(context.getGraphics(), x, y, width, height, Color.mix(-1118482, widgetTheme.getColor()));
            GuiDraw.drawRect(context.getGraphics(), x + 1, y + 1, width - 1, height - 1, Color.mix(-10066330, widgetTheme.getColor()));
            GuiDraw.drawRect(context.getGraphics(), x + 1, y + 1, width - 2, height - 2, Color.mix(-5592406, widgetTheme.getColor()));
            if (!this.striped()) break block5;
            if (height <= 5 && width <= 5) {
                return;
            }
            int color = widgetTheme.getTextColor();
            if (height >= width) {
                int start = y + 2;
                int end = height + start - 4;
                for (int cy = start; cy < end; cy += 2) {
                    GuiDraw.drawRect(context.getGraphics(), x + 2, cy, width - 4, 1.0f, color);
                }
            } else {
                int start = x + 2;
                int end = width + start - 4;
                for (int cx = start; cx < end; cx += 2) {
                    GuiDraw.drawRect(context.getGraphics(), cx, y + 2, 1.0f, height - 4, color);
                }
            }
        }
    }

    @Override
    public boolean canApplyTheme() {
        return true;
    }

    @Override
    public boolean saveToJson(JsonObject json) {
        json.addProperty("striped", Boolean.valueOf(this.striped));
        return true;
    }
}

