/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.drawable;

import brachy.modularui.GTRenderTypes;
import brachy.modularui.ModularUI;
import brachy.modularui.animation.IAnimatable;
import brachy.modularui.api.IJsonSerializable;
import brachy.modularui.api.drawable.IDrawable;
import brachy.modularui.drawable.GuiDraw;
import brachy.modularui.screen.viewport.GuiContext;
import brachy.modularui.theme.WidgetTheme;
import brachy.modularui.utils.Color;
import brachy.modularui.utils.Interpolations;
import brachy.modularui.utils.serialization.json.JsonHelper;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.IntConsumer;
import lombok.Generated;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class Rectangle
implements IDrawable,
IJsonSerializable<Rectangle>,
IAnimatable<Rectangle> {
    private int cornerRadius;
    private int colorTL;
    private int colorTR;
    private int colorBL;
    private int colorBR;
    private int cornerSegments;
    private float borderThickness;
    private boolean canApplyTheme = false;

    public Rectangle() {
        this.color(-1);
        this.cornerRadius = 0;
        this.cornerSegments = 6;
    }

    public int getColor() {
        return this.colorTL;
    }

    public Rectangle cornerRadius(int cornerRadius) {
        this.cornerRadius = Math.max(0, cornerRadius);
        if (this.borderThickness > 0.0f && cornerRadius > 0) {
            ModularUI.LOGGER.error("Hollow rectangles currently can't have a corner radius.");
        }
        return this;
    }

    public Rectangle color(int colorTL, int colorTR, int colorBL, int colorBR) {
        this.colorTL = colorTL;
        this.colorTR = colorTR;
        this.colorBL = colorBL;
        this.colorBR = colorBR;
        return this;
    }

    public Rectangle verticalGradient(int colorTop, int colorBottom) {
        return this.color(colorTop, colorTop, colorBottom, colorBottom);
    }

    public Rectangle horizontalGradient(int colorLeft, int colorRight) {
        return this.color(colorLeft, colorRight, colorLeft, colorRight);
    }

    public Rectangle color(int color) {
        return this.color(color, color, color, color);
    }

    public Rectangle solid() {
        this.borderThickness = 0.0f;
        return this;
    }

    public Rectangle hollow(float borderThickness) {
        this.borderThickness = borderThickness;
        if (borderThickness > 0.0f && this.cornerRadius > 0) {
            ModularUI.LOGGER.error("Hollow rectangles currently can't have a corner radius.");
        }
        return this;
    }

    public Rectangle hollow() {
        return this.hollow(1.0f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(GuiContext context, int x0, int y0, int width, int height, WidgetTheme widgetTheme) {
        this.applyColor(widgetTheme.getColor());
        if (this.borderThickness <= 0.0f) {
            if (this.cornerRadius <= 0) {
                GuiDraw.drawRect(context.getGraphics(), x0, y0, width, height, this.colorTL, this.colorTR, this.colorBL, this.colorBR);
                return;
            }
            GuiDraw.drawRoundedRect(context.getGraphics(), x0, y0, width, height, this.colorTL, this.colorTR, this.colorBL, this.colorBR, this.cornerRadius, this.cornerSegments);
        } else {
            float d = this.borderThickness;
            float x1 = x0 + width;
            float y1 = y0 + height;
            Matrix4f pose = context.getGraphics().m_280168_().m_85850_().m_252922_();
            VertexConsumer bufferbuilder = context.getGraphics().m_280091_().m_6299_(GTRenderTypes.guiTriangleStrip());
            Rectangle.v(pose, bufferbuilder, x0, y0, this.colorTL);
            Rectangle.v(pose, bufferbuilder, x1 - d, (float)y0 + d, this.colorTR);
            Rectangle.v(pose, bufferbuilder, x1, y0, this.colorTR);
            Rectangle.v(pose, bufferbuilder, x1 - d, y1 - d, this.colorBR);
            Rectangle.v(pose, bufferbuilder, x1, y1, this.colorBR);
            Rectangle.v(pose, bufferbuilder, (float)x0 + d, y1 - d, this.colorBL);
            Rectangle.v(pose, bufferbuilder, x0, y1, this.colorBL);
            Rectangle.v(pose, bufferbuilder, (float)x0 + d, (float)y0 + d, this.colorTL);
            Rectangle.v(pose, bufferbuilder, x0, y0, this.colorTL);
            Rectangle.v(pose, bufferbuilder, x1 - d, (float)y0 + d, this.colorTR);
        }
    }

    private static void v(Matrix4f pose, VertexConsumer buffer, float x, float y, int c) {
        buffer.m_252986_(pose, x, y, 0.0f).m_6122_(Color.getRed(c), Color.getGreen(c), Color.getBlue(c), Color.getAlpha(c)).m_5752_();
    }

    @Override
    public void loadFromJson(JsonObject json) {
        int c;
        if (json.has("color")) {
            this.color(Color.ofJson(json.get("color")));
        }
        if (json.has("colorTop")) {
            this.colorTL = c = Color.ofJson(json.get("colorTop"));
            this.colorTR = c;
        }
        if (json.has("colorBottom")) {
            this.colorBL = c = Color.ofJson(json.get("colorBottom"));
            this.colorBR = c;
        }
        if (json.has("colorLeft")) {
            this.colorTL = c = Color.ofJson(json.get("colorLeft"));
            this.colorBL = c;
        }
        if (json.has("colorRight")) {
            this.colorTR = c = Color.ofJson(json.get("colorRight"));
            this.colorBR = c;
        }
        this.setColor(json, val -> {
            this.colorTL = val;
        }, "colorTopLeft", "colorTL");
        this.setColor(json, val -> {
            this.colorTR = val;
        }, "colorTopRight", "colorTR");
        this.setColor(json, val -> {
            this.colorBL = val;
        }, "colorBottomLeft", "colorBL");
        this.setColor(json, val -> {
            this.colorBR = val;
        }, "colorBottomRight", "colorBR");
        this.cornerRadius = JsonHelper.getInt(json, 0, "cornerRadius");
        this.cornerSegments = JsonHelper.getInt(json, 10, "cornerSegments");
        this.borderThickness = JsonHelper.getBoolean(json, false, "solid") ? 0.0f : (JsonHelper.getBoolean(json, false, "hollow") ? 1.0f : JsonHelper.getFloat(json, 0.0f, "borderThickness"));
    }

    @Override
    public boolean saveToJson(JsonObject json) {
        json.addProperty("colorTL", (Number)this.colorTL);
        json.addProperty("colorTR", (Number)this.colorTR);
        json.addProperty("colorBL", (Number)this.colorBL);
        json.addProperty("colorBR", (Number)this.colorBR);
        json.addProperty("cornerRadius", (Number)this.cornerRadius);
        json.addProperty("cornerSegments", (Number)this.cornerSegments);
        json.addProperty("borderThickness", (Number)Float.valueOf(this.borderThickness));
        return true;
    }

    private void setColor(JsonObject json, IntConsumer color, String ... keys) {
        JsonElement element = JsonHelper.getJsonElement(json, keys);
        if (element != null) {
            color.accept(Color.ofJson(element));
        }
    }

    @Override
    public Rectangle interpolate(Rectangle start, Rectangle end, float t) {
        this.cornerRadius = Interpolations.lerp(start.cornerRadius, end.cornerRadius, t);
        this.cornerSegments = Interpolations.lerp(start.cornerSegments, end.cornerSegments, t);
        this.colorTL = Color.lerp(start.colorTL, end.colorTL, t);
        this.colorTR = Color.lerp(start.colorTR, end.colorTR, t);
        this.colorBL = Color.lerp(start.colorBL, end.colorBL, t);
        this.colorBR = Color.lerp(start.colorBR, end.colorBR, t);
        return this;
    }

    @Override
    public Rectangle copyOrImmutable() {
        return new Rectangle().color(this.colorTL, this.colorTR, this.colorBL, this.colorBR).cornerRadius(this.cornerRadius).cornerSegments(this.cornerSegments).canApplyTheme(this.canApplyTheme);
    }

    @NotNull
    @Generated
    public Rectangle cornerSegments(int cornerSegments) {
        this.cornerSegments = cornerSegments;
        return this;
    }

    @Override
    @Generated
    public boolean canApplyTheme() {
        return this.canApplyTheme;
    }

    @NotNull
    @Generated
    public Rectangle canApplyTheme(boolean canApplyTheme) {
        this.canApplyTheme = canApplyTheme;
        return this;
    }
}

