/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.drawable;

import brachy.modularui.api.IJsonSerializable;
import brachy.modularui.api.drawable.IDrawable;
import brachy.modularui.drawable.GuiDraw;
import brachy.modularui.screen.viewport.GuiContext;
import brachy.modularui.theme.WidgetTheme;
import brachy.modularui.utils.serialization.json.JsonHelper;
import brachy.modularui.widget.Widget;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.NoSuchElementException;
import lombok.Generated;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemDrawable
implements IDrawable,
IJsonSerializable<ItemDrawable> {
    private ItemStack item = ItemStack.f_41583_;

    public ItemDrawable() {
    }

    public ItemDrawable(@NotNull ItemStack item) {
        this.setItem(item);
    }

    public ItemDrawable(@NotNull Item item) {
        this.setItem(item);
    }

    public ItemDrawable(@NotNull Item item, int amount) {
        this.setItem(item, amount);
    }

    public ItemDrawable(@NotNull Item item, int amount, @Nullable CompoundTag nbt) {
        this.setItem(item, amount, nbt);
    }

    public ItemDrawable(@NotNull Block item) {
        this.setItem(item);
    }

    public ItemDrawable(@NotNull Block item, int amount) {
        this.setItem(new ItemStack((ItemLike)item, amount));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(GuiContext context, int x, int y, int width, int height, WidgetTheme widgetTheme) {
        this.applyColor(widgetTheme.getColor());
        GuiDraw.drawItem(context.getGraphics(), this.item, x, y, width, height, context.getCurrentDrawingZ());
    }

    @Override
    public int getDefaultWidth() {
        return 16;
    }

    @Override
    public int getDefaultHeight() {
        return 16;
    }

    @Override
    public Widget<?> asWidget() {
        return (Widget)IDrawable.super.asWidget().size(16);
    }

    public ItemDrawable setItem(@NotNull ItemStack item) {
        this.item = item;
        return this;
    }

    public ItemDrawable setItem(@NotNull Item item) {
        return this.setItem(item, 1, null);
    }

    public ItemDrawable setItem(@NotNull Item item, int amount) {
        return this.setItem(item, amount, null);
    }

    public ItemDrawable setItem(@NotNull Item item, int amount, @Nullable CompoundTag nbt) {
        ItemStack itemStack = new ItemStack((ItemLike)item, amount);
        itemStack.m_41751_(nbt);
        return this.setItem(itemStack);
    }

    public ItemDrawable setItem(@NotNull Block item) {
        return this.setItem(item, 1);
    }

    public ItemDrawable setItem(@NotNull Block item, int amount) {
        return this.setItem(new ItemStack((ItemLike)item, amount));
    }

    public static ItemDrawable ofJson(JsonObject json) {
        ItemStack stack;
        String itemName = JsonHelper.getString(json, null, "item");
        if (itemName == null) {
            throw new JsonParseException("Item property not found!");
        }
        if (itemName.isEmpty()) {
            return new ItemDrawable();
        }
        try {
            ResourceLocation id = new ResourceLocation(itemName);
            stack = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(id));
        }
        catch (NoSuchElementException e) {
            throw new JsonParseException((Throwable)e);
        }
        if (json.has("nbt")) {
            CompoundTag nbt = (CompoundTag)JsonOps.INSTANCE.convertTo((DynamicOps)NbtOps.f_128958_, (JsonElement)JsonHelper.getObject(json, new JsonObject(), o -> o, "nbt"));
            stack.m_41751_(nbt);
        }
        return new ItemDrawable(stack);
    }

    @Override
    public boolean saveToJson(JsonObject json) {
        if (this.item == null || this.item.m_41619_()) {
            json.addProperty("item", "");
            return true;
        }
        json.addProperty("item", ((ResourceKey)this.item.m_220173_().m_203543_().get()).m_135782_().toString());
        if (this.item.m_41782_()) {
            json.addProperty("nbt", this.item.m_41783_().toString());
        }
        return true;
    }

    @Generated
    public ItemStack getItem() {
        return this.item;
    }
}

