/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.drawable;

import brachy.modularui.api.IJsonSerializable;
import brachy.modularui.api.drawable.IDrawable;
import brachy.modularui.drawable.GuiDraw;
import brachy.modularui.screen.viewport.GuiContext;
import brachy.modularui.theme.WidgetTheme;
import lombok.Generated;
import net.minecraft.Util;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class IngredientDrawable
implements IDrawable,
IJsonSerializable<IngredientDrawable> {
    private ItemStack[] items;
    private int cycleTime = 1000;

    public IngredientDrawable(Ingredient ingredient) {
        this(ingredient.m_43908_());
    }

    public IngredientDrawable(ItemStack ... items) {
        this.setItems(items);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(GuiContext context, int x, int y, int width, int height, WidgetTheme widgetTheme) {
        if (this.items.length == 0) {
            return;
        }
        ItemStack item = this.items[(int)(Util.m_137550_() % (long)(this.cycleTime * this.items.length)) / this.cycleTime];
        if (item != null) {
            GuiDraw.drawItem(context.getGraphics(), item, x, y, width, height, context.getCurrentDrawingZ());
        }
    }

    public IngredientDrawable cycleTime(int cycleTime) {
        this.cycleTime = cycleTime;
        return this;
    }

    public void setItems(Ingredient ingredient) {
        this.setItems(ingredient.m_43908_());
    }

    @Generated
    public ItemStack[] getItems() {
        return this.items;
    }

    @Generated
    public void setItems(ItemStack[] items) {
        this.items = items;
    }

    @Generated
    public int getCycleTime() {
        return this.cycleTime;
    }

    @Generated
    public void setCycleTime(int cycleTime) {
        this.cycleTime = cycleTime;
    }
}

