/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.drawable;

import brachy.modularui.GTRenderTypes;
import brachy.modularui.ModularUI;
import brachy.modularui.client.GuiSpriteManager;
import brachy.modularui.drawable.UITexture;
import brachy.modularui.drawable.text.TextRenderer;
import brachy.modularui.screen.RichTooltip;
import brachy.modularui.screen.event.RichTooltipEvent;
import brachy.modularui.screen.viewport.GuiContext;
import brachy.modularui.screen.viewport.ModularGuiContext;
import brachy.modularui.utils.Alignment;
import brachy.modularui.utils.Color;
import brachy.modularui.utils.FormattingUtil;
import brachy.modularui.utils.RectangleF;
import brachy.modularui.widget.sizer.Area;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4d;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3d;

public class GuiDraw {
    private static final TextRenderer textRenderer = new TextRenderer();

    public static void drawRect(GuiGraphics graphics, float x0, float y0, float w, float h, int color) {
        Matrix4f pose = graphics.m_280168_().m_85850_().m_252922_();
        VertexConsumer builder = graphics.m_280091_().m_6299_(RenderType.m_286086_());
        GuiDraw.drawRectRaw(builder, pose, x0, y0, x0 + w, y0 + h, color);
    }

    public static void drawHorizontalGradientRect(GuiGraphics graphics, float x0, float y0, float w, float h, int colorLeft, int colorRight) {
        GuiDraw.drawRect(graphics, x0, y0, w, h, colorLeft, colorRight, colorLeft, colorRight);
    }

    public static void drawVerticalGradientRect(GuiGraphics graphics, float x0, float y0, float w, float h, int colorTop, int colorBottom) {
        GuiDraw.drawRect(graphics, x0, y0, w, h, colorTop, colorTop, colorBottom, colorBottom);
    }

    public static void drawRect(GuiGraphics graphics, float x0, float y0, float w, float h, int colorTL, int colorTR, int colorBL, int colorBR) {
        Matrix4f pose = graphics.m_280168_().m_85850_().m_252922_();
        VertexConsumer bufferbuilder = graphics.m_280091_().m_6299_(RenderType.m_286086_());
        float x1 = x0 + w;
        float y1 = y0 + h;
        bufferbuilder.m_252986_(pose, x0, y0, 0.0f).m_6122_(Color.getRed(colorTL), Color.getGreen(colorTL), Color.getBlue(colorTL), Color.getAlpha(colorTL)).m_5752_();
        bufferbuilder.m_252986_(pose, x0, y1, 0.0f).m_6122_(Color.getRed(colorBL), Color.getGreen(colorBL), Color.getBlue(colorBL), Color.getAlpha(colorBL)).m_5752_();
        bufferbuilder.m_252986_(pose, x1, y1, 0.0f).m_6122_(Color.getRed(colorBR), Color.getGreen(colorBR), Color.getBlue(colorBR), Color.getAlpha(colorBR)).m_5752_();
        bufferbuilder.m_252986_(pose, x1, y0, 0.0f).m_6122_(Color.getRed(colorTR), Color.getGreen(colorTR), Color.getBlue(colorTR), Color.getAlpha(colorTR)).m_5752_();
    }

    public static void drawRectRaw(VertexConsumer buffer, Matrix4f pose, float x0, float y0, float x1, float y1, int color) {
        int r = Color.getRed(color);
        int g = Color.getGreen(color);
        int b = Color.getBlue(color);
        int a = Color.getAlpha(color);
        GuiDraw.drawRectRaw(buffer, pose, x0, y0, x1, y1, r, g, b, a);
    }

    public static void drawRectRaw(VertexConsumer buffer, Matrix4f pose, float x0, float y0, float x1, float y1, int r, int g, int b, int a) {
        buffer.m_252986_(pose, x0, y0, 0.0f).m_6122_(r, g, b, a).m_5752_();
        buffer.m_252986_(pose, x0, y1, 0.0f).m_6122_(r, g, b, a).m_5752_();
        buffer.m_252986_(pose, x1, y1, 0.0f).m_6122_(r, g, b, a).m_5752_();
        buffer.m_252986_(pose, x1, y0, 0.0f).m_6122_(r, g, b, a).m_5752_();
    }

    public static void drawCircle(GuiGraphics graphics, float x0, float y0, float diameter, int color, int segments) {
        GuiDraw.drawEllipse(graphics, x0, y0, diameter, diameter, color, color, segments);
    }

    public static void drawCircle(GuiGraphics graphics, float x0, float y0, float diameter, int centerColor, int outerColor, int segments) {
        GuiDraw.drawEllipse(graphics, x0, y0, diameter, diameter, centerColor, outerColor, segments);
    }

    public static void drawEllipse(GuiGraphics graphics, float x0, float y0, float w, float h, int color, int segments) {
        GuiDraw.drawEllipse(graphics, x0, y0, w, h, color, color, segments);
    }

    public static void drawEllipse(GuiGraphics graphics, float x0, float y0, float w, float h, int centerColor, int outerColor, int segments) {
        Matrix4f pose = graphics.m_280168_().m_85850_().m_252922_();
        VertexConsumer bufferbuilder = graphics.m_280091_().m_6299_(GTRenderTypes.guiOverlayTriangleFan());
        float x_2 = x0 + w / 2.0f;
        float y_2 = y0 + h / 2.0f;
        bufferbuilder.m_252986_(pose, x_2, y_2, 0.0f).m_6122_(Color.getRed(centerColor), Color.getGreen(centerColor), Color.getBlue(centerColor), Color.getAlpha(centerColor)).m_5752_();
        int a = Color.getAlpha(outerColor);
        int r = Color.getRed(outerColor);
        int g = Color.getGreen(outerColor);
        int b = Color.getBlue(outerColor);
        float incr = (float)Math.PI * 2 / (float)segments;
        for (int i = 0; i <= segments; ++i) {
            float angle = incr * (float)i;
            float x = Mth.m_14031_((float)angle) * (w / 2.0f) + x_2;
            float y = Mth.m_14089_((float)angle) * (h / 2.0f) + y_2;
            bufferbuilder.m_5483_((double)x, (double)y, 0.0).m_6122_(r, g, b, a).m_5752_();
        }
        RenderSystem.disableBlend();
    }

    public static void drawRoundedRect(GuiGraphics graphics, float x0, float y0, float w, float h, int color, int cornerRadius, int segments) {
        GuiDraw.drawRoundedRect(graphics, x0, y0, w, h, color, color, color, color, cornerRadius, segments);
    }

    public static void drawVerticalGradientRoundedRect(GuiGraphics graphics, float x0, float y0, float w, float h, int colorTop, int colorBottom, int cornerRadius, int segments) {
        GuiDraw.drawRoundedRect(graphics, x0, y0, w, h, colorTop, colorTop, colorBottom, colorBottom, cornerRadius, segments);
    }

    public static void drawHorizontalGradientRoundedRect(GuiGraphics graphics, float x0, float y0, float w, float h, int colorLeft, int colorRight, int cornerRadius, int segments) {
        GuiDraw.drawRoundedRect(graphics, x0, y0, w, h, colorLeft, colorRight, colorLeft, colorRight, cornerRadius, segments);
    }

    public static void drawRoundedRect(GuiGraphics graphics, float x0, float y0, float w, float h, int colorTL, int colorTR, int colorBL, int colorBR, int cornerRadius, int segments) {
        float y;
        float x;
        int i;
        Matrix4f pose = graphics.m_280168_().m_85850_().m_252922_();
        VertexConsumer bufferbuilder = graphics.m_280091_().m_6299_(GTRenderTypes.guiOverlayTriangleFan());
        float x1 = x0 + w;
        float y1 = y0 + h;
        int color = Color.average(colorBL, colorBR, colorTR, colorTL);
        bufferbuilder.m_252986_(pose, x0 + w / 2.0f, y0 + h / 2.0f, 0.0f).m_6122_(Color.getRed(color), Color.getGreen(color), Color.getBlue(color), Color.getAlpha(color)).m_5752_();
        bufferbuilder.m_252986_(pose, x0, y0 + (float)cornerRadius, 0.0f).m_6122_(Color.getRed(colorTL), Color.getGreen(colorTL), Color.getBlue(colorTL), Color.getAlpha(colorTL)).m_5752_();
        bufferbuilder.m_252986_(pose, x0, y1 - (float)cornerRadius, 0.0f).m_6122_(Color.getRed(colorBL), Color.getGreen(colorBL), Color.getBlue(colorBL), Color.getAlpha(colorBL)).m_5752_();
        for (i = 1; i <= segments; ++i) {
            x = x0 + (float)cornerRadius - Mth.m_14089_((float)(1.5707964f / (float)segments * (float)i)) * (float)cornerRadius;
            y = y1 - (float)cornerRadius + Mth.m_14031_((float)(1.5707964f / (float)segments * (float)i)) * (float)cornerRadius;
            bufferbuilder.m_252986_(pose, x, y, 0.0f).m_6122_(Color.getRed(colorBL), Color.getGreen(colorBL), Color.getBlue(colorBL), Color.getAlpha(colorBL)).m_5752_();
        }
        bufferbuilder.m_252986_(pose, x1 - (float)cornerRadius, y1, 0.0f).m_6122_(Color.getRed(colorBR), Color.getGreen(colorBR), Color.getBlue(colorBR), Color.getAlpha(colorBR)).m_5752_();
        for (i = 1; i <= segments; ++i) {
            x = x1 - (float)cornerRadius + Mth.m_14031_((float)(1.5707964f / (float)segments * (float)i)) * (float)cornerRadius;
            y = y1 - (float)cornerRadius + Mth.m_14089_((float)(1.5707964f / (float)segments * (float)i)) * (float)cornerRadius;
            bufferbuilder.m_252986_(pose, x, y, 0.0f).m_6122_(Color.getRed(colorBR), Color.getGreen(colorBR), Color.getBlue(colorBR), Color.getAlpha(colorBR)).m_5752_();
        }
        bufferbuilder.m_252986_(pose, x1, y0 + (float)cornerRadius, 0.0f).m_6122_(Color.getRed(colorTR), Color.getGreen(colorTR), Color.getBlue(colorTR), Color.getAlpha(colorTR)).m_5752_();
        for (i = 1; i <= segments; ++i) {
            x = x1 - (float)cornerRadius + Mth.m_14089_((float)(1.5707964f / (float)segments * (float)i)) * (float)cornerRadius;
            y = y0 + (float)cornerRadius - Mth.m_14031_((float)(1.5707964f / (float)segments * (float)i)) * (float)cornerRadius;
            bufferbuilder.m_252986_(pose, x, y, 0.0f).m_6122_(Color.getRed(colorTR), Color.getGreen(colorTR), Color.getBlue(colorTR), Color.getAlpha(colorTR)).m_5752_();
        }
        bufferbuilder.m_252986_(pose, x0 + (float)cornerRadius, y0, 0.0f).m_6122_(Color.getRed(colorTL), Color.getGreen(colorTL), Color.getBlue(colorTL), Color.getAlpha(colorTL)).m_5752_();
        for (i = 1; i <= segments; ++i) {
            x = x0 + (float)cornerRadius - Mth.m_14031_((float)(1.5707964f / (float)segments * (float)i)) * (float)cornerRadius;
            y = y0 + (float)cornerRadius - Mth.m_14089_((float)(1.5707964f / (float)segments * (float)i)) * (float)cornerRadius;
            bufferbuilder.m_252986_(pose, x, y, 0.0f).m_6122_(Color.getRed(colorTL), Color.getGreen(colorTL), Color.getBlue(colorTL), Color.getAlpha(colorTL)).m_5752_();
        }
        bufferbuilder.m_252986_(pose, x0, y0 + (float)cornerRadius, 0.0f).m_6122_(Color.getRed(colorTL), Color.getGreen(colorTL), Color.getBlue(colorTL), Color.getAlpha(colorTL)).m_5752_();
    }

    public static RectangleF setupTexture(ResourceLocation location, float u0, float v0, float u1, float v1) {
        TextureAtlasSprite sprite = GuiSpriteManager.getInstance().m_118901_(UITexture.GUI_TEXTURE_ID_CONVERTER.m_245273_(location));
        if (!sprite.m_245424_().m_246162_().equals((Object)MissingTextureAtlasSprite.m_118071_())) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.m_247685_());
            return new RectangleF(sprite.m_118367_((double)(u0 * 16.0f)), sprite.m_118393_((double)(u0 * 16.0f)), sprite.m_118367_((double)(u1 * 16.0f)), sprite.m_118393_((double)(v1 * 16.0f)));
        }
        ModularUI.LOGGER.warn("Could not find texture {} in GUI atlas", (Object)location);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)location);
        return new RectangleF(u0, v0, u1, v1);
    }

    public static boolean isGuiAtlasSprite(ResourceLocation location) {
        location = UITexture.GUI_TEXTURE_ID_CONVERTER.m_245273_(location);
        return GuiSpriteManager.getInstance().m_118901_(location).m_247685_() != MissingTextureAtlasSprite.m_118071_();
    }

    public static void drawTexture(Matrix4f pose, ResourceLocation location, float x, float y, float w, float h, int u, int v, int textureWidth, int textureHeight) {
        if (!GuiDraw.isGuiAtlasSprite(location)) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)location);
            GuiDraw.drawTexture(pose, x, y, u, v, w, h, textureWidth, textureHeight);
            return;
        }
        float tw = 1.0f / (float)textureWidth;
        float th = 1.0f / (float)textureHeight;
        RectangleF newUvs = GuiDraw.setupTexture(location, (float)u * tw, (float)v * th, ((float)u + w) * tw, ((float)v + h) * th);
        GuiDraw.drawTexture(pose, x, y, x + w, y + h, newUvs.u0(), newUvs.v0(), newUvs.u1(), newUvs.v1());
    }

    public static void drawTexture(Matrix4f pose, float x, float y, int u, int v, float w, float h, int textureW, int textureH) {
        GuiDraw.drawTexture(pose, x, y, u, v, w, h, textureW, textureH, 0.0f);
    }

    public static void drawTexture(Matrix4f pose, float x, float y, int u, int v, float w, float h, int textureW, int textureH, float z) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        GuiDraw.drawTexture(pose, (VertexConsumer)buffer, x, y, u, v, w, h, textureW, textureH, z);
        tesselator.m_85914_();
    }

    public static void drawTexture(Matrix4f pose, VertexConsumer buffer, float x, float y, int u, int v, float w, float h, int textureW, int textureH, float z) {
        float tw = 1.0f / (float)textureW;
        float th = 1.0f / (float)textureH;
        buffer.m_252986_(pose, x, y + h, z).m_7421_((float)u * tw, ((float)v + h) * th).m_5752_();
        buffer.m_252986_(pose, x + w, y + h, z).m_7421_(((float)u + w) * tw, ((float)v + h) * th).m_5752_();
        buffer.m_252986_(pose, x + w, y, z).m_7421_(((float)u + w) * tw, (float)v * th).m_5752_();
        buffer.m_252986_(pose, x, y, z).m_7421_((float)u * tw, (float)v * th).m_5752_();
    }

    public static void drawTexture(Matrix4f pose, float x, float y, int u, int v, float w, float h, int textureW, int textureH, int tu, int tv) {
        GuiDraw.drawTexture(pose, x, y, u, v, w, h, textureW, textureH, tu, tv, 0.0f);
    }

    public static void drawTexture(Matrix4f pose, float x, float y, int u, int v, float w, float h, int textureW, int textureH, int tu, int tv, float z) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        GuiDraw.drawTexture(pose, (VertexConsumer)buffer, x, y, u, v, w, h, textureW, textureH, tu, tv, z);
        tesselator.m_85914_();
    }

    public static void drawTexture(Matrix4f pose, VertexConsumer buffer, float x, float y, int u, int v, float w, float h, int textureW, int textureH, int tu, int tv, float z) {
        float tw = 1.0f / (float)textureW;
        float th = 1.0f / (float)textureH;
        buffer.m_252986_(pose, x, y + h, z).m_7421_((float)u * tw, (float)tv * th).m_5752_();
        buffer.m_252986_(pose, x + w, y + h, z).m_7421_((float)tu * tw, (float)tv * th).m_5752_();
        buffer.m_252986_(pose, x + w, y, z).m_7421_((float)tu * tw, (float)v * th).m_5752_();
        buffer.m_252986_(pose, x, y, z).m_7421_((float)u * tw, (float)v * th).m_5752_();
    }

    public static void drawTexture(Matrix4f pose, ResourceLocation location, float x0, float y0, float x1, float y1, float u0, float v0, float u1, float v1) {
        GuiDraw.drawTexture(pose, location, x0, y0, x1, y1, u0, v0, u1, v1, false);
    }

    public static void drawTexture(Matrix4f pose, ResourceLocation location, float x0, float y0, float x1, float y1, float u0, float v0, float u1, float v1, boolean withBlend) {
        RectangleF newUvs = GuiDraw.setupTexture(location, u0, v0, u1, v1);
        RenderSystem.setShader(GameRenderer::m_172817_);
        if (withBlend) {
            RenderSystem.enableBlend();
        } else {
            RenderSystem.disableBlend();
        }
        GuiDraw.drawTexture(pose, x0, y0, x1, y1, newUvs.u0(), newUvs.v0(), newUvs.u1(), newUvs.v1(), 0.0f);
    }

    public static void drawTexture(Matrix4f pose, float x0, float y0, float x1, float y1, float u0, float v0, float u1, float v1) {
        GuiDraw.drawTexture(pose, x0, y0, x1, y1, u0, v0, u1, v1, 0.0f);
    }

    public static void drawTexture(Matrix4f pose, float x0, float y0, float x1, float y1, float u0, float v0, float u1, float v1, float z) {
        RenderSystem.disableDepthTest();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        GuiDraw.drawTexture(pose, (VertexConsumer)buffer, x0, y0, x1, y1, u0, v0, u1, v1, z);
        tesselator.m_85914_();
    }

    public static void drawTexture(Matrix4f pose, VertexConsumer buffer, float x0, float y0, float x1, float y1, float u0, float v0, float u1, float v1, float z) {
        buffer.m_252986_(pose, x0, y1, z).m_7421_(u0, v1).m_5752_();
        buffer.m_252986_(pose, x1, y1, z).m_7421_(u1, v1).m_5752_();
        buffer.m_252986_(pose, x1, y0, z).m_7421_(u1, v0).m_5752_();
        buffer.m_252986_(pose, x0, y0, z).m_7421_(u0, v0).m_5752_();
    }

    public static void drawTiledTexture(Matrix4f pose, ResourceLocation location, float x, float y, float w, float h, int u, int v, int tileWidth, int tileHeight, int textureWidth, int textureHeight, float z) {
        if (!GuiDraw.isGuiAtlasSprite(location)) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)location);
            GuiDraw.drawTiledTexture(pose, x, y, w, h, u, v, tileWidth, tileHeight, textureWidth, textureHeight, z);
            return;
        }
        float wRatio = 1.0f / (float)textureWidth;
        float hRatio = 1.0f / (float)textureHeight;
        RectangleF newUvs = GuiDraw.setupTexture(location, (float)u * wRatio, (float)v * hRatio, ((float)u + w) * wRatio, ((float)v + h) * hRatio);
        GuiDraw.drawTiledTexture(pose, x, y, x + w, y + h, newUvs.u0(), newUvs.v0(), newUvs.u1(), newUvs.v1(), tileWidth, tileHeight, z);
    }

    public static void drawTiledTexture(Matrix4f pose, float x, float y, float w, float h, int u, int v, int tileW, int tileH, int tw, int th, float z) {
        int countX = ((int)w - 1) / tileW + 1;
        int countY = ((int)h - 1) / tileH + 1;
        float fillerX = w - (float)((countX - 1) * tileW);
        float fillerY = h - (float)((countY - 1) * tileH);
        RenderSystem.disableDepthTest();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        int c = countX * countY;
        for (int i = 0; i < c; ++i) {
            int ix = i % countX;
            int iy = i / countX;
            float xx = x + (float)(ix * tileW);
            float yy = y + (float)(iy * tileH);
            float xw = ix == countX - 1 ? fillerX : (float)tileW;
            float yh = iy == countY - 1 ? fillerY : (float)tileH;
            GuiDraw.drawTexture(pose, (VertexConsumer)buffer, xx, yy, u, v, xw, yh, tw, th, z);
        }
    }

    public static void drawTiledTexture(Matrix4f pose, ResourceLocation location, float x, float y, float w, float h, float u0, float v0, float u1, float v1, int textureWidth, int textureHeight, float z) {
        RenderSystem.enableBlend();
        RectangleF newUvs = GuiDraw.setupTexture(location, u0, v0, u1, v1);
        GuiDraw.drawTiledTexture(pose, x, y, w, h, newUvs.u0(), newUvs.v0(), newUvs.u1(), newUvs.v1(), textureWidth, textureHeight, z);
        RenderSystem.disableBlend();
    }

    public static void drawTiledTexture(Matrix4f pose, float x, float y, float w, float h, float u0, float v0, float u1, float v1, int tileWidth, int tileHeight, float z) {
        int countX = ((int)w - 1) / tileWidth + 1;
        int countY = ((int)h - 1) / tileHeight + 1;
        float fillerX = w - (float)((countX - 1) * tileWidth);
        float fillerY = h - (float)((countY - 1) * tileHeight);
        float fillerU = u0 + (u1 - u0) * fillerX / (float)tileWidth;
        float fillerV = v0 + (v1 - v0) * fillerY / (float)tileHeight;
        RenderSystem.disableDepthTest();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        int c = countX * countY;
        for (int i = 0; i < c; ++i) {
            int ix = i % countX;
            int iy = i / countX;
            float xx = x + (float)(ix * tileWidth);
            float yy = y + (float)(iy * tileHeight);
            float xw = tileWidth;
            float yh = tileHeight;
            float uEnd = u1;
            float vEnd = v1;
            if (ix == countX - 1) {
                xw = fillerX;
                uEnd = fillerU;
            }
            if (iy == countY - 1) {
                yh = fillerY;
                vEnd = fillerV;
            }
            GuiDraw.drawTexture(pose, (VertexConsumer)buffer, xx, yy, xx + xw, yy + yh, u0, v0, uEnd, vEnd, z);
        }
        tesselator.m_85914_();
    }

    public static void drawEntityRaw(GuiGraphics graphics, Entity entity) {
        EntityRenderDispatcher entityRenderer = Minecraft.m_91087_().m_91290_();
        entityRenderer.m_114468_(false);
        RenderSystem.runAsFancy(() -> entityRenderer.m_114384_(entity, 0.0, 0.0, 0.0, 0.0f, Minecraft.m_91087_().getPartialTick(), graphics.m_280168_(), (MultiBufferSource)graphics.m_280091_(), 0xF000F0));
        graphics.m_280262_();
        entityRenderer.m_114468_(true);
    }

    public static <T extends Entity> void drawEntity(GuiGraphics graphics, T entity, float x, float y, float w, float h, float z, @Nullable BiConsumer<GuiGraphics, T> preDraw, @Nullable BiConsumer<GuiGraphics, T> postDraw) {
        graphics.m_280168_().m_85836_();
        GuiDraw.setupDrawEntity(graphics, entity, x, y, w, h, z);
        if (preDraw != null) {
            preDraw.accept(graphics, (GuiGraphics)entity);
        }
        GuiDraw.drawEntityRaw(graphics, entity);
        if (postDraw != null) {
            postDraw.accept(graphics, (GuiGraphics)entity);
        }
        GuiDraw.endDrawEntity();
        graphics.m_280168_().m_85849_();
    }

    public static <T extends Entity> void drawEntityLookingAtMouse(GuiGraphics graphics, T entity, float x, float y, float w, float h, float z, int mouseX, int mouseY, @Nullable BiConsumer<GuiGraphics, T> preDraw, @Nullable BiConsumer<GuiGraphics, T> postDraw) {
        float xAngle = (float)Math.atan((x + w / 2.0f - (float)mouseX) / h);
        float yAngle = (float)Math.atan((y + h / 2.0f - (float)mouseY) / h);
        GuiDraw.drawEntityLookingAtAngle(graphics, entity, x, y, w, h, z, xAngle, yAngle, preDraw, postDraw);
    }

    public static <T extends Entity> void drawEntityLookingAtAngle(GuiGraphics graphics, T entity, float x, float y, float w, float h, float z, float xAngle, float yAngle, @Nullable BiConsumer<GuiGraphics, T> preDraw, @Nullable BiConsumer<GuiGraphics, T> postDraw) {
        graphics.m_280168_().m_85836_();
        GuiDraw.setupDrawEntity(graphics, entity, x, y, w, h, z);
        float oldYRot = entity.m_146908_();
        float oldYRotO = entity.f_19859_;
        float oldXRot = entity.m_146909_();
        float oldXRotO = entity.f_19860_;
        float oldYBodyRot = 0.0f;
        float oldYBodyRotO = 0.0f;
        float oldYHeadRotO = 0.0f;
        float oldYHeadRot = 0.0f;
        entity.f_19859_ = 180.0f + xAngle * 40.0f;
        entity.m_146922_(entity.f_19859_);
        entity.f_19860_ = -yAngle * 20.0f;
        entity.m_146926_(entity.f_19860_);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            oldYBodyRot = livingEntity.f_20883_;
            oldYBodyRotO = livingEntity.f_20884_;
            oldYHeadRotO = livingEntity.f_20886_;
            oldYHeadRot = livingEntity.f_20885_;
            livingEntity.f_20884_ = livingEntity.f_20883_ = 180.0f + xAngle * 20.0f;
            livingEntity.f_20886_ = livingEntity.f_20885_ = entity.m_146908_();
        }
        Quaternionf cameraRot = new Quaternionf().rotateX(yAngle * 20.0f * ((float)Math.PI / 180));
        graphics.m_280168_().m_252781_(cameraRot);
        cameraRot.conjugate();
        Minecraft.m_91087_().m_91290_().m_252923_(cameraRot);
        if (preDraw != null) {
            preDraw.accept(graphics, (GuiGraphics)entity);
        }
        GuiDraw.drawEntityRaw(graphics, entity);
        if (postDraw != null) {
            postDraw.accept(graphics, (GuiGraphics)entity);
        }
        entity.m_146922_(oldYRot);
        entity.f_19859_ = oldYRotO;
        entity.m_146926_(oldXRot);
        entity.f_19860_ = oldXRotO;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.f_20883_ = oldYBodyRot;
            livingEntity.f_20884_ = oldYBodyRotO;
            livingEntity.f_20886_ = oldYHeadRotO;
            livingEntity.f_20885_ = oldYHeadRot;
        }
        GuiDraw.endDrawEntity();
        graphics.m_280168_().m_85849_();
    }

    public static void setupDrawEntity(GuiGraphics graphics, Entity entity, float x, float y, float w, float h, float z) {
        float scale;
        float size;
        if (h / entity.m_20206_() < w / entity.m_20205_()) {
            size = entity.m_20206_();
            scale = h / size;
        } else {
            size = entity.m_20205_();
            scale = w / size;
        }
        graphics.m_280168_().m_252880_(x + w / 2.0f, y + h / 2.0f, z + 50.0f);
        graphics.m_280168_().m_85841_(scale, scale, -scale);
        graphics.m_280168_().m_252880_(0.0f, size / 2.0f, 0.0f);
        graphics.m_280168_().m_252781_(new Quaternionf().rotateZ((float)Math.PI));
        Lighting.m_166384_();
    }

    public static void endDrawEntity() {
        Lighting.m_84931_();
    }

    public static void drawItem(GuiGraphics graphics, ItemStack item, int x, int y, float width, float height, int z) {
        if (item.m_41619_()) {
            return;
        }
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)x, (float)y, (float)z);
        graphics.m_280168_().m_85841_(width / 16.0f, height / 16.0f, 1.0f);
        graphics.m_280480_(item, 0, 0);
        graphics.m_280370_(Minecraft.m_91087_().f_91062_, item, 0, 0);
        graphics.m_280168_().m_85849_();
    }

    public static void drawFluidTexture(GuiGraphics graphics, FluidStack content, float x0, float y0, float width, float height, float z) {
        if (content == null || content.isEmpty()) {
            return;
        }
        Fluid fluid = content.getFluid();
        ResourceLocation fluidStill = IClientFluidTypeExtensions.of((Fluid)fluid).getStillTexture(content);
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(fluidStill);
        int fluidColor = IClientFluidTypeExtensions.of((Fluid)fluid).getTintColor(content);
        graphics.m_280246_(Color.getRedF(fluidColor), Color.getGreenF(fluidColor), Color.getBlueF(fluidColor), Color.getAlphaF(fluidColor));
        RenderSystem.setShader(GameRenderer::m_172817_);
        GuiDraw.drawTiledTexture(graphics.m_280168_().m_85850_().m_252922_(), InventoryMenu.f_39692_, x0, y0, width, height, sprite.m_118409_(), sprite.m_118411_(), sprite.m_118410_(), sprite.m_118412_(), sprite.m_245424_().m_246492_(), sprite.m_245424_().m_245330_(), z);
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void drawStandardSlotAmountText(GuiContext context, int amount, String format, Area area, float z) {
        GuiDraw.drawAmountText(context.getMuiContext(), amount, format, 0, 0, area.width, area.height, Alignment.BottomRight, z);
    }

    public static void drawAmountText(ModularGuiContext context, int amount, String format, int x, int y, int width, int height, Alignment alignment, float z) {
        if (amount == 1) {
            return;
        }
        Object amountText = FormattingUtil.formatNumberReadable(amount, false);
        if (format != null) {
            amountText = format + (String)amountText;
        }
        GuiDraw.drawScaledAlignedTextInBox(context, (String)amountText, x, y, width, height, alignment, 1.0f, z);
    }

    public static void drawScaledAlignedTextInBox(ModularGuiContext context, String amountText, int x, int y, int width, int height, Alignment alignment) {
        GuiDraw.drawScaledAlignedTextInBox(context, amountText, x, y, width, height, alignment, 1.0f, 0.0f);
    }

    public static void drawScaledAlignedTextInBox(ModularGuiContext context, String amountText, int x, int y, int width, int height, Alignment alignment, float maxScale, float z) {
        if (amountText == null || amountText.isEmpty()) {
            return;
        }
        textRenderer.setShadow(true);
        textRenderer.setScale(1.0f);
        textRenderer.setColor(Color.WHITE.main);
        textRenderer.setAlignment(alignment, width, height);
        textRenderer.setPos(x, y);
        textRenderer.setHardWrapOnBorder(false);
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
        if (amountText.length() > 2 && width > 16) {
            textRenderer.setSimulate(true);
            textRenderer.draw(context.getGraphics(), amountText);
            textRenderer.setSimulate(false);
            textRenderer.setScale(Math.min(maxScale, (float)width / textRenderer.getLastWidth()));
        }
        context.graphicsPose().m_252880_(0.0f, 0.0f, 100.0f + z);
        textRenderer.draw(context.getGraphics(), amountText);
        textRenderer.setHardWrapOnBorder(true);
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
    }

    public static void drawSprite(Matrix4f pose, TextureAtlasSprite sprite, float x0, float y0, float w, float h) {
        RenderSystem.enableBlend();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.m_247685_());
        GuiDraw.drawTexture(pose, x0, y0, x0 + w, y0 + h, sprite.m_118409_(), sprite.m_118411_(), sprite.m_118410_(), sprite.m_118412_());
        RenderSystem.disableBlend();
    }

    public static void drawTiledSprite(Matrix4f pose, TextureAtlasSprite sprite, float x0, float y0, float w, float h) {
        RenderSystem.enableBlend();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.m_247685_());
        GuiDraw.drawTiledTexture(pose, sprite.m_247685_(), x0, y0, x0 + w, y0 + h, sprite.m_118409_(), sprite.m_118411_(), sprite.m_118410_(), sprite.m_118412_(), sprite.m_245424_().m_246492_(), sprite.m_245424_().m_245330_(), 0.0f);
        RenderSystem.disableBlend();
    }

    public static void drawOutlineCenter(GuiGraphics graphics, int x, int y, int offset, int color) {
        GuiDraw.drawOutlineCenter(graphics, x, y, offset, color, 1);
    }

    public static void drawOutlineCenter(GuiGraphics graphics, int x, int y, int offset, int color, int border) {
        GuiDraw.drawOutline(graphics, x - offset, y - offset, x + offset, y + offset, color, border);
    }

    public static void drawOutline(GuiGraphics graphics, int left, int top, int right, int bottom, int color) {
        GuiDraw.drawOutline(graphics, left, top, right, bottom, color, 1);
    }

    public static void drawOutline(GuiGraphics graphics, int left, int top, int right, int bottom, int color, int border) {
        graphics.m_280509_(left, top, left + border, bottom, color);
        graphics.m_280509_(right - border, top, right, bottom, color);
        graphics.m_280509_(left + border, top, right - border, top + border, color);
        graphics.m_280509_(left + border, bottom - border, right - border, bottom, color);
    }

    private static void drawBorderLTRB(GuiGraphics graphics, float left, float top, float right, float bottom, float border, int color, boolean outside) {
        if (outside) {
            left -= border;
            top -= border;
            right += border;
            bottom += border;
        }
        float x0 = left;
        float y0 = top;
        float x1 = right;
        float y1 = bottom;
        float d = border;
        VertexConsumer buffer = graphics.m_280091_().m_6299_(GTRenderTypes.guiTriangleStrip());
        Matrix4f pose = graphics.m_280168_().m_85850_().m_252922_();
        GuiDraw.pc(buffer, pose, x0, y0, color);
        GuiDraw.pc(buffer, pose, x1 - d, y0 + d, color);
        GuiDraw.pc(buffer, pose, x1, y0, color);
        GuiDraw.pc(buffer, pose, x1 - d, y1 - d, color);
        GuiDraw.pc(buffer, pose, x1, y1, color);
        GuiDraw.pc(buffer, pose, x0 + d, y1 - d, color);
        GuiDraw.pc(buffer, pose, x0, y1, color);
        GuiDraw.pc(buffer, pose, x0 + d, y0 + d, color);
        GuiDraw.pc(buffer, pose, x0, y0, color);
        GuiDraw.pc(buffer, pose, x1 - d, y0 + d, color);
    }

    public static void drawBorderOutsideLTRB(GuiGraphics graphics, float left, float top, float right, float bottom, int color) {
        GuiDraw.drawBorderLTRB(graphics, left, top, right, bottom, 1.0f, color, true);
    }

    public static void drawBorderOutsideLTRB(GuiGraphics graphics, float left, float top, float right, float bottom, float border, int color) {
        GuiDraw.drawBorderLTRB(graphics, left, top, right, bottom, border, color, true);
    }

    public static void drawBorderInsideLTRB(GuiGraphics graphics, float left, float top, float right, float bottom, int color) {
        GuiDraw.drawBorderLTRB(graphics, left, top, right, bottom, 1.0f, color, false);
    }

    public static void drawBorderInsideLTRB(GuiGraphics graphics, float left, float top, float right, float bottom, float border, int color) {
        GuiDraw.drawBorderLTRB(graphics, left, top, right, bottom, border, color, false);
    }

    private static void drawBorderXYWH(GuiGraphics graphics, float x, float y, float w, float h, float border, int color, boolean outside) {
        GuiDraw.drawBorderLTRB(graphics, x, y, x + w, y + h, border, color, outside);
    }

    public static void drawBorderOutsideXYWH(GuiGraphics graphics, float x, float y, float w, float h, float border, int color) {
        GuiDraw.drawBorderXYWH(graphics, x, y, w, h, border, color, true);
    }

    public static void drawBorderOutsideXYWH(GuiGraphics graphics, float x, float y, float w, float h, int color) {
        GuiDraw.drawBorderXYWH(graphics, x, y, w, h, 1.0f, color, true);
    }

    public static void drawBorderInsideXYWH(GuiGraphics graphics, float x, float y, float w, float h, float border, int color) {
        GuiDraw.drawBorderXYWH(graphics, x, y, w, h, border, color, false);
    }

    public static void drawBorderInsideXYWH(GuiGraphics graphics, float x, float y, float w, float h, int color) {
        GuiDraw.drawBorderXYWH(graphics, x, y, w, h, 1.0f, color, false);
    }

    private static void pc(VertexConsumer buffer, Matrix4f pose, float x, float y, int c) {
        buffer.m_252986_(pose, x, y, 0.0f).m_6122_(Color.getRed(c), Color.getGreen(c), Color.getBlue(c), Color.getAlpha(c)).m_5752_();
    }

    public static void drawDropShadow(Matrix4f pose, int x, int y, int w, int h, int oX, int oY, int opaque, int shadow) {
        float a1 = Color.getAlphaF(opaque);
        float r1 = Color.getRedF(opaque);
        float g1 = Color.getGreenF(opaque);
        float b1 = Color.getBlueF(opaque);
        float a2 = Color.getAlphaF(shadow);
        float r2 = Color.getRedF(shadow);
        float g2 = Color.getGreenF(shadow);
        float b2 = Color.getBlueF(shadow);
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        float x1 = x + w;
        float y1 = y + h;
        buffer.m_252986_(pose, x1, (float)y, 0.0f).m_85950_(r1, g1, b1, a1).m_5752_();
        buffer.m_252986_(pose, (float)x, (float)y, 0.0f).m_85950_(r1, g1, b1, a1).m_5752_();
        buffer.m_252986_(pose, (float)x, y1, 0.0f).m_85950_(r1, g1, b1, a1).m_5752_();
        buffer.m_252986_(pose, x1, y1, 0.0f).m_85950_(r1, g1, b1, a1).m_5752_();
        buffer.m_252986_(pose, x1 + (float)oX, (float)(y - oY), 0.0f).m_85950_(r2, g2, b2, a2).m_5752_();
        buffer.m_252986_(pose, (float)(x - oX), (float)(y - oY), 0.0f).m_85950_(r2, g2, b2, a2).m_5752_();
        buffer.m_252986_(pose, (float)x, (float)y, 0.0f).m_85950_(r1, g1, b1, a1).m_5752_();
        buffer.m_252986_(pose, x1, (float)y, 0.0f).m_85950_(r1, g1, b1, a1).m_5752_();
        buffer.m_252986_(pose, x1, y1, 0.0f).m_85950_(r1, g1, b1, a1).m_5752_();
        buffer.m_252986_(pose, (float)x, y1, 0.0f).m_85950_(r1, g1, b1, a1).m_5752_();
        buffer.m_252986_(pose, (float)(x - oX), y1 + (float)oY, 0.0f).m_85950_(r2, g2, b2, a2).m_5752_();
        buffer.m_252986_(pose, x1 + (float)oX, y1 + (float)oY, 0.0f).m_85950_(r2, g2, b2, a2).m_5752_();
        buffer.m_252986_(pose, (float)x, (float)y, 0.0f).m_85950_(r1, g1, b1, a1).m_5752_();
        buffer.m_252986_(pose, (float)(x - oX), (float)(y - oY), 0.0f).m_85950_(r2, g2, b2, a2).m_5752_();
        buffer.m_252986_(pose, (float)(x - oX), y1 + (float)oY, 0.0f).m_85950_(r2, g2, b2, a2).m_5752_();
        buffer.m_252986_(pose, (float)x, y1, 0.0f).m_85950_(r1, g1, b1, a1).m_5752_();
        buffer.m_252986_(pose, x1 + (float)oX, (float)(y - oY), 0.0f).m_85950_(r2, g2, b2, a2).m_5752_();
        buffer.m_252986_(pose, x1, (float)y, 0.0f).m_85950_(r1, g1, b1, a1).m_5752_();
        buffer.m_252986_(pose, x1, y1, 0.0f).m_85950_(r1, g1, b1, a1).m_5752_();
        buffer.m_252986_(pose, x1 + (float)oX, y1 + (float)oY, 0.0f).m_85950_(r2, g2, b2, a2).m_5752_();
        tesselator.m_85914_();
        RenderSystem.disableBlend();
    }

    public static void drawDropCircleShadow(GuiGraphics graphics, int x, int y, int radius, int segments, int opaque, int shadow) {
        Matrix4f pose = graphics.m_280168_().m_85850_().m_252922_();
        Matrix4d poseD = new Matrix4d((Matrix4fc)pose);
        float a1 = Color.getAlphaF(opaque);
        float r1 = Color.getRedF(opaque);
        float g1 = Color.getGreenF(opaque);
        float b1 = Color.getBlueF(opaque);
        float a2 = Color.getAlphaF(shadow);
        float r2 = Color.getRedF(shadow);
        float g2 = Color.getGreenF(shadow);
        float b2 = Color.getBlueF(shadow);
        VertexConsumer buffer = graphics.m_280091_().m_6299_(GTRenderTypes.guiOverlayTriangleFan());
        buffer.m_252986_(pose, (float)x, (float)y, 0.0f).m_85950_(r1, g1, b1, a1).m_5752_();
        Vector3d pos = new Vector3d();
        for (int i = 0; i <= segments; ++i) {
            float a = (float)i / (float)segments * ((float)Math.PI * 2) - 1.5707964f;
            GuiDraw.circleVertex(buffer, poseD, pos, x, Mth.m_14089_((float)a), y, Mth.m_14031_((float)a), radius).m_85950_(r2, g2, b2, a2).m_5752_();
        }
    }

    public static void drawDropCircleShadow(GuiGraphics graphics, int x, int y, int radius, int offset, int segments, int opaque, int shadow) {
        int i;
        if (offset >= radius) {
            GuiDraw.drawDropCircleShadow(graphics, x, y, radius, segments, opaque, shadow);
            return;
        }
        Matrix4f pose = graphics.m_280168_().m_85850_().m_252922_();
        Matrix4d poseD = new Matrix4d((Matrix4fc)pose);
        float a1 = Color.getAlphaF(opaque);
        float r1 = Color.getRedF(opaque);
        float g1 = Color.getGreenF(opaque);
        float b1 = Color.getBlueF(opaque);
        float a2 = Color.getAlphaF(shadow);
        float r2 = Color.getRedF(shadow);
        float g2 = Color.getGreenF(shadow);
        float b2 = Color.getBlueF(shadow);
        VertexConsumer buffer = graphics.m_280091_().m_6299_(GTRenderTypes.guiOverlayTriangleFan());
        buffer.m_252986_(pose, (float)x, (float)y, 0.0f).m_85950_(r1, g1, b1, a1).m_5752_();
        Vector3d pos = new Vector3d();
        for (i = 0; i <= segments; ++i) {
            float a = (float)i / (float)segments * ((float)Math.PI * 2) - 1.5707964f;
            GuiDraw.circleVertex(buffer, poseD, pos, x, Mth.m_14089_((float)a), y, Mth.m_14031_((float)a), offset).m_85950_(r1, g1, b1, a1).m_5752_();
        }
        buffer = graphics.m_280091_().m_6299_(RenderType.m_285907_());
        for (i = 0; i < segments; ++i) {
            float alpha1 = (float)i / (float)segments * ((float)Math.PI * 2) - 1.5707964f;
            float alpha2 = (float)(i + 1) / (float)segments * ((float)Math.PI * 2) - 1.5707964f;
            float cosA1 = Mth.m_14089_((float)alpha1);
            float cosA2 = Mth.m_14089_((float)alpha2);
            float sinA1 = Mth.m_14031_((float)alpha1);
            float sinA2 = Mth.m_14031_((float)alpha2);
            GuiDraw.circleVertex(buffer, poseD, pos, x, cosA2, y, sinA2, offset).m_85950_(r1, g1, b1, a1).m_5752_();
            GuiDraw.circleVertex(buffer, poseD, pos, x, cosA1, y, sinA1, offset).m_85950_(r1, g1, b1, a1).m_5752_();
            GuiDraw.circleVertex(buffer, poseD, pos, x, cosA1, y, sinA1, radius).m_85950_(r2, g2, b2, a2).m_5752_();
            GuiDraw.circleVertex(buffer, poseD, pos, x, cosA2, y, sinA2, radius).m_85950_(r2, g2, b2, a2).m_5752_();
        }
    }

    private static VertexConsumer circleVertex(VertexConsumer buffer, Matrix4d pose, Vector3d pos, float x, float xOffset, float y, float yOffset, float mul) {
        pos.x = x - xOffset * mul;
        pos.y = y + yOffset * mul;
        pose.transformPosition(pos);
        return buffer.m_5483_(pos.x, pos.y, pos.z);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawBorder(GuiGraphics graphics, float x, float y, float width, float height, int color, float border) {
        GuiDraw.drawBorderLTRB(graphics, x, y, x + width, y + height, border, color, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawText(GuiGraphics graphics, String text, float x, float y, float scale, int color, boolean shadow) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85841_(scale, scale, 0.0f);
        float sf = 1.0f / scale;
        graphics.drawString(Minecraft.m_91087_().f_91062_, text, x * sf, y * sf, color, shadow);
        graphics.m_280168_().m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawText(GuiGraphics graphics, Component text, float x, float y, float scale, int color, boolean shadow) {
        GuiDraw.drawText(graphics, text.m_7532_(), x, y, scale, color, shadow);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawText(GuiGraphics graphics, FormattedCharSequence text, float x, float y, float scale, int color, boolean shadow) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85841_(scale, scale, 0.0f);
        float sf = 1.0f / scale;
        graphics.drawString(Minecraft.m_91087_().f_91062_, text, x * sf, y * sf, color, shadow);
        graphics.m_280168_().m_85849_();
    }

    public static void drawTooltipBackground(GuiContext context, ItemStack stack, List<ClientTooltipComponent> lines, int x, int y, int textWidth, int height, @Nullable RichTooltip tooltip) {
        int backgroundTop;
        GuiGraphics graphics = context.getGraphics();
        int backgroundBottom = backgroundTop = -267386864;
        int borderColorStart = 0x505000FF;
        int borderColorEnd = (borderColorStart & 0xFEFEFE) >> 1 | borderColorStart & 0xFF000000;
        RenderTooltipEvent.Color colorEvent = tooltip != null ? new RichTooltipEvent.Color(stack, graphics, x, y, context.getFont(), backgroundTop, borderColorStart, borderColorEnd, lines, tooltip) : new RenderTooltipEvent.Color(stack, graphics, x, y, context.getFont(), backgroundTop, borderColorStart, borderColorEnd, lines);
        MinecraftForge.EVENT_BUS.post((Event)colorEvent);
        backgroundTop = colorEvent.getBackgroundStart();
        backgroundBottom = colorEvent.getBackgroundEnd();
        borderColorStart = colorEvent.getBorderStart();
        borderColorEnd = colorEvent.getBorderEnd();
        GuiDraw.drawVerticalGradientRect(graphics, x - 3, y - 4, textWidth + 6, 1.0f, backgroundTop, backgroundTop);
        GuiDraw.drawVerticalGradientRect(graphics, x - 3, y + height + 3, textWidth + 6, 1.0f, backgroundBottom, backgroundBottom);
        GuiDraw.drawVerticalGradientRect(graphics, x - 3, y - 3, textWidth + 6, height + 6, backgroundTop, backgroundBottom);
        GuiDraw.drawVerticalGradientRect(graphics, x - 4, y - 3, 1.0f, height + 6, backgroundTop, backgroundBottom);
        GuiDraw.drawVerticalGradientRect(graphics, x + textWidth + 3, y - 3, 1.0f, height + 6, backgroundTop, backgroundBottom);
        GuiDraw.drawVerticalGradientRect(graphics, x - 3, y - 2, 1.0f, height + 4, borderColorStart, borderColorEnd);
        GuiDraw.drawVerticalGradientRect(graphics, x + textWidth + 2, y - 2, 1.0f, height + 4, borderColorStart, borderColorEnd);
        GuiDraw.drawVerticalGradientRect(graphics, x - 3, y - 3, textWidth + 6, 1.0f, borderColorStart, borderColorStart);
        GuiDraw.drawVerticalGradientRect(graphics, x - 3, y + height + 2, textWidth + 6, 1.0f, borderColorEnd, borderColorEnd);
    }
}

