/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.drawable;

import brachy.modularui.api.drawable.IDrawable;
import brachy.modularui.drawable.GuiDraw;
import brachy.modularui.screen.viewport.GuiContext;
import brachy.modularui.theme.WidgetTheme;
import java.util.function.BiConsumer;
import lombok.Generated;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityDrawable<T extends Entity>
implements IDrawable {
    protected final T entity;
    @Nullable
    protected BiConsumer<GuiGraphics, T> preDraw;
    @Nullable
    protected BiConsumer<GuiGraphics, T> postDraw;
    private boolean followMouse;
    private float lookTargetX = 0.0f;
    private float lookTargetY = 0.0f;

    public EntityDrawable(T entity) {
        this(entity, null, null);
    }

    public EntityDrawable(T entity, @Nullable BiConsumer<GuiGraphics, T> preDraw, @Nullable BiConsumer<GuiGraphics, T> postDraw) {
        this.entity = entity;
        this.preDraw = preDraw;
        this.postDraw = postDraw;
    }

    public EntityDrawable<T> followMouse() {
        return this.followMouse(true);
    }

    public EntityDrawable<T> lookTowardAngle(float xAngle, float yAngle) {
        this.followMouse = false;
        this.lookTargetX = xAngle;
        this.lookTargetY = yAngle;
        return this;
    }

    @Override
    public void draw(GuiContext context, int x, int y, int width, int height, WidgetTheme widgetTheme) {
        if (this.followMouse) {
            GuiDraw.drawEntityLookingAtMouse(context.getGraphics(), this.entity, x, y, width, height, context.getCurrentDrawingZ(), context.getMouseX(), context.getMouseY(), this.preDraw, this.postDraw);
        } else {
            GuiDraw.drawEntityLookingAtAngle(context.getGraphics(), this.entity, x, y, width, height, context.getCurrentDrawingZ(), this.lookTargetX, this.lookTargetY, this.preDraw, this.postDraw);
        }
    }

    @Generated
    public T entity() {
        return this.entity;
    }

    @NotNull
    @Generated
    public EntityDrawable<T> preDraw(@Nullable BiConsumer<GuiGraphics, T> preDraw) {
        this.preDraw = preDraw;
        return this;
    }

    @NotNull
    @Generated
    public EntityDrawable<T> postDraw(@Nullable BiConsumer<GuiGraphics, T> postDraw) {
        this.postDraw = postDraw;
        return this;
    }

    @NotNull
    @Generated
    public EntityDrawable<T> followMouse(boolean followMouse) {
        this.followMouse = followMouse;
        return this;
    }
}

