/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.drawable;

import brachy.modularui.animation.IAnimatable;
import brachy.modularui.api.IJsonSerializable;
import brachy.modularui.api.drawable.IDrawable;
import brachy.modularui.drawable.GuiDraw;
import brachy.modularui.screen.viewport.GuiContext;
import brachy.modularui.theme.WidgetTheme;
import brachy.modularui.utils.Color;
import brachy.modularui.utils.Interpolations;
import brachy.modularui.utils.serialization.json.JsonHelper;
import com.google.gson.JsonObject;
import lombok.Generated;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class Circle
implements IDrawable,
IJsonSerializable<Circle>,
IAnimatable<Circle> {
    private int colorInner = 0;
    private int colorOuter = 0;
    private int segments = 40;

    public Circle setColorInner(int colorInner) {
        return this.colorInner(colorInner);
    }

    public Circle setColorOuter(int colorOuter) {
        return this.colorOuter(colorOuter);
    }

    public Circle setColor(int inner, int outer) {
        return this.color(inner, outer);
    }

    public Circle setSegments(int segments) {
        return this.segments(segments);
    }

    public Circle color(int inner, int outer) {
        this.colorInner = inner;
        this.colorOuter = outer;
        return this;
    }

    public Circle color(int color) {
        return this.color(color, color);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(GuiContext context, int x0, int y0, int width, int height, WidgetTheme widgetTheme) {
        this.applyColor(widgetTheme.getColor());
        GuiDraw.drawEllipse(context.getGraphics(), x0, y0, width, height, this.colorInner, this.colorOuter, this.segments);
    }

    @Override
    public void loadFromJson(JsonObject json) {
        this.colorInner = JsonHelper.getColor(json, Color.WHITE.main, "colorInner", "color");
        this.colorOuter = JsonHelper.getColor(json, Color.WHITE.main, "colorOuter", "color");
        this.segments = JsonHelper.getInt(json, 40, "segments");
    }

    @Override
    public boolean saveToJson(JsonObject json) {
        json.addProperty("colorInner", (Number)this.colorInner);
        json.addProperty("colorOuter", (Number)this.colorOuter);
        json.addProperty("segments", (Number)this.segments);
        return true;
    }

    @Override
    public Circle interpolate(Circle start, Circle end, float t) {
        this.colorInner = Color.lerp(start.colorInner, end.colorInner, t);
        this.colorOuter = Color.lerp(start.colorOuter, end.colorOuter, t);
        this.segments = Interpolations.lerp(start.segments, end.segments, t);
        return this;
    }

    @Override
    public Circle copyOrImmutable() {
        return new Circle().setColor(this.colorInner, this.colorOuter).setSegments(this.segments);
    }

    @NotNull
    @Generated
    public Circle colorInner(int colorInner) {
        this.colorInner = colorInner;
        return this;
    }

    @NotNull
    @Generated
    public Circle colorOuter(int colorOuter) {
        this.colorOuter = colorOuter;
        return this;
    }

    @NotNull
    @Generated
    public Circle segments(int segments) {
        this.segments = segments;
        return this;
    }
}

