/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.client.schemarenderer;

import brachy.modularui.schema.ISchema;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelTimeAccess;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class RenderLevel
implements LevelTimeAccess {
    private final ISchema schema;
    private final Level level;
    private final Thread thread;

    public RenderLevel(ISchema schema) {
        this.schema = schema;
        this.level = schema.getLevel();
        this.thread = Thread.currentThread();
    }

    @Nullable
    public BlockEntity m_7702_(BlockPos pos) {
        BlockState state = this.level.m_8055_(pos);
        if (!this.schema.getRenderFilter().test(pos, state)) {
            return null;
        }
        if (Thread.currentThread() != this.thread) {
            int chunkZ;
            int chunkX = SectionPos.m_123171_((int)pos.m_123341_());
            BlockGetter chunk = this.level.m_7925_(chunkX, chunkZ = SectionPos.m_123171_((int)pos.m_123343_()));
            if (chunk == null) {
                return null;
            }
            return chunk.m_7702_(pos);
        }
        return this.level.m_7702_(pos);
    }

    public BlockState m_8055_(BlockPos pos) {
        BlockState state = this.level.m_8055_(pos);
        if (!this.schema.getRenderFilter().test(pos, state)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    public FluidState m_6425_(BlockPos pos) {
        BlockState state = this.level.m_8055_(pos);
        if (!this.schema.getRenderFilter().test(pos, state)) {
            return Fluids.f_76191_.m_76145_();
        }
        return this.level.m_6425_(pos);
    }

    @Nullable
    public ChunkAccess m_6522_(int x, int z, ChunkStatus requiredStatus, boolean nonnull) {
        return this.level.m_6522_(x, z, requiredStatus, nonnull);
    }

    public boolean m_7232_(int chunkX, int chunkZ) {
        return this.level.m_7232_(chunkX, chunkZ);
    }

    public int m_6924_(Heightmap.Types heightmapType, int x, int z) {
        return this.level.m_6924_(heightmapType, x, z);
    }

    public int m_7445_() {
        return this.level.m_7445_();
    }

    public BiomeManager m_7062_() {
        return this.level.m_7062_();
    }

    public Holder<Biome> m_203675_(int x, int y, int z) {
        return this.level.m_203675_(x, y, z);
    }

    public boolean m_5776_() {
        return this.level.m_5776_();
    }

    public int m_5736_() {
        return this.level.m_5736_();
    }

    public DimensionType m_6042_() {
        return this.level.m_6042_();
    }

    public RegistryAccess m_9598_() {
        return this.level.m_9598_();
    }

    public FeatureFlagSet m_246046_() {
        return this.level.m_246046_();
    }

    public float m_7717_(Direction direction, boolean shade) {
        return this.level.m_7717_(direction, shade);
    }

    public LevelLightEngine m_5518_() {
        return this.level.m_5518_();
    }

    public WorldBorder m_6857_() {
        return this.level.m_6857_();
    }

    public List<VoxelShape> m_183134_(@Nullable Entity entity, AABB collisionBox) {
        return this.level.m_183134_(entity, collisionBox);
    }

    public long m_8044_() {
        return this.level.m_8044_();
    }
}

