/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.client.schemarenderer;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelTimeAccess;
import net.minecraft.world.level.dimension.DimensionType;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class DummyLightTexture
implements AutoCloseable {
    private static final Vector3fc THREE_FOURTHS = new Vector3f(0.75f, 0.75f, 0.75f);
    private final DynamicTexture lightmapTexture = new DynamicTexture(16, 16, false);
    private final NativeImage lightmapPixels = Objects.requireNonNull(this.lightmapTexture.m_117991_());

    public DummyLightTexture() {
        this.lightmapPixels.m_84997_(0, 0, 16, 16, -1);
        this.lightmapTexture.m_117985_();
    }

    public static float getSkyDarken(LevelTimeAccess level, float partialTick) {
        float f = level.m_46942_(partialTick);
        float g = 1.0f - (Mth.m_14089_((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.2f);
        g = Mth.m_14036_((float)g, (float)0.0f, (float)1.0f);
        g = 1.0f - g;
        return 0.2f + g * 0.8f;
    }

    public void update(LevelTimeAccess level) {
        float skyDarkness = DummyLightTexture.getSkyDarken(level, 1.0f);
        float partDarken = Mth.m_14179_((float)0.35f, (float)skyDarkness, (float)1.0f);
        float skyBrightMul = skyDarkness * 0.95f + 0.05f;
        float blockBrightMul = 1.5f;
        float gamma = ((Double)Minecraft.m_91087_().f_91066_.m_231927_().m_231551_()).floatValue();
        Vector3f color = new Vector3f();
        for (int skyLightLvl = 0; skyLightLvl <= 15; ++skyLightLvl) {
            for (int blockLightLvl = 0; blockLightLvl <= 15; ++blockLightLvl) {
                float skyLuma = LightTexture.m_234316_((DimensionType)level.m_6042_(), (int)skyLightLvl) * skyBrightMul;
                float blockLuma = LightTexture.m_234316_((DimensionType)level.m_6042_(), (int)blockLightLvl) * blockBrightMul;
                color.set(blockLuma, blockLuma * this.rescale(this.rescale(blockLuma)), blockLuma * blockLuma * this.rescale(blockLuma));
                Vector3f skyColor = new Vector3f(partDarken, partDarken, 1.0f).mul(skyLuma);
                color.add((Vector3fc)skyColor);
                color.lerp(THREE_FOURTHS, 0.04f);
                Vector3f noGammaColor = new Vector3f(this.notGamma(color.x), this.notGamma(color.y), this.notGamma(color.z));
                color.lerp((Vector3fc)noGammaColor, Math.max(0.0f, gamma));
                color.lerp(THREE_FOURTHS, 0.04f);
                DummyLightTexture.clampColor(color);
                color.mul(255.0f);
                int r = (int)color.x();
                int g = (int)color.y();
                int b = (int)color.z();
                this.lightmapPixels.m_84988_(blockLightLvl, skyLightLvl, 0xFF000000 | b << 16 | g << 8 | r);
            }
        }
        this.lightmapTexture.m_117985_();
    }

    private static void clampColor(Vector3f color) {
        color.set(Mth.m_14036_((float)color.x, (float)0.0f, (float)1.0f), Mth.m_14036_((float)color.y, (float)0.0f, (float)1.0f), Mth.m_14036_((float)color.z, (float)0.0f, (float)1.0f));
    }

    private float notGamma(float value) {
        float f = 1.0f - value;
        return 1.0f - f * f * f * f;
    }

    private float rescale(float value) {
        return value * 0.6f + 0.4f;
    }

    public void bind() {
        RenderSystem.setShaderTexture((int)2, (int)this.lightmapTexture.m_117963_());
        this.lightmapTexture.m_117966_();
        RenderSystem.texParameter((int)3553, (int)10241, (int)9729);
        RenderSystem.texParameter((int)3553, (int)10240, (int)9729);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void close() {
        this.lightmapTexture.close();
    }
}

