/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.api.widget;

import brachy.modularui.api.ITheme;
import brachy.modularui.api.ITreeNode;
import brachy.modularui.api.layout.IViewportStack;
import brachy.modularui.api.widget.IGuiElement;
import brachy.modularui.screen.ModularPanel;
import brachy.modularui.screen.ModularScreen;
import brachy.modularui.screen.viewport.ModularGuiContext;
import brachy.modularui.theme.WidgetThemeEntry;
import brachy.modularui.utils.FormattingUtil;
import brachy.modularui.utils.Stencil;
import brachy.modularui.widget.sizer.Area;
import brachy.modularui.widget.sizer.StandardResizer;
import com.google.common.base.CharMatcher;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IWidget
extends IGuiElement,
ITreeNode<IWidget> {
    public static final String WIDGET_TRANSLATION_KEY_FORMAT = "widget.%s.name";
    public static final CharMatcher DISALLOWED_TRANSLATION_KEY_CHARS = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'0', (char)'9')).or(CharMatcher.anyOf((CharSequence)"-_.")).negate();

    default public String getTranslationId() {
        String className = FormattingUtil.toLowerCaseUnderscore(this.getClass().getSimpleName());
        className = DISALLOWED_TRANSLATION_KEY_CHARS.removeFrom((CharSequence)className);
        return WIDGET_TRANSLATION_KEY_FORMAT.formatted(className);
    }

    @Override
    public ModularScreen getScreen();

    @Override
    @NotNull
    public IWidget getParent();

    @Override
    default public boolean hasParent() {
        return this.isValid();
    }

    public ModularGuiContext getContext();

    @NotNull
    public ModularPanel getPanel();

    @Override
    public Area getArea();

    @Override
    default public Area getParentArea() {
        return this.getParent().getArea();
    }

    default public boolean isInside(IViewportStack stack, int mx, int my) {
        return this.isInside(stack, mx, my, true);
    }

    default public boolean isInside(IViewportStack stack, int mx, int my, boolean absolute) {
        int x = mx;
        int y = my;
        if (absolute) {
            x = stack.unTransformX(mx, my);
            y = stack.unTransformY(mx, my);
        }
        return x >= 0 && x < this.getArea().w() && y >= 0 && y < this.getArea().h();
    }

    @Override
    default public void onMouseStartHover() {
    }

    @Override
    default public void onMouseEndHover() {
    }

    @Override
    default public void onMouseEnterArea() {
    }

    @Override
    default public void onMouseLeaveArea() {
    }

    @Override
    default public boolean isHovering() {
        return this.isHoveringFor(0);
    }

    @Override
    default public boolean isHoveringFor(int ticks) {
        return false;
    }

    @Override
    default public boolean isBelowMouse() {
        return this.isBelowMouseFor(0);
    }

    @Override
    default public boolean isBelowMouseFor(int ticks) {
        return false;
    }

    default public boolean canBeSeen(IViewportStack stack) {
        return Stencil.isInsideScissorArea(this.getArea(), stack);
    }

    default public boolean canHover() {
        return true;
    }

    default public boolean canClickThrough() {
        return true;
    }

    default public boolean canHoverThrough() {
        return false;
    }

    @Override
    default public int getDefaultWidth() {
        return 18;
    }

    @Override
    default public int getDefaultHeight() {
        return 18;
    }

    public void initialise(@NotNull IWidget var1, boolean var2);

    public void dispose();

    public boolean isValid();

    default public void onUpdate() {
    }

    default public void drawBackground(ModularGuiContext context, WidgetThemeEntry<?> widgetTheme) {
    }

    default public void draw(ModularGuiContext context, WidgetThemeEntry<?> widgetTheme) {
    }

    default public void drawOverlay(ModularGuiContext context, WidgetThemeEntry<?> widgetTheme) {
    }

    default public void drawForeground(ModularGuiContext context) {
    }

    default public void transform(IViewportStack stack) {
        stack.translate(this.getArea().rx, this.getArea().ry, 0.0f);
    }

    default public Object getAdditionalHoverInfo(IViewportStack viewportStack, int mouseX, int mouseY) {
        return null;
    }

    default public WidgetThemeEntry<?> getWidgetTheme(ITheme theme) {
        return theme.getFallback();
    }

    @Override
    @NotNull
    default public List<IWidget> getChildren() {
        return Collections.emptyList();
    }

    @Override
    default public boolean hasChildren() {
        return !this.getChildren().isEmpty();
    }

    @Override
    public void scheduleResize();

    @Override
    public boolean requiresResize();

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.2.0")
    @Nullable
    default public StandardResizer getFlex() {
        return this.resizer();
    }

    @Deprecated
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion="3.2.0")
    default public StandardResizer flex() {
        return this.resizer();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.2.0")
    default public IWidget flexBuilder(Consumer<StandardResizer> builder) {
        return this.resizerBuilder(builder);
    }

    @Override
    @NotNull
    public StandardResizer resizer();

    default public IWidget resizerBuilder(Consumer<StandardResizer> builder) {
        builder.accept(this.resizer());
        return this;
    }

    default public void beforeResize(boolean onOpen) {
    }

    default public void onResized() {
    }

    default public void postResize() {
    }

    @Override
    public boolean isEnabled();

    public void setEnabled(boolean var1);

    default public boolean areAncestorsEnabled() {
        IWidget parent = this;
        do {
            if (parent.isEnabled()) continue;
            return false;
        } while ((parent = parent.getParent()).hasParent());
        return true;
    }

    @Nullable
    public String getName();

    default public boolean isName(String name) {
        return name.equals(this.getName());
    }

    default public boolean isType(Class<? extends IWidget> type) {
        return type.isAssignableFrom(this.getClass());
    }

    default public boolean isNameAndType(String name, Class<? extends IWidget> type) {
        return this.isName(name) && this.isType(type);
    }
}

