/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.api.widget;

import brachy.modularui.api.widget.IGuiElement;
import brachy.modularui.api.widget.IWidget;
import brachy.modularui.utils.Alignment;
import brachy.modularui.widget.sizer.Area;
import brachy.modularui.widget.sizer.AreaResizer;
import brachy.modularui.widget.sizer.ResizeNode;
import brachy.modularui.widget.sizer.StandardResizer;
import brachy.modularui.widget.sizer.Unit;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import org.jetbrains.annotations.ApiStatus;

public interface IPositioned<W extends IPositioned<W>> {
    public StandardResizer resizer();

    public Area getArea();

    public void scheduleResize();

    public boolean requiresResize();

    default public W getThis() {
        return (W)this;
    }

    default public W coverChildrenWidth() {
        this.resizer().coverChildrenWidth();
        return this.getThis();
    }

    default public W coverChildrenHeight() {
        this.resizer().coverChildrenHeight();
        return this.getThis();
    }

    default public W coverChildren() {
        return this.coverChildrenWidth().coverChildrenHeight();
    }

    default public W expanded() {
        this.resizer().expanded();
        return this.getThis();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.2.0")
    default public W relative(IGuiElement guiElement) {
        return this.relative(guiElement.getArea());
    }

    @Deprecated
    default public W relative(Area area) {
        return this.relative(new AreaResizer(area));
    }

    default public W relative(ResizeNode resizeNode) {
        this.resizer().relative(resizeNode);
        return this.getThis();
    }

    default public W relative(IWidget widget) {
        return this.relative(widget.resizer());
    }

    default public W relativeToScreen() {
        this.resizer().relativeToScreen();
        return this.getThis();
    }

    default public W relativeToParent() {
        this.resizer().relativeToParent();
        return this.getThis();
    }

    default public W left(int val) {
        this.resizer().left(val, 0, 0.0f, Unit.Measure.PIXEL, true);
        return this.getThis();
    }

    default public W leftRel(float val) {
        this.resizer().left(val, 0, 0.0f, Unit.Measure.RELATIVE, true);
        return this.getThis();
    }

    default public W leftRelOffset(float val, int offset) {
        this.resizer().left(val, offset, 0.0f, Unit.Measure.RELATIVE, true);
        return this.getThis();
    }

    default public W leftRelAnchor(float val, float anchor) {
        this.resizer().left(val, 0, anchor, Unit.Measure.RELATIVE, false);
        return this.getThis();
    }

    default public W leftRel(float val, int offset, float anchor) {
        this.resizer().left(val, offset, anchor, Unit.Measure.RELATIVE, false);
        return this.getThis();
    }

    default public W left(float val, int offset, float anchor, Unit.Measure measure) {
        this.resizer().left(val, offset, anchor, measure, false);
        return this.getThis();
    }

    default public W left(DoubleSupplier val, Unit.Measure measure) {
        this.resizer().left(val, 0, 0.0f, measure, true);
        return this.getThis();
    }

    default public W leftRelOffset(DoubleSupplier val, int offset) {
        this.resizer().left(val, offset, 0.0f, Unit.Measure.RELATIVE, true);
        return this.getThis();
    }

    default public W leftRelAnchor(DoubleSupplier val, float anchor) {
        this.resizer().left(val, 0, anchor, Unit.Measure.RELATIVE, false);
        return this.getThis();
    }

    default public W leftRel(DoubleSupplier val, int offset, float anchor) {
        this.resizer().left(val, offset, anchor, Unit.Measure.RELATIVE, false);
        return this.getThis();
    }

    default public W right(int val) {
        this.resizer().right(val, 0, 0.0f, Unit.Measure.PIXEL, true);
        return this.getThis();
    }

    default public W rightRel(float val) {
        this.resizer().right(val, 0, 0.0f, Unit.Measure.RELATIVE, true);
        return this.getThis();
    }

    default public W rightRelOffset(float val, int offset) {
        this.resizer().right(val, offset, 0.0f, Unit.Measure.RELATIVE, true);
        return this.getThis();
    }

    default public W rightRelAnchor(float val, float anchor) {
        this.resizer().right(val, 0, anchor, Unit.Measure.RELATIVE, false);
        return this.getThis();
    }

    default public W rightRel(float val, int offset, float anchor) {
        this.resizer().right(val, offset, anchor, Unit.Measure.RELATIVE, false);
        return this.getThis();
    }

    default public W right(float val, int offset, float anchor, Unit.Measure measure) {
        this.resizer().right(val, offset, anchor, measure, false);
        return this.getThis();
    }

    default public W right(DoubleSupplier val, Unit.Measure measure) {
        this.resizer().right(val, 0, 0.0f, measure, true);
        return this.getThis();
    }

    default public W rightRelOffset(DoubleSupplier val, int offset) {
        this.resizer().right(val, offset, 0.0f, Unit.Measure.RELATIVE, true);
        return this.getThis();
    }

    default public W rightRelAnchor(DoubleSupplier val, float anchor) {
        this.resizer().right(val, 0, anchor, Unit.Measure.RELATIVE, false);
        return this.getThis();
    }

    default public W rightRel(DoubleSupplier val, int offset, float anchor) {
        this.resizer().right(val, offset, anchor, Unit.Measure.RELATIVE, false);
        return this.getThis();
    }

    default public W top(int val) {
        this.resizer().top(val, 0, 0.0f, Unit.Measure.PIXEL, true);
        return this.getThis();
    }

    default public W topRel(float val) {
        this.resizer().top(val, 0, 0.0f, Unit.Measure.RELATIVE, true);
        return this.getThis();
    }

    default public W topRelOffset(float val, int offset) {
        this.resizer().top(val, offset, 0.0f, Unit.Measure.RELATIVE, true);
        return this.getThis();
    }

    default public W topRelAnchor(float val, float anchor) {
        this.resizer().top(val, 0, anchor, Unit.Measure.RELATIVE, false);
        return this.getThis();
    }

    default public W topRel(float val, int offset, float anchor) {
        this.resizer().top(val, offset, anchor, Unit.Measure.RELATIVE, false);
        return this.getThis();
    }

    default public W top(float val, int offset, float anchor, Unit.Measure measure) {
        this.resizer().top(val, offset, anchor, measure, false);
        return this.getThis();
    }

    default public W top(DoubleSupplier val, Unit.Measure measure) {
        this.resizer().top(val, 0, 0.0f, measure, true);
        return this.getThis();
    }

    default public W topRelOffset(DoubleSupplier val, int offset) {
        this.resizer().top(val, offset, 0.0f, Unit.Measure.RELATIVE, true);
        return this.getThis();
    }

    default public W topRelAnchor(DoubleSupplier val, float anchor) {
        this.resizer().top(val, 0, anchor, Unit.Measure.RELATIVE, false);
        return this.getThis();
    }

    default public W topRel(DoubleSupplier val, int offset, float anchor) {
        this.resizer().top(val, offset, anchor, Unit.Measure.RELATIVE, false);
        return this.getThis();
    }

    default public W bottom(int val) {
        this.resizer().bottom(val, 0, 0.0f, Unit.Measure.PIXEL, true);
        return this.getThis();
    }

    default public W bottomRel(float val) {
        this.resizer().bottom(val, 0, 0.0f, Unit.Measure.RELATIVE, true);
        return this.getThis();
    }

    default public W bottomRelOffset(float val, int offset) {
        this.resizer().bottom(val, offset, 0.0f, Unit.Measure.RELATIVE, true);
        return this.getThis();
    }

    default public W bottomRelAnchor(float val, float anchor) {
        this.resizer().bottom(val, 0, anchor, Unit.Measure.RELATIVE, false);
        return this.getThis();
    }

    default public W bottomRel(float val, int offset, float anchor) {
        this.resizer().bottom(val, offset, anchor, Unit.Measure.RELATIVE, false);
        return this.getThis();
    }

    default public W bottom(float val, int offset, float anchor, Unit.Measure measure) {
        this.resizer().bottom(val, offset, anchor, measure, false);
        return this.getThis();
    }

    default public W bottom(DoubleSupplier val, Unit.Measure measure) {
        this.resizer().bottom(val, 0, 0.0f, measure, true);
        return this.getThis();
    }

    default public W bottomRelOffset(DoubleSupplier val, int offset) {
        this.resizer().bottom(val, offset, 0.0f, Unit.Measure.RELATIVE, true);
        return this.getThis();
    }

    default public W bottomRelAnchor(DoubleSupplier val, float anchor) {
        this.resizer().bottom(val, 0, anchor, Unit.Measure.RELATIVE, false);
        return this.getThis();
    }

    default public W bottomRel(DoubleSupplier val, int offset, float anchor) {
        this.resizer().bottom(val, offset, anchor, Unit.Measure.RELATIVE, false);
        return this.getThis();
    }

    default public W width(int val) {
        this.resizer().width(val, 0, Unit.Measure.PIXEL);
        return this.getThis();
    }

    default public W widthRel(float val) {
        this.resizer().width(val, 0, Unit.Measure.RELATIVE);
        return this.getThis();
    }

    default public W widthRelOffset(float val, int offset) {
        this.resizer().width(val, offset, Unit.Measure.RELATIVE);
        return this.getThis();
    }

    default public W width(float val, Unit.Measure measure) {
        this.resizer().width(val, 0, measure);
        return this.getThis();
    }

    default public W width(DoubleSupplier val, Unit.Measure measure) {
        this.resizer().width(val, 0, measure);
        return this.getThis();
    }

    default public W height(int val) {
        this.resizer().height(val, 0, Unit.Measure.PIXEL);
        return this.getThis();
    }

    default public W heightRel(float val) {
        this.resizer().height(val, 0, Unit.Measure.RELATIVE);
        return this.getThis();
    }

    default public W height(float val, Unit.Measure measure) {
        this.resizer().height(val, 0, measure);
        return this.getThis();
    }

    default public W heightRelOffset(DoubleSupplier val, int offset) {
        this.resizer().height(val, offset, Unit.Measure.RELATIVE);
        return this.getThis();
    }

    default public W height(DoubleSupplier val, Unit.Measure measure) {
        this.resizer().height(val, 0, measure);
        return this.getThis();
    }

    default public W pos(int x, int y) {
        this.left(x).top(y);
        return this.getThis();
    }

    default public W posRel(float x, float y) {
        this.leftRel(x).topRel(y);
        return this.getThis();
    }

    default public W size(int w, int h) {
        this.width(w).height(h);
        return this.getThis();
    }

    default public W sizeRel(float w, float h) {
        this.widthRel(w).heightRel(h);
        return this.getThis();
    }

    default public W size(int val) {
        return this.width(val).height(val);
    }

    default public W sizeRel(float val) {
        return this.widthRel(val).heightRel(val);
    }

    default public W fullWidth() {
        return this.widthRel(1.0f);
    }

    default public W fullHeight() {
        return this.heightRel(1.0f);
    }

    default public W full() {
        return this.widthRel(1.0f).heightRel(1.0f);
    }

    default public W anchorLeft(float val) {
        this.resizer().anchorLeft(val);
        return this.getThis();
    }

    default public W anchorRight(float val) {
        this.resizer().anchorRight(val);
        return this.getThis();
    }

    default public W anchorTop(float val) {
        this.resizer().anchorTop(val);
        return this.getThis();
    }

    default public W anchorBottom(float val) {
        this.resizer().anchorBottom(val);
        return this.getThis();
    }

    default public W anchor(Alignment alignment) {
        this.resizer().anchor(alignment);
        return this.getThis();
    }

    default public W alignX(float val) {
        this.leftRel(val).anchorLeft(val);
        return this.getThis();
    }

    default public W alignX(Alignment alignment) {
        return this.alignX(alignment.x);
    }

    default public W alignY(float val) {
        this.topRel(val).anchorTop(val);
        return this.getThis();
    }

    default public W alignY(Alignment alignment) {
        return this.alignY(alignment.y);
    }

    default public W align(Alignment alignment) {
        return this.alignX(alignment).alignY(alignment);
    }

    default public W horizontalCenter() {
        return this.alignX(Alignment.CENTER);
    }

    default public W verticalCenter() {
        return this.alignY(Alignment.CENTER);
    }

    default public W center() {
        return this.align(Alignment.Center);
    }

    default public W resizer(Consumer<StandardResizer> resizerConsumer) {
        resizerConsumer.accept(this.resizer());
        return this.getThis();
    }

    default public W padding(int left, int right, int top, int bottom) {
        this.getArea().getPadding().all(left, right, top, bottom);
        this.scheduleResize();
        return this.getThis();
    }

    default public W padding(int horizontal, int vertical) {
        this.getArea().getPadding().all(horizontal, vertical);
        this.scheduleResize();
        return this.getThis();
    }

    default public W padding(int all) {
        this.getArea().getPadding().all(all);
        this.scheduleResize();
        return this.getThis();
    }

    default public W paddingLeft(int val) {
        this.getArea().getPadding().left(val);
        this.scheduleResize();
        return this.getThis();
    }

    default public W paddingRight(int val) {
        this.getArea().getPadding().right(val);
        this.scheduleResize();
        return this.getThis();
    }

    default public W paddingTop(int val) {
        this.getArea().getPadding().top(val);
        this.scheduleResize();
        return this.getThis();
    }

    default public W paddingBottom(int val) {
        this.getArea().getPadding().bottom(val);
        this.scheduleResize();
        return this.getThis();
    }

    default public W margin(int left, int right, int top, int bottom) {
        this.getArea().getMargin().all(left, right, top, bottom);
        this.scheduleResize();
        return this.getThis();
    }

    default public W margin(int horizontal, int vertical) {
        this.getArea().getMargin().all(horizontal, vertical);
        this.scheduleResize();
        return this.getThis();
    }

    default public W margin(int all) {
        this.getArea().getMargin().all(all);
        this.scheduleResize();
        return this.getThis();
    }

    default public W marginLeft(int val) {
        this.getArea().getMargin().left(val);
        this.scheduleResize();
        return this.getThis();
    }

    default public W marginRight(int val) {
        this.getArea().getMargin().right(val);
        this.scheduleResize();
        return this.getThis();
    }

    default public W marginTop(int val) {
        this.getArea().getMargin().top(val);
        this.scheduleResize();
        return this.getThis();
    }

    default public W marginBottom(int val) {
        this.getArea().getMargin().bottom(val);
        this.scheduleResize();
        return this.getThis();
    }
}

