/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.api.value;

import brachy.modularui.api.value.IValue;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public interface ISyncOrValue {
    public static final ISyncOrValue EMPTY = new ISyncOrValue(){

        @Override
        @Nullable
        public <T> T castNullable(Class<T> type) {
            return null;
        }

        @Override
        public boolean isTypeOrEmpty(Class<?> type) {
            return true;
        }
    };

    @NotNull
    public static ISyncOrValue orEmpty(@Nullable ISyncOrValue syncOrValue) {
        return syncOrValue != null ? syncOrValue : EMPTY;
    }

    default public boolean isTypeOrEmpty(Class<?> type) {
        return type.isAssignableFrom(this.getClass());
    }

    @Nullable
    default public <T> T castNullable(Class<T> type) {
        return (T)(type.isAssignableFrom(this.getClass()) ? this : null);
    }

    @Nullable
    default public <V> IValue<V> castValueNullable(Class<V> valueType) {
        return null;
    }

    default public <T> T castOrThrow(Class<T> type) {
        T t = this.castNullable(type);
        if (t == null) {
            if (!this.isSyncHandler() && !this.isValueHandler()) {
                throw new IllegalStateException("Empty sync handler or value can't be used for anything.");
            }
            String self = this.isSyncHandler() ? "sync handler" : "value";
            throw new IllegalStateException("Can't cast " + self + " of type '" + this.getClass().getSimpleName() + "' to type '" + type.getSimpleName() + "'.");
        }
        return t;
    }

    default public boolean isValueOfType(Class<?> type) {
        return false;
    }

    default public boolean isSyncHandler() {
        return false;
    }

    default public boolean isValueHandler() {
        return false;
    }
}

