/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.api.layout;

import brachy.modularui.api.layout.IViewportStack;
import brachy.modularui.api.widget.IWidget;
import brachy.modularui.screen.viewport.ModularGuiContext;
import brachy.modularui.utils.HoveredWidgetList;
import java.util.function.Predicate;

public interface IViewport
extends IWidget {
    default public void transformChildren(IViewportStack stack) {
    }

    default public void getWidgetsAt(IViewportStack stack, HoveredWidgetList widgets, int x, int y) {
        if (this.hasChildren()) {
            IViewport.getChildrenAt(this, stack, widgets, x, y);
        }
    }

    default public void getSelfAt(IViewportStack stack, HoveredWidgetList widgets, int x, int y) {
        if (this.isInside(stack, x, y)) {
            widgets.add(this, stack, this.getAdditionalHoverInfo(stack, x, y));
        }
    }

    default public void preDraw(ModularGuiContext context, boolean transformed) {
    }

    default public void postDraw(ModularGuiContext context, boolean transformed) {
    }

    public static void getChildrenAt(IWidget parent, IViewportStack stack, HoveredWidgetList widgetList, int x, int y) {
        for (IWidget child : parent.getChildren()) {
            if (!child.isEnabled()) continue;
            if (child instanceof IViewport) {
                IViewport viewport = (IViewport)child;
                stack.pushViewport(viewport, parent.getArea());
                child.transform(stack);
                viewport.getSelfAt(stack, widgetList, x, y);
                viewport.transformChildren(stack);
                viewport.getWidgetsAt(stack, widgetList, x, y);
                stack.popViewport(viewport);
                continue;
            }
            stack.pushMatrix();
            child.transform(stack);
            if (child.isInside(stack, x, y)) {
                widgetList.add(child, stack, child.getAdditionalHoverInfo(stack, x, y));
            }
            if (child.hasChildren()) {
                IViewport.getChildrenAt(child, stack, widgetList, x, y);
            }
            stack.popMatrix();
        }
    }

    public static boolean forEachChild(IViewportStack stack, IWidget parent, Predicate<IWidget> predicate, int context) {
        for (IWidget child : parent.getChildren()) {
            if (!child.isEnabled()) continue;
            stack.popMatrix();
            if (child instanceof IViewport) {
                IViewport viewport = (IViewport)child;
                stack.pushViewport(viewport, parent.getArea());
                parent.transform(stack);
                if (!predicate.test(child)) {
                    stack.popViewport(viewport);
                    return false;
                }
                viewport.transformChildren(parent.getContext());
                if (child.hasChildren() && !IViewport.forEachChild(stack, child, predicate, context)) {
                    stack.popViewport(viewport);
                    return false;
                }
                stack.popViewport(viewport);
                continue;
            }
            stack.pushMatrix();
            parent.transform(stack);
            if (!predicate.test(child)) {
                stack.popMatrix();
                return false;
            }
            if (child.hasChildren() && !IViewport.forEachChild(stack, child, predicate, context)) {
                stack.popMatrix();
                return false;
            }
            stack.popMatrix();
        }
        return true;
    }
}

