/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import org.jetbrains.annotations.ApiStatus;

public interface IJsonSerializable<T extends IJsonSerializable<T>> {
    @ApiStatus.OverrideOnly
    default public Codec<T> getCodec() {
        return Codec.PASSTHROUGH.flatComapMap(dynamic -> {
            this.loadFromJson(((JsonElement)dynamic.cast((DynamicOps)JsonOps.INSTANCE)).getAsJsonObject());
            return this;
        }, object -> {
            JsonObject jsonObject = new JsonObject();
            if (this.saveToJson(jsonObject)) {
                return DataResult.success((Object)new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject));
            }
            return DataResult.error(() -> "Failed to serialize drawable %s".formatted(object));
        });
    }

    default public void loadFromJson(JsonObject json) {
    }

    default public boolean saveToJson(JsonObject json) {
        return false;
    }
}

