/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.animation;

import brachy.modularui.animation.BaseAnimator;
import brachy.modularui.animation.IAnimator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SequentialAnimator
extends BaseAnimator<SequentialAnimator>
implements IAnimator {
    private final List<IAnimator> animators;
    private int currentIndex = 0;

    public SequentialAnimator(List<IAnimator> animators) {
        this.animators = new ArrayList<IAnimator>(animators);
        this.animators.forEach(animator -> {
            if (animator instanceof BaseAnimator) {
                BaseAnimator baseAnimator = (BaseAnimator)animator;
                baseAnimator.setParent(this);
            }
        });
    }

    public SequentialAnimator(IAnimator ... animators) {
        this.animators = new ArrayList<IAnimator>();
        Collections.addAll(this.animators, animators);
        this.animators.forEach(animator -> {
            if (animator instanceof BaseAnimator) {
                BaseAnimator baseAnimator = (BaseAnimator)animator;
                baseAnimator.setParent(this);
            }
        });
    }

    @Override
    public void animate(boolean reverse) {
        if (this.animators.isEmpty()) {
            return;
        }
        super.animate(reverse);
        this.animators.get(this.currentIndex).animate(reverse);
    }

    @Override
    public void reset(boolean atEnd) {
        super.reset(atEnd);
        this.currentIndex = atEnd ? this.animators.size() - 1 : 0;
        this.animators.forEach(animator -> animator.reset(atEnd));
    }

    @Override
    public void resume(boolean reverse) {
        super.resume(reverse);
        this.animators.get(this.currentIndex).resume(reverse);
    }

    @Override
    public int advance(int elapsedTime) {
        while (this.isAnimating() && elapsedTime > 0) {
            IAnimator animator = this.animators.get(this.currentIndex);
            elapsedTime = animator.advance(elapsedTime);
            if (animator.isAnimating()) continue;
            this.currentIndex += this.getDirection();
            if (this.currentIndex >= this.animators.size() || this.currentIndex < 0) {
                this.stop(false);
                continue;
            }
            animator = this.animators.get(this.currentIndex);
            animator.animate(this.isAnimatingReverse());
        }
        return elapsedTime;
    }

    @Override
    public boolean hasProgressed() {
        return !this.animators.isEmpty() && this.animators.get(0).hasProgressed();
    }

    @Override
    public SequentialAnimator followedBy(IAnimator animator) {
        if (this.isAnimating()) {
            throw new IllegalStateException("Can't add animators while animating");
        }
        this.reset();
        this.animators.add(animator);
        return this;
    }
}

