/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.animation;

import brachy.modularui.animation.IAnimator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class AnimatorManager {
    private static final List<IAnimator> animators = new ArrayList<IAnimator>(16);
    private static final List<IAnimator> queuedAnimators = new ArrayList<IAnimator>(8);
    private static long lastTime = 0L;
    private static boolean waitClearAnimators = false;

    static void startAnimation(IAnimator animator) {
        if (!animators.contains(animator) && !queuedAnimators.contains(animator)) {
            queuedAnimators.add(animator);
        }
    }

    private AnimatorManager() {
    }

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new AnimatorManager());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onDraw(ScreenEvent.Render.Pre event) {
        long time = Util.m_137550_();
        int elapsedTime = IAnimator.getTimeDiff(lastTime, time);
        AnimatorManager.checkClearAnimators();
        if (lastTime > 0L && !animators.isEmpty()) {
            animators.removeIf(animator -> {
                if (animator == null) {
                    return true;
                }
                if (animator.isPaused()) {
                    return false;
                }
                animator.advance(elapsedTime);
                return !animator.isAnimating();
            });
        }
        lastTime = time;
        animators.addAll(queuedAnimators);
        queuedAnimators.clear();
        AnimatorManager.checkClearAnimators();
    }

    private static void checkClearAnimators() {
        if (waitClearAnimators) {
            waitClearAnimators = false;
            animators.forEach(iAnimator -> iAnimator.stop(false));
            animators.clear();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onClose(ScreenEvent.Closing event) {
        waitClearAnimators = true;
    }
}

