/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.animation;

import brachy.modularui.animation.BaseAnimator;
import brachy.modularui.animation.IAnimator;
import brachy.modularui.api.drawable.IInterpolation;
import brachy.modularui.utils.Interpolation;
import java.util.function.DoubleConsumer;
import java.util.function.DoublePredicate;
import lombok.Generated;

public class Animator
extends BaseAnimator<Animator>
implements IAnimator {
    private float min = 0.0f;
    private float max = 1.0f;
    private int duration = 250;
    private IInterpolation curve = Interpolation.LINEAR;
    private DoublePredicate onUpdate;
    private Runnable onFinish;
    private int progress = 0;

    @Override
    public void reset(boolean atEnd) {
        super.reset(atEnd);
        this.progress = atEnd ? this.duration : 0;
    }

    public Animator copy(boolean reversed) {
        Animator animator = ((Animator)((Animator)new Animator().curve(this.curve).reverseOnFinish(this.reverseOnFinish)).repeatsOnFinish(this.repeats)).onUpdate(this.onUpdate).duration(this.duration).onFinish(this.onFinish);
        if (reversed) {
            animator.bounds(this.max, this.min);
        } else {
            animator.bounds(this.min, this.max);
        }
        return animator;
    }

    @Override
    public int advance(int elapsedTime) {
        if (!this.isAnimating()) {
            return elapsedTime;
        }
        while (elapsedTime > 0) {
            int max = this.isAnimatingForward() ? this.duration - this.progress : this.progress;
            int prog = Math.min(max, elapsedTime);
            this.progress += prog * this.getDirection();
            elapsedTime -= prog;
            if (this.onUpdate()) {
                this.stop(true);
                break;
            }
            if ((!this.isAnimatingForward() || this.progress < this.duration) && (!this.isAnimatingReverse() || this.progress > 0)) continue;
            this.stop(false);
            if (this.isAnimating()) continue;
            this.onAnimationFinished(true, true);
            break;
        }
        return elapsedTime;
    }

    protected boolean onUpdate() {
        return this.onUpdate != null && this.onUpdate.test(this.getRawValue());
    }

    @Override
    protected void onAnimationFinished(boolean finishedOneCycle, boolean finishedAllRepeats) {
        if (this.onFinish != null) {
            this.onFinish.run();
        }
    }

    public boolean isAtEnd() {
        return this.progress >= this.duration;
    }

    public boolean isAtStart() {
        return this.progress <= 0;
    }

    protected float getRawValue() {
        return this.curve.interpolate(this.min, this.max, (float)this.progress / (float)this.duration);
    }

    public float getValue() {
        return this.getRawValue();
    }

    @Override
    public boolean hasProgressed() {
        if (!this.isAnimating()) {
            return false;
        }
        return this.isAnimatingForward() ? this.progress > 0 : this.progress < this.duration;
    }

    public Animator min(float min) {
        this.min = min;
        return this;
    }

    public Animator max(float max) {
        this.max = max;
        return this;
    }

    public Animator bounds(float min, float max) {
        this.min = min;
        this.max = max;
        return this;
    }

    public Animator duration(int duration) {
        this.duration = duration;
        return this;
    }

    public Animator curve(IInterpolation curve) {
        this.curve = curve;
        return this;
    }

    public Animator onUpdate(DoublePredicate onUpdate) {
        this.onUpdate = onUpdate;
        return this;
    }

    public Animator onUpdate(DoubleConsumer onUpdate) {
        return this.onUpdate((double val) -> {
            onUpdate.accept(val);
            return false;
        });
    }

    public Animator onFinish(Runnable onFinish) {
        this.onFinish = onFinish;
        return this;
    }

    @Generated
    public float getMin() {
        return this.min;
    }

    @Generated
    public float getMax() {
        return this.max;
    }

    @Generated
    public int getDuration() {
        return this.duration;
    }

    @Generated
    public IInterpolation getCurve() {
        return this.curve;
    }
}

